/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.gradle;

import groovy.lang.Closure;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.teavm.gradle.TeaVMBaseExtensionImpl;
import org.teavm.gradle.api.JSModuleType;
import org.teavm.gradle.api.OptimizationLevel;
import org.teavm.gradle.api.SourceFilePolicy;
import org.teavm.gradle.api.TeaVMCConfiguration;
import org.teavm.gradle.api.TeaVMCommonConfiguration;
import org.teavm.gradle.api.TeaVMExtension;
import org.teavm.gradle.api.TeaVMJSConfiguration;
import org.teavm.gradle.api.TeaVMWasiConfiguration;
import org.teavm.gradle.api.TeaVMWasmConfiguration;

class TeaVMExtensionImpl
extends TeaVMBaseExtensionImpl
implements TeaVMExtension {
    private TeaVMJSConfiguration js;
    private TeaVMWasmConfiguration wasm;
    private TeaVMWasiConfiguration wasi;
    private TeaVMCConfiguration c;
    private TeaVMCommonConfiguration all;

    TeaVMExtensionImpl(Project project, ObjectFactory objectFactory) {
        super(project, objectFactory);
        this.js = (TeaVMJSConfiguration)objectFactory.newInstance(TeaVMJSConfiguration.class, new Object[0]);
        this.wasm = (TeaVMWasmConfiguration)objectFactory.newInstance(TeaVMWasmConfiguration.class, new Object[0]);
        this.wasi = (TeaVMWasiConfiguration)objectFactory.newInstance(TeaVMWasiConfiguration.class, new Object[0]);
        this.c = (TeaVMCConfiguration)objectFactory.newInstance(TeaVMCConfiguration.class, new Object[0]);
        this.all = (TeaVMCommonConfiguration)objectFactory.newInstance(TeaVMCommonConfiguration.class, new Object[0]);
        this.inherit(this.js, this.all);
        this.inherit(this.wasm, this.all);
        this.inherit(this.wasi, this.all);
        this.inherit(this.c, this.all);
        this.setupDefaults();
    }

    private void setupDefaults() {
        this.setupJsDefaults();
        this.setupWasmDefaults();
        this.setupWasiDefaults();
        this.setupCDefaults();
        this.setupAllDefaults();
    }

    private void setupJsDefaults() {
        this.js.getRelativePathInOutputDir().convention((Object)"js");
        this.js.getObfuscated().convention(this.property("js.obfuscated").map(Boolean::parseBoolean).orElse((Object)true));
        this.js.getSourceMap().convention(this.property("js.sourceMap").map(Boolean::parseBoolean).orElse((Object)false));
        this.js.getStrict().convention(this.property("js.strict").map(Boolean::parseBoolean).orElse((Object)false));
        this.js.getModuleType().convention(this.property("js.moduleType").map(JSModuleType::valueOf).orElse((Object)JSModuleType.UMD));
        this.js.getEntryPointName().convention((Object)"main");
        this.js.getTargetFileName().convention(this.project.provider(() -> this.project.getName() + ".js"));
        this.js.getAddedToWebApp().convention(this.property("js.addedToWebApp").map(Boolean::parseBoolean).orElse((Object)false));
        this.js.getOptimization().convention(this.property("js.optimization").map(OptimizationLevel::valueOf).orElse((Object)OptimizationLevel.BALANCED));
        this.js.getSourceFilePolicy().convention(this.property("js.sourceFilePolicy").map(SourceFilePolicy::valueOf).orElse((Object)SourceFilePolicy.DO_NOTHING));
    }

    private void setupWasmDefaults() {
        this.wasm.getRelativePathInOutputDir().convention((Object)"wasm");
        this.wasm.getMinHeapSize().convention((Object)1);
        this.wasm.getMaxHeapSize().convention((Object)16);
        this.wasm.getOptimization().convention(this.property("wasm.optimization").map(OptimizationLevel::valueOf).orElse((Object)OptimizationLevel.AGGRESSIVE));
        this.wasm.getTargetFileName().convention(this.project.provider(() -> this.project.getName() + ".wasm"));
        this.wasm.getAddedToWebApp().convention(this.property("wasm.addedToWebApp").map(Boolean::parseBoolean).orElse((Object)false));
    }

    private void setupWasiDefaults() {
        this.wasi.getRelativePathInOutputDir().convention((Object)"wasi");
        this.wasi.getMinHeapSize().convention((Object)1);
        this.wasi.getMaxHeapSize().convention((Object)16);
        this.wasi.getOptimization().convention(this.property("wasi.optimization").map(OptimizationLevel::valueOf).orElse((Object)OptimizationLevel.AGGRESSIVE));
        this.wasi.getTargetFileName().convention(this.project.provider(() -> this.project.getName() + ".wasm"));
    }

    private void setupCDefaults() {
        this.c.getRelativePathInOutputDir().convention((Object)"c");
        this.c.getMinHeapSize().convention((Object)1);
        this.c.getMaxHeapSize().convention((Object)16);
        this.c.getHeapDump().convention(this.property("c.heapDump").map(Boolean::parseBoolean).orElse((Object)false));
        this.c.getShortFileNames().convention(this.property("c.shortFileName").map(Boolean::parseBoolean).orElse((Object)true));
        this.c.getOptimization().convention(this.property("c.optimization").map(OptimizationLevel::valueOf).orElse((Object)OptimizationLevel.AGGRESSIVE));
        this.c.getObfuscated().convention((Object)true);
    }

    private void setupAllDefaults() {
        this.all.getOutputDir().convention(this.project.getLayout().getBuildDirectory().dir("generated/teavm"));
        this.all.getDebugInformation().convention(this.property("debugInformation").map(Boolean::parseBoolean).orElse((Object)false));
        this.all.getOptimization().convention((Object)OptimizationLevel.BALANCED);
        this.all.getFastGlobalAnalysis().convention(this.property("fastGlobalAnalysis").map(Boolean::parseBoolean).orElse((Object)false));
        this.all.getOutOfProcess().convention(this.property("outOfProcess").map(Boolean::parseBoolean).orElse((Object)false));
        this.all.getProcessMemory().convention(this.property("processMemory").map(Integer::parseInt).orElse((Object)512));
    }

    @Override
    public TeaVMJSConfiguration getJs() {
        return this.js;
    }

    @Override
    public void js(Action<TeaVMJSConfiguration> action) {
        action.execute((Object)this.getJs());
    }

    @Override
    public void js(Closure<?> action) {
        action.rehydrate((Object)this.getJs(), action.getOwner(), action.getThisObject()).call();
    }

    @Override
    public TeaVMWasmConfiguration getWasm() {
        return this.wasm;
    }

    @Override
    public void wasm(Action<TeaVMWasmConfiguration> action) {
        action.execute((Object)this.getWasm());
    }

    @Override
    public void wasm(Closure<?> action) {
        action.rehydrate((Object)this.getWasm(), action.getOwner(), action.getThisObject()).call();
    }

    @Override
    public TeaVMWasiConfiguration getWasi() {
        return this.wasi;
    }

    @Override
    public void wasi(Action<TeaVMWasiConfiguration> action) {
        action.execute((Object)this.wasi);
    }

    @Override
    public void wasi(Closure<?> action) {
        action.rehydrate((Object)this.getWasi(), action.getOwner(), action.getThisObject()).call();
    }

    @Override
    public TeaVMCConfiguration getC() {
        return this.c;
    }

    @Override
    public void c(Action<TeaVMCConfiguration> action) {
        action.execute((Object)this.c);
    }

    @Override
    public void c(Closure<?> action) {
        action.rehydrate((Object)this.getC(), action.getOwner(), action.getThisObject()).call();
    }

    @Override
    public TeaVMCommonConfiguration getAll() {
        return this.all;
    }

    @Override
    public void all(Action<TeaVMCommonConfiguration> action) {
        action.execute((Object)this.getAll());
    }

    @Override
    public void all(Closure<?> action) {
        action.rehydrate((Object)this.getAll(), action.getOwner(), action.getThisObject()).call();
    }

    private void inherit(TeaVMCommonConfiguration target, TeaVMCommonConfiguration source) {
        target.getMainClass().convention(source.getMainClass());
        target.getOutputDir().convention((Provider)source.getOutputDir());
        target.getDebugInformation().convention(source.getDebugInformation());
        target.getFastGlobalAnalysis().convention(source.getFastGlobalAnalysis());
        target.getOptimization().convention(source.getOptimization());
        target.getProperties().putAll(source.getProperties());
        target.getOutOfProcess().convention(source.getOutOfProcess());
        target.getProcessMemory().convention(source.getProcessMemory());
    }
}

