/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.gradle.tasks;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.teavm.gradle.api.JSModuleType;
import org.teavm.gradle.tasks.DevServerManager;
import org.teavm.gradle.tasks.ProjectDevServerManager;

public abstract class JavaScriptDevServerTask
extends DefaultTask {
    @Classpath
    public abstract ConfigurableFileCollection getClasspath();

    @Input
    @Optional
    public abstract Property<String> getTargetFileName();

    @Input
    @Optional
    public abstract Property<String> getTargetFilePath();

    @Input
    @Optional
    public abstract MapProperty<String, String> getProperties();

    @Input
    @Optional
    public abstract ListProperty<String> getPreservedClasses();

    @Input
    @Optional
    public abstract Property<JSModuleType> getJsModuleType();

    @Input
    public abstract Property<String> getMainClass();

    @Input
    @Optional
    public abstract Property<Boolean> getStackDeobfuscated();

    @Input
    @Optional
    public abstract Property<Boolean> getIndicator();

    @Input
    @Optional
    public abstract Property<Integer> getPort();

    @InputFiles
    public abstract ConfigurableFileCollection getSourceFiles();

    @Input
    @Optional
    public abstract Property<Boolean> getAutoReload();

    @Input
    @Optional
    public abstract Property<String> getProxyUrl();

    @Input
    @Optional
    public abstract Property<String> getProxyPath();

    @Input
    @Optional
    public abstract Property<Integer> getProcessMemory();

    @Classpath
    public abstract ConfigurableFileCollection getServerClasspath();

    @Internal
    public abstract Property<Integer> getServerDebugPort();

    @Inject
    protected abstract ProgressLoggerFactory getProgressLoggerFactory();

    @TaskAction
    public void compileInCodeServer() throws IOException {
        DevServerManager codeServerManager = DevServerManager.instance();
        codeServerManager.cleanup(this.getProject().getGradle());
        ProjectDevServerManager pm = codeServerManager.getProjectManager(this.getProject().getPath());
        pm.setClasspath(this.getClasspath().getFiles());
        pm.setSources(this.getSourceFiles().getFiles());
        if (this.getTargetFileName().isPresent()) {
            pm.setTargetFileName((String)this.getTargetFileName().get());
        }
        if (this.getTargetFilePath().isPresent()) {
            pm.setTargetFilePath((String)this.getTargetFilePath().get());
        }
        pm.setProperties((Map)this.getProperties().get());
        pm.setPreservedClasses((Collection)this.getPreservedClasses().get());
        if (this.getJsModuleType().isPresent()) {
            pm.setJsModuleType((JSModuleType)((Object)this.getJsModuleType().get()));
        }
        pm.setServerClasspath(this.getServerClasspath().getFiles());
        pm.setMainClass((String)this.getMainClass().get());
        pm.setStackDeobfuscated(!this.getStackDeobfuscated().isPresent() || (Boolean)this.getStackDeobfuscated().get() != false);
        pm.setIndicator(this.getIndicator().isPresent() && (Boolean)this.getIndicator().get() != false);
        pm.setAutoReload(this.getAutoReload().isPresent() && (Boolean)this.getAutoReload().get() != false);
        if (this.getPort().isPresent()) {
            pm.setPort((Integer)this.getPort().get());
        }
        if (this.getProxyUrl().isPresent()) {
            pm.setProxyUrl((String)this.getProxyUrl().get());
        }
        if (this.getProxyPath().isPresent()) {
            pm.setProxyPath((String)this.getProxyPath().get());
        }
        if (this.getProcessMemory().isPresent()) {
            pm.setProcessMemory((Integer)this.getProcessMemory().get());
        }
        if (this.getServerDebugPort().isPresent()) {
            pm.setDebugPort((Integer)this.getServerDebugPort().get());
        }
        ProgressLogger progress = this.getProgressLoggerFactory().newOperation(((Object)((Object)this)).getClass());
        progress.start("Compilation", this.getName());
        pm.runBuild(this.getLogger(), progress);
        progress.completed();
    }
}

