/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.gradle.tasks;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class CopyWasmGCRuntimeTask
extends DefaultTask {
    public CopyWasmGCRuntimeTask() {
        this.getModular().convention((Object)false);
        this.getObfuscated().convention((Object)true);
        this.getDeobfuscator().convention((Object)false);
    }

    @Input
    public abstract Property<Boolean> getModular();

    @Input
    public abstract Property<Boolean> getObfuscated();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @Input
    public abstract Property<Boolean> getDeobfuscator();

    @OutputFile
    public abstract RegularFileProperty getDeobfuscatorOutputFile();

    @TaskAction
    public void copyRuntime() throws IOException {
        StringBuilder name = new StringBuilder("wasm-gc");
        if (((Boolean)this.getModular().get()).booleanValue()) {
            name.append("-module");
        }
        name.append("-runtime");
        if (((Boolean)this.getObfuscated().get()).booleanValue()) {
            name.append(".min");
        }
        Object resourceName = "org/teavm/backend/wasm/" + String.valueOf(name) + ".js";
        ClassLoader classLoader = CopyWasmGCRuntimeTask.class.getClassLoader();
        File output = ((RegularFile)this.getOutputFile().get()).getAsFile();
        try (InputStream input = classLoader.getResourceAsStream((String)resourceName);){
            Files.copy(input, output.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        if (((Boolean)this.getDeobfuscator().get()).booleanValue()) {
            resourceName = "org/teavm/backend/wasm/deobfuscator.wasm";
            output = ((RegularFile)this.getDeobfuscatorOutputFile().get()).getAsFile();
            input = classLoader.getResourceAsStream((String)resourceName);
            try {
                Files.copy(input, output.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
    }
}

