/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.gradle.tasks;

import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.teavm.gradle.api.JSModuleType;
import org.teavm.gradle.api.SourceFilePolicy;
import org.teavm.gradle.tasks.TaskUtils;
import org.teavm.gradle.tasks.TeaVMTask;
import org.teavm.tooling.TeaVMTargetType;
import org.teavm.tooling.builder.BuildStrategy;

public abstract class GenerateJavaScriptTask
extends TeaVMTask {
    public GenerateJavaScriptTask() {
        this.getObfuscated().convention((Object)true);
        this.getStrict().convention((Object)false);
        this.getModuleType().convention((Object)JSModuleType.UMD);
        this.getSourceMap().convention((Object)false);
        this.getSourceFilePolicy().convention((Object)SourceFilePolicy.LINK_LOCAL_FILES);
        this.getEntryPointName().convention((Object)"main");
    }

    @Input
    @Optional
    public abstract Property<Boolean> getObfuscated();

    @Input
    @Optional
    public abstract Property<Boolean> getStrict();

    @Input
    @Optional
    public abstract Property<JSModuleType> getModuleType();

    @Input
    @Optional
    public abstract Property<Boolean> getSourceMap();

    @Input
    @Optional
    public abstract Property<String> getEntryPointName();

    @InputFiles
    public abstract ConfigurableFileCollection getSourceFiles();

    @Input
    @Optional
    public abstract Property<SourceFilePolicy> getSourceFilePolicy();

    @Input
    @Optional
    public abstract Property<Integer> getMaxTopLevelNames();

    @Override
    protected void setupBuilder(BuildStrategy builder) {
        builder.setTargetType(TeaVMTargetType.JAVASCRIPT);
        builder.setObfuscated(((Boolean)this.getObfuscated().get()).booleanValue());
        builder.setStrict(((Boolean)this.getStrict().get()).booleanValue());
        if (this.getMaxTopLevelNames().isPresent()) {
            builder.setMaxTopLevelNames(((Integer)this.getMaxTopLevelNames().get()).intValue());
        }
        switch ((JSModuleType)((Object)this.getModuleType().get())) {
            case UMD: {
                builder.setJsModuleType(org.teavm.backend.javascript.JSModuleType.UMD);
                break;
            }
            case COMMON_JS: {
                builder.setJsModuleType(org.teavm.backend.javascript.JSModuleType.COMMON_JS);
                break;
            }
            case NONE: {
                builder.setJsModuleType(org.teavm.backend.javascript.JSModuleType.NONE);
                break;
            }
            case ES2015: {
                builder.setJsModuleType(org.teavm.backend.javascript.JSModuleType.ES2015);
            }
        }
        builder.setSourceMapsFileGenerated(((Boolean)this.getSourceMap().get()).booleanValue());
        builder.setEntryPointName((String)this.getEntryPointName().get());
        TaskUtils.applySourceFiles(this.getSourceFiles(), builder);
        TaskUtils.applySourceFilePolicy(this.getSourceFilePolicy(), builder);
    }
}

