/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.gradle.tasks;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.teavm.gradle.tasks.ProjectDevServerManager;

public final class DevServerManager {
    private static DevServerManager instance;
    private final ConcurrentMap<String, ProjectDevServerManager> projectManagers = new ConcurrentHashMap<String, ProjectDevServerManager>();

    private DevServerManager() {
    }

    public ProjectDevServerManager getProjectManager(String path) {
        return this.projectManagers.computeIfAbsent(path, this::createProjectManager);
    }

    private ProjectDevServerManager createProjectManager(String path) {
        return new ProjectDevServerManager();
    }

    public void cleanup(Gradle gradle) {
        HashSet<String> allProjectPaths = new HashSet<String>();
        DevServerManager.collectProjects(gradle.getRootProject(), allProjectPaths);
        HashSet keysToRemove = new HashSet(this.projectManagers.keySet());
        keysToRemove.removeAll(allProjectPaths);
        for (String path : keysToRemove) {
            ProjectDevServerManager pm = (ProjectDevServerManager)this.projectManagers.remove(path);
            if (pm == null) continue;
            pm.stop(gradle.getRootProject().getLogger());
        }
    }

    public static DevServerManager instance() {
        if (instance == null) {
            instance = new DevServerManager();
        }
        return instance;
    }

    private static void collectProjects(Project project, Set<String> collector) {
        if (!collector.add(project.getPath())) {
            return;
        }
        for (Project child : project.getChildProjects().values()) {
            DevServerManager.collectProjects(child, collector);
        }
    }
}

