/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.extras.slf4j;

import org.slf4j.LoggerFactory;
import org.teavm.extras.slf4j.TeaVMLoggerFactorySubstitution;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassHolderTransformerContext;
import org.teavm.model.ClassReader;
import org.teavm.model.FieldHolder;
import org.teavm.model.FieldReader;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.util.ModelUtils;

public class LoggerFactoryTransformer
implements ClassHolderTransformer {
    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        if (!cls.getName().equals(LoggerFactory.class.getName())) {
            return;
        }
        this.substitute(cls, context.getHierarchy());
    }

    private void substitute(ClassHolder cls, ClassHierarchy hierarchy) {
        ClassReader subst = hierarchy.getClassSource().get(TeaVMLoggerFactorySubstitution.class.getName());
        for (FieldHolder fieldHolder : cls.getFields().toArray(new FieldHolder[0])) {
            cls.removeField(fieldHolder);
        }
        for (FieldHolder fieldHolder : cls.getMethods().toArray(new MethodHolder[0])) {
            cls.removeMethod((MethodHolder)fieldHolder);
        }
        for (FieldReader field : subst.getFields()) {
            cls.addField(ModelUtils.copyField((FieldReader)field));
        }
        for (MethodReader method : subst.getMethods()) {
            cls.addMethod(ModelUtils.copyMethod((MethodReader)method));
        }
    }
}

