/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.runtime;

import org.teavm.interop.Address;
import org.teavm.interop.StaticInit;
import org.teavm.interop.Structure;
import org.teavm.interop.Unmanaged;
import org.teavm.runtime.GC;
import org.teavm.runtime.RuntimeArray;
import org.teavm.runtime.RuntimeClass;
import org.teavm.runtime.RuntimeObject;

@StaticInit
@Unmanaged
public final class Allocator {
    private Allocator() {
    }

    public static Address allocate(RuntimeClass tag) {
        RuntimeObject object = GC.alloc(tag.size);
        Allocator.fillZero(object.toAddress(), tag.size);
        object.classReference = tag.pack();
        return object.toAddress();
    }

    public static Address allocateArray(RuntimeClass tag, int size) {
        int itemSize = (tag.itemType.flags & 2) != 0 ? tag.itemType.size : Address.sizeOf();
        int sizeInBytes = Address.align((Address)Address.fromInt((int)Structure.sizeOf(RuntimeArray.class)), (int)itemSize).toInt();
        sizeInBytes += itemSize * size;
        sizeInBytes = Address.align((Address)Address.fromInt((int)sizeInBytes), (int)Address.sizeOf()).toInt();
        Address result = GC.alloc(sizeInBytes).toAddress();
        Allocator.fillZero(result, sizeInBytes);
        RuntimeArray array = (RuntimeArray)result.toStructure();
        array.classReference = tag.pack();
        array.size = size;
        return result;
    }

    public static RuntimeArray allocateMultiArray(RuntimeClass tag, Address dimensions, int dimensionCount) {
        int size = dimensions.getInt();
        RuntimeArray array = (RuntimeArray)Allocator.allocateArray(tag, dimensions.getInt()).toStructure();
        if (dimensionCount > 1) {
            Address arrayData = ((RuntimeArray)Structure.add(RuntimeArray.class, (Structure)array, (int)1)).toAddress();
            arrayData = Address.align((Address)arrayData, (int)Address.sizeOf());
            for (int i = 0; i < size; ++i) {
                RuntimeArray innerArray = Allocator.allocateMultiArray(tag.itemType, dimensions.add(4), dimensionCount - 1);
                arrayData.putAddress(innerArray.toAddress());
                arrayData = arrayData.add(Address.sizeOf());
            }
        }
        return array;
    }

    public static native void fillZero(Address var0, int var1);

    public static native void fill(Address var0, byte var1, int var2);

    public static native void moveMemoryBlock(Address var0, Address var1, int var2);

    public static native boolean isInitialized(Class<?> var0);
}

