/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import java.util.Collection;
import org.teavm.cache.IncrementalDependencyRegistration;
import org.teavm.callgraph.CallGraph;
import org.teavm.common.ServiceRepository;
import org.teavm.dependency.ClassDependency;
import org.teavm.dependency.ClassDependencyInfo;
import org.teavm.dependency.DependencyAnalyzer;
import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.DependencyType;
import org.teavm.dependency.FieldDependency;
import org.teavm.dependency.FieldDependencyInfo;
import org.teavm.dependency.MethodDependency;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;

public class DependencyAgent
implements DependencyInfo,
ServiceRepository {
    private DependencyAnalyzer analyzer;

    DependencyAgent(DependencyAnalyzer analyzer) {
        this.analyzer = analyzer;
    }

    public DependencyNode createNode() {
        return this.analyzer.createNode();
    }

    public DependencyType getType(String name) {
        return this.analyzer.getType(name);
    }

    public String generateClassName() {
        return this.analyzer.generateClassName();
    }

    public String submitClassFile(byte[] data) {
        return this.analyzer.submitClassFile(data);
    }

    public void submitClass(ClassHolder cls) {
        this.analyzer.submitClass(cls);
    }

    public void submitMethod(MethodReference method, Program program) {
        this.analyzer.submitMethod(method, program);
    }

    public MethodDependency linkMethod(MethodReference methodRef) {
        return this.analyzer.linkMethod(methodRef);
    }

    public MethodDependency linkMethod(String className, MethodDescriptor descriptor) {
        return this.analyzer.linkMethod(className, descriptor);
    }

    public ClassDependency linkClass(String className) {
        return this.analyzer.linkClass(className);
    }

    public FieldDependency linkField(FieldReference fieldRef) {
        return this.analyzer.linkField(fieldRef);
    }

    public Diagnostics getDiagnostics() {
        return this.analyzer.getDiagnostics();
    }

    @Override
    public <T> T getService(Class<T> type) {
        return this.analyzer.getService(type);
    }

    @Override
    public ClassReaderSource getClassSource() {
        return this.analyzer.agentClassSource;
    }

    public ClassReaderSource getUnprocessedClassSource() {
        return this.analyzer.getUnprocessedClassSource();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.analyzer.getClassLoader();
    }

    public ClassHierarchy getClassHierarchy() {
        return this.analyzer.getClassHierarchy();
    }

    @Override
    public Collection<MethodReference> getReachableMethods() {
        return this.analyzer.getReachableMethods();
    }

    @Override
    public Collection<FieldReference> getReachableFields() {
        return this.analyzer.getReachableFields();
    }

    @Override
    public Collection<String> getReachableClasses() {
        return this.analyzer.getReachableClasses();
    }

    @Override
    public FieldDependencyInfo getField(FieldReference fieldRef) {
        return this.analyzer.getField(fieldRef);
    }

    @Override
    public MethodDependencyInfo getMethod(MethodReference methodRef) {
        return this.analyzer.getMethod(methodRef);
    }

    @Override
    public MethodDependencyInfo getMethodImplementation(MethodReference methodRef) {
        return this.analyzer.getMethodImplementation(methodRef);
    }

    @Override
    public ClassDependencyInfo getClass(String className) {
        return this.analyzer.getClass(className);
    }

    @Override
    public CallGraph getCallGraph() {
        return this.analyzer.getCallGraph();
    }

    public IncrementalDependencyRegistration getIncrementalCache() {
        return this.analyzer.incrementalCache;
    }

    void cleanup() {
        this.analyzer = null;
    }
}

