/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.transformation;

import org.teavm.backend.wasm.runtime.WasiSupport;
import org.teavm.backend.wasm.runtime.WasmSupport;
import org.teavm.interop.Import;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassHolderTransformerContext;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.ValueType;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;

public class WasiSupportClassTransformer
implements ClassHolderTransformer {
    @Override
    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        if (cls.getName().equals(WasmSupport.class.getName())) {
            this.transformWasm(cls, context.getHierarchy());
        }
    }

    private void transformWasm(ClassHolder cls, ClassHierarchy classHierarchy) {
        ClassReader sourceCls = classHierarchy.getClassSource().get(WasiSupport.class.getName());
        for (MethodHolder method : cls.getMethods()) {
            MethodReader sourceMethod = sourceCls.getMethod(method.getDescriptor());
            if (sourceMethod == null) continue;
            if (method.hasModifier(ElementModifier.NATIVE)) {
                method.getModifiers().remove((Object)ElementModifier.NATIVE);
            }
            method.getAnnotations().remove(Import.class.getName());
            ProgramEmitter pe = ProgramEmitter.create(method, classHierarchy);
            ValueEmitter[] args = new ValueEmitter[method.parameterCount()];
            for (int i = 0; i < args.length; ++i) {
                args[i] = pe.var(i + 1, method.parameterType(i));
            }
            ValueEmitter result = pe.invoke(sourceMethod.getReference(), args);
            if (method.getResultType() != ValueType.VOID) {
                result.returnValue();
                continue;
            }
            pe.exit();
        }
    }
}

