/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.model.expression;

import java.util.Objects;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmExpressionVisitor;

public class WasmConditional
extends WasmExpression {
    private WasmExpression condition;
    private WasmBlock thenBlock = new WasmBlock(false);
    private WasmBlock elseBlock = new WasmBlock(false);
    private WasmType type;

    public WasmConditional(WasmExpression condition) {
        Objects.requireNonNull(condition);
        this.condition = condition;
    }

    public WasmExpression getCondition() {
        return this.condition;
    }

    public void setCondition(WasmExpression condition) {
        Objects.requireNonNull(condition);
        this.condition = condition;
    }

    public WasmBlock getThenBlock() {
        return this.thenBlock;
    }

    public WasmBlock getElseBlock() {
        return this.elseBlock;
    }

    public WasmType getType() {
        return this.type;
    }

    public void setType(WasmType type) {
        this.type = type;
    }

    @Override
    public void acceptVisitor(WasmExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isTerminating() {
        return this.thenBlock.isTerminating() && this.elseBlock.isTerminating();
    }
}

