/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.debug.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.teavm.backend.wasm.debug.info.ArrayLayout;
import org.teavm.backend.wasm.debug.info.ClassInfo;
import org.teavm.backend.wasm.debug.info.ClassLayout;
import org.teavm.backend.wasm.debug.info.ClassLayoutInfo;
import org.teavm.backend.wasm.debug.info.FieldInfo;
import org.teavm.backend.wasm.debug.info.FieldType;
import org.teavm.backend.wasm.debug.info.InterfaceLayout;
import org.teavm.backend.wasm.debug.info.PrimitiveLayout;
import org.teavm.backend.wasm.debug.info.TypeLayout;
import org.teavm.backend.wasm.debug.info.UnknownLayout;
import org.teavm.backend.wasm.debug.parser.DebugClassParser;
import org.teavm.backend.wasm.debug.parser.DebugSectionParser;
import org.teavm.backend.wasm.debug.parser.DebugStringParser;
import org.teavm.model.PrimitiveType;

public class DebugClassLayoutParser
extends DebugSectionParser {
    private DebugStringParser strings;
    private DebugClassParser classes;
    private ArrayList<TypeLayoutImpl> types = new ArrayList();
    private List<List<Consumer<TypeLayoutImpl>>> forwardReferences = new ArrayList<List<Consumer<TypeLayoutImpl>>>();
    private int lastAddress;
    private int lastFieldOffset;
    private ClassLayoutInfoImpl classLayoutInfo;

    public DebugClassLayoutParser(DebugStringParser strings, DebugClassParser classes) {
        super("teavm_cll", strings, classes);
        this.strings = strings;
        this.classes = classes;
    }

    @Override
    protected void doParse() {
        while (this.ptr < this.data.length) {
            byte kind = this.data[this.ptr++];
            switch (kind) {
                case 0: {
                    this.parseRootClass();
                    break;
                }
                case 1: {
                    this.parseClass();
                    break;
                }
                case 2: {
                    this.parseInterface();
                    break;
                }
                case 3: {
                    this.parseArray();
                    break;
                }
                case 4: {
                    this.parsePrimitive(PrimitiveType.BOOLEAN);
                    break;
                }
                case 5: {
                    this.parsePrimitive(PrimitiveType.BYTE);
                    break;
                }
                case 6: {
                    this.parsePrimitive(PrimitiveType.SHORT);
                    break;
                }
                case 7: {
                    this.parsePrimitive(PrimitiveType.CHARACTER);
                    break;
                }
                case 8: {
                    this.parsePrimitive(PrimitiveType.INTEGER);
                    break;
                }
                case 9: {
                    this.parsePrimitive(PrimitiveType.LONG);
                    break;
                }
                case 10: {
                    this.parsePrimitive(PrimitiveType.FLOAT);
                    break;
                }
                case 11: {
                    this.parsePrimitive(PrimitiveType.DOUBLE);
                    break;
                }
                case 12: {
                    this.parseUnknown();
                }
            }
        }
        this.types.trimToSize();
        this.classLayoutInfo = new ClassLayoutInfoImpl(Collections.unmodifiableList(this.types));
    }

    public ClassLayoutInfo getInfo() {
        return this.classLayoutInfo;
    }

    private void parseRootClass() {
        ClassInfo classPtr = this.classes.getClass(this.readLEB());
        int address = this.readAddress();
        int size = this.readLEB();
        ClassLayoutImpl type = new ClassLayoutImpl(address, classPtr, size);
        this.addType(type);
        this.parseClassFields(type);
    }

    private void parseClass() {
        ClassInfo classPtr = this.classes.getClass(this.readLEB());
        int superclassIndex = this.types.size() - this.readSignedLEB();
        int address = this.readAddress();
        int size = this.readLEB();
        ClassLayoutImpl type = new ClassLayoutImpl(address, classPtr, size);
        this.addType(type);
        this.ref(superclassIndex, superclass -> {
            type.superclass = (ClassLayoutImpl)superclass;
        });
        this.parseClassFields(type);
    }

    private void parseClassFields(ClassLayoutImpl type) {
        byte fieldType;
        this.lastFieldOffset = 0;
        ArrayList<FieldInfoImpl> staticFields = new ArrayList<FieldInfoImpl>();
        while (true) {
            byte fieldType2;
            if ((fieldType2 = this.data[this.ptr++]) == 0) {
                staticFields.trimToSize();
                type.staticFields = staticFields.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(staticFields);
                type.instanceFields = Collections.emptyList();
                return;
            }
            if (fieldType2 == 1) break;
            staticFields.add(this.parseField(fieldType2));
        }
        this.lastFieldOffset = 0;
        ArrayList<FieldInfoImpl> instanceFields = new ArrayList<FieldInfoImpl>();
        while ((fieldType = this.data[this.ptr++]) != 0 && fieldType != 1) {
            instanceFields.add(this.parseField(fieldType));
        }
        staticFields.trimToSize();
        instanceFields.trimToSize();
        type.staticFields = staticFields.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(staticFields);
        type.instanceFields = instanceFields.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(instanceFields);
    }

    private FieldInfoImpl parseField(byte type) {
        int offset;
        FieldType fieldType;
        switch (type) {
            case 2: {
                fieldType = FieldType.BOOLEAN;
                break;
            }
            case 3: {
                fieldType = FieldType.BYTE;
                break;
            }
            case 4: {
                fieldType = FieldType.SHORT;
                break;
            }
            case 5: {
                fieldType = FieldType.CHAR;
                break;
            }
            case 6: {
                fieldType = FieldType.INT;
                break;
            }
            case 7: {
                fieldType = FieldType.LONG;
                break;
            }
            case 8: {
                fieldType = FieldType.FLOAT;
                break;
            }
            case 9: {
                fieldType = FieldType.DOUBLE;
                break;
            }
            case 10: {
                fieldType = FieldType.OBJECT;
                break;
            }
            case 11: {
                fieldType = FieldType.ADDRESS;
                break;
            }
            default: {
                fieldType = FieldType.UNDEFINED;
            }
        }
        String name = this.strings.getString(this.readLEB());
        this.lastFieldOffset = offset = this.lastFieldOffset + this.readSignedLEB();
        return new FieldInfoImpl(offset, name, fieldType);
    }

    private void parseInterface() {
        ClassInfo classRef = this.classes.getClass(this.readLEB());
        int address = this.readAddress();
        this.addType(new InterfaceLayoutImpl(address, classRef));
    }

    private void parseArray() {
        int elementPtr = this.types.size() - this.readSignedLEB();
        int address = this.readAddress();
        ArrayLayoutImpl type = new ArrayLayoutImpl(address);
        this.addType(type);
        this.ref(elementPtr, element -> {
            type.elementType = element;
        });
    }

    private void parsePrimitive(PrimitiveType primitiveType) {
        int address = this.readAddress();
        this.addType(new PrimitiveLayoutImpl(address, primitiveType));
    }

    private void parseUnknown() {
        int address = this.readAddress();
        this.addType(new UnknownLayoutImpl(address));
    }

    private int readAddress() {
        int result;
        this.lastAddress = result = this.readSignedLEB() + this.lastAddress;
        return result;
    }

    private void addType(TypeLayoutImpl type) {
        int index = this.types.size();
        this.types.add(type);
        if (index < this.forwardReferences.size()) {
            List<Consumer<TypeLayoutImpl>> refs = this.forwardReferences.get(index);
            this.forwardReferences.set(index, null);
            for (Consumer<TypeLayoutImpl> ref : refs) {
                ref.accept(type);
            }
        }
    }

    private void ref(int index, Consumer<TypeLayoutImpl> handler) {
        if (index < this.types.size()) {
            handler.accept(this.types.get(index));
        } else {
            List<Consumer<TypeLayoutImpl>> refs;
            if (index >= this.forwardReferences.size()) {
                this.forwardReferences.addAll(Collections.nCopies(index + 1 - this.forwardReferences.size(), null));
            }
            if ((refs = this.forwardReferences.get(index)) == null) {
                refs = new ArrayList<Consumer<TypeLayoutImpl>>();
                this.forwardReferences.set(index, refs);
            }
            refs.add(handler);
        }
    }

    private static class ClassLayoutInfoImpl
    extends ClassLayoutInfo {
        private List<TypeLayoutImpl> types;

        ClassLayoutInfoImpl(List<TypeLayoutImpl> types) {
            this.types = types;
        }

        @Override
        public List<? extends TypeLayout> types() {
            return this.types;
        }
    }

    private static class ClassLayoutImpl
    extends TypeLayoutImpl
    implements ClassLayout {
        private ClassInfo classRef;
        private List<? extends FieldInfoImpl> instanceFields;
        private List<? extends FieldInfoImpl> staticFields;
        private ClassLayoutImpl superclass;
        private int size;

        ClassLayoutImpl(int address, ClassInfo classRef, int size) {
            super(address);
            this.classRef = classRef;
            this.size = size;
        }

        @Override
        public ClassInfo classRef() {
            return this.classRef;
        }

        @Override
        public ClassLayout superclass() {
            return this.superclass;
        }

        @Override
        public Collection<? extends FieldInfo> instanceFields() {
            return this.instanceFields;
        }

        @Override
        public Collection<? extends FieldInfo> staticFields() {
            return this.staticFields;
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    private static abstract class TypeLayoutImpl
    implements TypeLayout {
        private int address;

        private TypeLayoutImpl(int address) {
            this.address = address;
        }

        @Override
        public int address() {
            return this.address;
        }
    }

    private static class FieldInfoImpl
    extends FieldInfo {
        private int address;
        private String name;
        private FieldType type;

        FieldInfoImpl(int address, String name, FieldType type) {
            this.address = address;
            this.name = name;
            this.type = type;
        }

        @Override
        public int address() {
            return this.address;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public FieldType type() {
            return this.type;
        }
    }

    private static class InterfaceLayoutImpl
    extends TypeLayoutImpl
    implements InterfaceLayout {
        private ClassInfo classRef;

        InterfaceLayoutImpl(int address, ClassInfo classRef) {
            super(address);
            this.classRef = classRef;
        }

        @Override
        public ClassInfo classRef() {
            return this.classRef;
        }
    }

    private static class ArrayLayoutImpl
    extends TypeLayoutImpl
    implements ArrayLayout {
        private TypeLayoutImpl elementType;

        ArrayLayoutImpl(int address) {
            super(address);
        }

        @Override
        public TypeLayout elementType() {
            return this.elementType;
        }
    }

    private static class PrimitiveLayoutImpl
    extends TypeLayoutImpl
    implements PrimitiveLayout {
        private PrimitiveType primitiveType;

        PrimitiveLayoutImpl(int address, PrimitiveType primitiveType) {
            super(address);
            this.primitiveType = primitiveType;
        }

        @Override
        public PrimitiveType primitiveType() {
            return this.primitiveType;
        }
    }

    private static class UnknownLayoutImpl
    extends TypeLayoutImpl
    implements UnknownLayout {
        UnknownLayoutImpl(int address) {
            super(address);
        }
    }
}

