/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.debug;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.teavm.backend.wasm.debug.DebugSectionBuilder;
import org.teavm.backend.wasm.debug.DebugStrings;
import org.teavm.backend.wasm.debug.DebugVariables;
import org.teavm.backend.wasm.debug.info.VariableType;

public class DebugVariablesBuilder
extends DebugSectionBuilder
implements DebugVariables {
    private DebugStrings strings;
    private int sequenceStart;
    private int lastSequenceStart;
    private Map<String, VarInfo> variables = new LinkedHashMap<String, VarInfo>();

    public DebugVariablesBuilder(DebugStrings strings) {
        super("teavm_var");
        this.strings = strings;
    }

    @Override
    public void startSequence(int pointer) {
        this.sequenceStart = pointer;
    }

    @Override
    public void type(String name, VariableType type) {
        this.getInfo((String)name).type = type;
    }

    @Override
    public void range(String name, int start, int end, int pointer) {
        this.getInfo((String)name).ranges.add(new Range(start, end, pointer));
    }

    private VarInfo getInfo(String name) {
        VarInfo info = this.variables.get(name);
        if (info == null) {
            info = new VarInfo();
            this.variables.put(name, info);
        }
        return info;
    }

    @Override
    public void endSequence() {
        if (this.variables.isEmpty()) {
            return;
        }
        this.blob.writeLEB(this.sequenceStart - this.lastSequenceStart);
        this.lastSequenceStart = this.sequenceStart;
        this.blob.writeLEB(this.variables.size());
        for (Map.Entry<String, VarInfo> variable : this.variables.entrySet()) {
            this.blob.writeLEB(this.strings.stringPtr(variable.getKey()));
            VarInfo info = variable.getValue();
            this.blob.writeLEB(info.type.ordinal());
            this.blob.writeLEB(info.ranges.size());
            int lastPtr = this.sequenceStart;
            int lastPointer = 0;
            for (Range range : info.ranges) {
                this.blob.writeSLEB(range.start - lastPtr);
                this.blob.writeLEB(range.end - range.start);
                this.blob.writeSLEB(range.pointer - lastPointer);
                lastPointer = range.pointer;
                lastPointer = range.end;
            }
        }
        this.variables.clear();
    }

    private static class VarInfo {
        VariableType type = VariableType.UNDEFINED;
        List<Range> ranges = new ArrayList<Range>();

        private VarInfo() {
        }
    }

    private static class Range {
        int start;
        int end;
        int pointer;

        Range(int start, int end, int pointer) {
            this.start = start;
            this.end = end;
            this.pointer = pointer;
        }
    }
}

