/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.templating;

import org.teavm.backend.javascript.ast.AstVisitor;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.rhino.javascript.ast.AstNode;
import org.teavm.rhino.javascript.ast.Block;
import org.teavm.rhino.javascript.ast.ConditionalExpression;
import org.teavm.rhino.javascript.ast.FunctionCall;
import org.teavm.rhino.javascript.ast.IfStatement;
import org.teavm.rhino.javascript.ast.InfixExpression;
import org.teavm.rhino.javascript.ast.KeywordLiteral;
import org.teavm.rhino.javascript.ast.Name;
import org.teavm.rhino.javascript.ast.Scope;
import org.teavm.rhino.javascript.ast.StringLiteral;
import org.teavm.rhino.javascript.ast.UnaryExpression;

public class TemplatingAstTransformer
extends AstVisitor {
    private ClassReaderSource classes;

    public TemplatingAstTransformer(ClassReaderSource classes) {
        this.classes = classes;
    }

    @Override
    public void visit(Block node) {
        super.visit(node);
        if (node.getFirstChild() == null) {
            this.replaceWith(null);
        } else if (node.getFirstChild() == node.getLastChild()) {
            this.replaceWith((AstNode)node.getFirstChild());
        }
    }

    @Override
    public void visit(IfStatement node) {
        super.visit(node);
        if (node.getCondition().getType() == 45) {
            this.replaceWith(node.getThenPart());
        } else if (node.getCondition().getType() == 44) {
            this.replaceWith(node.getElsePart());
        }
    }

    @Override
    public void visit(ConditionalExpression node) {
        super.visit(node);
        if (node.getTestExpression().getType() == 45) {
            this.replaceWith(node.getTrueExpression());
        } else if (node.getTestExpression().getType() == 44) {
            this.replaceWith(node.getFalseExpression());
        }
    }

    @Override
    public void visit(InfixExpression node) {
        super.visit(node);
        if (node.getType() == 109) {
            if (node.getLeft().getType() == 44) {
                this.replaceWith(node.getLeft());
            } else if (node.getRight().getType() == 44) {
                this.replaceWith(node.getRight());
            } else if (node.getLeft().getType() == 45) {
                this.replaceWith(node.getRight());
            } else if (node.getRight().getType() == 45) {
                this.replaceWith(node.getLeft());
            }
        } else if (node.getType() == 108) {
            if (node.getLeft().getType() == 45) {
                this.replaceWith(node.getLeft());
            } else if (node.getRight().getType() == 45) {
                this.replaceWith(node.getRight());
            } else if (node.getLeft().getType() == 44) {
                this.replaceWith(node.getRight());
            } else if (node.getRight().getType() == 44) {
                this.replaceWith(node.getLeft());
            }
        }
    }

    @Override
    public void visit(UnaryExpression node) {
        super.visit(node);
        if (node.getType() == 26) {
            if (node.getOperand().getType() == 45) {
                node.getOperand().setType(44);
            } else if (node.getOperand().getType() == 44) {
                node.getOperand().setType(45);
            }
        }
    }

    @Override
    public void visit(FunctionCall node) {
        Name name;
        Scope scope;
        super.visit(node);
        if (node.getTarget() instanceof Name && (scope = this.scopeOfId((name = (Name)node.getTarget()).getIdentifier())) == null) {
            this.tryIntrinsicName(node, name.getIdentifier());
        }
    }

    private void tryIntrinsicName(FunctionCall node, String identifier) {
        switch (identifier) {
            case "teavm_javaClassExists": {
                this.javaClassExists(node);
                break;
            }
            case "teavm_javaMethodExists": {
                this.javaMethodExists(node);
                break;
            }
            case "teavm_javaConstructorExists": {
                this.javaConstructorExists(node);
            }
        }
    }

    private void javaClassExists(FunctionCall node) {
        if (node.getArguments().size() != 1) {
            return;
        }
        AstNode classArg = (AstNode)node.getArguments().get(0);
        if (!(classArg instanceof StringLiteral)) {
            return;
        }
        String className = ((StringLiteral)classArg).getValue();
        boolean exists = this.classes.get(className) != null;
        this.replaceWith((AstNode)new KeywordLiteral(0, 0, exists ? 45 : 44));
    }

    private void javaMethodExists(FunctionCall node) {
        String methodName;
        if (node.getArguments().size() != 2) {
            return;
        }
        AstNode classArg = (AstNode)node.getArguments().get(0);
        AstNode methodArg = (AstNode)node.getArguments().get(1);
        if (!(classArg instanceof StringLiteral) || !(methodArg instanceof StringLiteral)) {
            return;
        }
        String className = ((StringLiteral)classArg).getValue();
        MethodReader method = this.classes.resolveImplementation(new MethodReference(className, MethodDescriptor.parse(methodName = ((StringLiteral)methodArg).getValue())));
        boolean exists = method != null && (method.getProgram() != null || method.hasModifier(ElementModifier.NATIVE));
        this.replaceWith((AstNode)new KeywordLiteral(0, 0, exists ? 45 : 44));
    }

    private void javaConstructorExists(FunctionCall node) {
        String methodName;
        if (node.getArguments().size() != 2) {
            return;
        }
        AstNode classArg = (AstNode)node.getArguments().get(0);
        AstNode methodArg = (AstNode)node.getArguments().get(1);
        if (!(classArg instanceof StringLiteral) || !(methodArg instanceof StringLiteral)) {
            return;
        }
        String className = ((StringLiteral)classArg).getValue();
        MethodReader method = this.classes.resolveImplementation(new MethodReference(className, "<init>", MethodDescriptor.parseSignature(methodName = ((StringLiteral)methodArg).getValue())));
        boolean exists = method != null && (method.getProgram() != null || method.hasModifier(ElementModifier.NATIVE));
        this.replaceWith((AstNode)new KeywordLiteral(0, 0, exists ? 45 : 44));
    }
}

