/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.codegen;

import org.teavm.backend.javascript.codegen.SourceWriterSink;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public abstract class SourceWriter
implements Appendable,
SourceWriterSink {
    public SourceWriter append(String value) {
        this.append((CharSequence)value);
        return this;
    }

    public SourceWriter appendBlockStart() {
        return this.ws().append("{").indent().softNewLine();
    }

    public SourceWriter appendBlockEnd() {
        return this.outdent().append("}").softNewLine();
    }

    public SourceWriter appendIf() {
        return this.append("if").ws().append("(");
    }

    public SourceWriter appendElseIf() {
        return this.outdent().append("}").ws().append("else ").appendIf();
    }

    public SourceWriter appendElse() {
        return this.outdent().append("}").ws().append("else").appendBlockStart();
    }

    public SourceWriter append(int value) {
        return this.append(String.valueOf(value));
    }

    @Override
    public abstract SourceWriter append(char var1);

    @Override
    public SourceWriter append(CharSequence csq) {
        this.append(csq, 0, csq.length());
        return this;
    }

    @Override
    public abstract SourceWriter append(CharSequence var1, int var2, int var3);

    @Override
    public abstract SourceWriter appendClass(String var1);

    public SourceWriter appendClass(Class<?> cls) {
        return this.appendClass(cls.getName());
    }

    @Override
    public abstract SourceWriter appendField(FieldReference var1);

    @Override
    public abstract SourceWriter appendStaticField(FieldReference var1);

    @Override
    public abstract SourceWriter appendMethod(MethodDescriptor var1);

    public SourceWriter appendMethod(String name, Class<?> ... params) {
        return this.appendMethod(new MethodDescriptor(name, params));
    }

    @Override
    public abstract SourceWriter appendMethodBody(MethodReference var1);

    public SourceWriter appendMethodBody(String className, String name, ValueType ... params) {
        return this.appendMethodBody(new MethodReference(className, new MethodDescriptor(name, params)));
    }

    public SourceWriter appendMethodBody(Class<?> cls, String name, Class<?> ... params) {
        return this.appendMethodBody(new MethodReference(cls, name, params));
    }

    @Override
    public abstract SourceWriter appendFunction(String var1);

    @Override
    public abstract SourceWriter appendGlobal(String var1);

    @Override
    public abstract SourceWriter appendInit(MethodReference var1);

    @Override
    public abstract SourceWriter appendClassInit(String var1);

    @Override
    public abstract SourceWriter newLine();

    @Override
    public abstract SourceWriter ws();

    @Override
    public abstract SourceWriter sameLineWs();

    @Override
    public abstract SourceWriter tokenBoundary();

    @Override
    public abstract SourceWriter softNewLine();

    @Override
    public abstract SourceWriter indent();

    @Override
    public abstract SourceWriter outdent();

    @Override
    public abstract SourceWriter emitLocation(String var1, int var2);

    @Override
    public abstract SourceWriter enterLocation();

    @Override
    public abstract SourceWriter exitLocation();

    @Override
    public abstract SourceWriter emitStatementStart();

    @Override
    public abstract SourceWriter emitVariables(String[] var1, String var2);

    @Override
    public abstract void emitMethod(MethodDescriptor var1);

    @Override
    public abstract void emitClass(String var1);

    @Override
    public abstract void markClassStart(String var1);

    @Override
    public abstract void markClassEnd();

    @Override
    public abstract void markSectionStart(int var1);

    @Override
    public abstract void markSectionEnd();
}

