/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.codegen;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.teavm.backend.javascript.codegen.AliasProvider;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;

public class DefaultAliasProvider
implements AliasProvider {
    private final Map<String, String> classAliases = new HashMap<String, String>();
    private final Set<String> knownAliases = new HashSet<String>(200, 0.5f);
    private final ObjectIntMap<String> knowAliasesCounter = new ObjectIntHashMap();
    private final Set<String> knownVirtualAliases = new HashSet<String>(200, 0.5f);
    private final ObjectIntMap<String> knowVirtualAliasesCounter = new ObjectIntHashMap();

    @Override
    public String getClassAlias(String cls) {
        return this.classAliases.computeIfAbsent(cls, key -> this.makeUniqueTopLevel(DefaultAliasProvider.suggestAliasForClass(key)));
    }

    private static String suggestAliasForClass(String cls) {
        StringBuilder alias = new StringBuilder();
        int lastIndex = 0;
        while (true) {
            int index;
            if ((index = cls.indexOf(46, lastIndex)) == -1) {
                if (lastIndex > 0) {
                    alias.append("_");
                }
                break;
            }
            if (index > lastIndex) {
                alias.append(cls.charAt(lastIndex));
            }
            lastIndex = index + 1;
        }
        alias.append(cls.substring(lastIndex));
        for (int i = 1; i < alias.length(); ++i) {
            char c = alias.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            alias.setCharAt(i, '_');
        }
        if (!Character.isJavaIdentifierStart(alias.charAt(0))) {
            alias.setCharAt(0, '_');
        }
        return alias.toString();
    }

    @Override
    public String getMethodAlias(MethodDescriptor method) {
        Object alias = method.getName();
        switch (alias) {
            case "<init>": {
                alias = "$_init_";
                break;
            }
            case "<clinit>": {
                alias = "$_clinit_";
                break;
            }
            default: {
                alias = "$" + (String)alias;
            }
        }
        return this.makeUnique(this.knownVirtualAliases, this.knowVirtualAliasesCounter, (String)alias);
    }

    @Override
    public String getStaticMethodAlias(MethodReference method) {
        String suggested;
        switch (suggested = method.getDescriptor().getName()) {
            case "<init>": {
                suggested = "_init_";
                break;
            }
            case "<clinit>": {
                suggested = "_clinit_";
            }
        }
        return this.makeUniqueTopLevel(this.getClassAlias(method.getClassName()) + "_" + suggested);
    }

    @Override
    public String getFieldAlias(FieldReference field) {
        return this.makeUnique(this.knownVirtualAliases, this.knowVirtualAliasesCounter, "$" + field.getFieldName());
    }

    @Override
    public String getStaticFieldAlias(FieldReference field) {
        return this.makeUniqueTopLevel(this.getClassAlias(field.getClassName()) + "_" + field.getFieldName());
    }

    @Override
    public String getFunctionAlias(String name) {
        return name;
    }

    @Override
    public String getClassInitAlias(String className) {
        return this.makeUniqueTopLevel(DefaultAliasProvider.suggestAliasForClass(className) + "_$callClinit");
    }

    @Override
    public void reserveName(String name) {
    }

    private String makeUniqueTopLevel(String suggested) {
        return this.makeUnique(this.knownAliases, this.knowAliasesCounter, suggested);
    }

    private String sanitize(String s) {
        if (s.isEmpty()) {
            return "_";
        }
        boolean changed = false;
        StringBuilder sb = new StringBuilder(s.length());
        char c = s.charAt(0);
        if (DefaultAliasProvider.isIdentifierStart(c)) {
            sb.append(c);
        } else {
            sb.append('_');
            changed = true;
        }
        for (int i = 1; i < s.length(); ++i) {
            c = s.charAt(i);
            if (DefaultAliasProvider.isIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            sb.append('_');
            changed = true;
        }
        return changed ? sb.toString() : s;
    }

    private static boolean isIdentifierStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '$';
    }

    private static boolean isIdentifierPart(char c) {
        return DefaultAliasProvider.isIdentifierStart(c) || c >= '0' && c <= '9';
    }

    private String makeUnique(Set<String> knowAliases, ObjectIntMap<String> indexMap, String alias) {
        alias = this.sanitize(alias);
        Object uniqueAlias = alias;
        int index = indexMap.get((Object)alias);
        if (index > 0) {
            uniqueAlias = alias + index++;
        }
        while (!knowAliases.add((String)uniqueAlias)) {
            uniqueAlias = alias + index++;
        }
        indexMap.put((Object)alias, index);
        return uniqueAlias;
    }
}

