/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.teavm.ast.ControlFlowEntry;
import org.teavm.backend.javascript.JSModuleType;
import org.teavm.backend.javascript.ProviderContext;
import org.teavm.backend.javascript.TeaVMJavaScriptHost;
import org.teavm.backend.javascript.codegen.AliasProvider;
import org.teavm.backend.javascript.codegen.DefaultAliasProvider;
import org.teavm.backend.javascript.codegen.DefaultNamingStrategy;
import org.teavm.backend.javascript.codegen.MinifyingAliasProvider;
import org.teavm.backend.javascript.codegen.OutputSourceWriter;
import org.teavm.backend.javascript.codegen.OutputSourceWriterBuilder;
import org.teavm.backend.javascript.codegen.RememberedSource;
import org.teavm.backend.javascript.codegen.RememberingSourceWriter;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.intrinsics.ref.ReferenceQueueGenerator;
import org.teavm.backend.javascript.intrinsics.ref.ReferenceQueueTransformer;
import org.teavm.backend.javascript.intrinsics.ref.WeakReferenceDependencyListener;
import org.teavm.backend.javascript.intrinsics.ref.WeakReferenceGenerator;
import org.teavm.backend.javascript.intrinsics.ref.WeakReferenceTransformer;
import org.teavm.backend.javascript.rendering.NameFrequencyEstimator;
import org.teavm.backend.javascript.rendering.Renderer;
import org.teavm.backend.javascript.rendering.RenderingContext;
import org.teavm.backend.javascript.rendering.RenderingUtil;
import org.teavm.backend.javascript.rendering.RuntimeRenderer;
import org.teavm.backend.javascript.spi.GeneratedBy;
import org.teavm.backend.javascript.spi.Generator;
import org.teavm.backend.javascript.spi.InjectedBy;
import org.teavm.backend.javascript.spi.Injector;
import org.teavm.backend.javascript.spi.VirtualMethodContributor;
import org.teavm.backend.javascript.spi.VirtualMethodContributorContext;
import org.teavm.backend.javascript.templating.JavaScriptTemplateFactory;
import org.teavm.cache.EmptyMethodNodeCache;
import org.teavm.cache.MethodNodeCache;
import org.teavm.debugging.information.DebugInformationEmitter;
import org.teavm.debugging.information.DummyDebugInformationEmitter;
import org.teavm.debugging.information.SourceLocation;
import org.teavm.dependency.AbstractDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyAnalyzer;
import org.teavm.dependency.DependencyListener;
import org.teavm.dependency.DependencyType;
import org.teavm.dependency.MethodDependency;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.interop.PlatformMarker;
import org.teavm.model.BasicBlock;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReference;
import org.teavm.model.ListableClassHolderSource;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.TextLocation;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.transformation.BoundCheckInsertion;
import org.teavm.model.transformation.NullCheckFilter;
import org.teavm.model.transformation.NullCheckInsertion;
import org.teavm.vm.BuildTarget;
import org.teavm.vm.RenderingException;
import org.teavm.vm.TeaVMEntryPoint;
import org.teavm.vm.TeaVMTarget;
import org.teavm.vm.TeaVMTargetController;
import org.teavm.vm.spi.RendererListener;
import org.teavm.vm.spi.TeaVMHostExtension;

public class JavaScriptTarget
implements TeaVMTarget,
TeaVMJavaScriptHost {
    private static final NumberFormat STATS_NUM_FORMAT = new DecimalFormat("#,##0");
    private static final NumberFormat STATS_PERCENT_FORMAT = new DecimalFormat("0.000 %");
    private static final MethodReference CURRENT_THREAD = new MethodReference(Thread.class, "currentThread", Thread.class);
    private TeaVMTargetController controller;
    private boolean obfuscated = true;
    private boolean stackTraceIncluded;
    private final Map<MethodReference, Generator> methodGenerators = new HashMap<MethodReference, Generator>();
    private final Map<MethodReference, Injector> methodInjectors = new HashMap<MethodReference, Injector>();
    private final List<Function<ProviderContext, Generator>> generatorProviders = new ArrayList<Function<ProviderContext, Generator>>();
    private final List<Function<ProviderContext, Injector>> injectorProviders = new ArrayList<Function<ProviderContext, Injector>>();
    private final List<RendererListener> rendererListeners = new ArrayList<RendererListener>();
    private DebugInformationEmitter debugEmitter;
    private MethodNodeCache astCache = EmptyMethodNodeCache.INSTANCE;
    private final Set<MethodReference> asyncMethods = new HashSet<MethodReference>();
    private List<VirtualMethodContributor> customVirtualMethods = new ArrayList<VirtualMethodContributor>();
    private boolean strict;
    private BoundCheckInsertion boundCheckInsertion = new BoundCheckInsertion();
    private NullCheckInsertion nullCheckInsertion = new NullCheckInsertion(NullCheckFilter.EMPTY);
    private final Map<String, String> importedModules = new LinkedHashMap<String, String>();
    private JavaScriptTemplateFactory templateFactory;
    private JSModuleType moduleType = JSModuleType.UMD;

    @Override
    public List<ClassHolderTransformer> getTransformers() {
        return List.of(new WeakReferenceTransformer(), new ReferenceQueueTransformer());
    }

    @Override
    public List<DependencyListener> getDependencyListeners() {
        return Collections.emptyList();
    }

    @Override
    public void setController(TeaVMTargetController controller) {
        this.controller = controller;
        this.templateFactory = new JavaScriptTemplateFactory(controller.getClassLoader(), controller.getDependencyInfo().getClassSource());
        WeakReferenceGenerator weakRefGenerator = new WeakReferenceGenerator(this.templateFactory);
        this.methodGenerators.put(new MethodReference(WeakReference.class, "<init>", Object.class, ReferenceQueue.class, Void.TYPE), weakRefGenerator);
        this.methodGenerators.put(new MethodReference(WeakReference.class, "get", Object.class), weakRefGenerator);
        this.methodGenerators.put(new MethodReference(WeakReference.class, "clear", Void.TYPE), weakRefGenerator);
        ReferenceQueueGenerator refQueueGenerator = new ReferenceQueueGenerator();
        this.methodGenerators.put(new MethodReference(ReferenceQueue.class, "<init>", Void.TYPE), refQueueGenerator);
        this.methodGenerators.put(new MethodReference(ReferenceQueue.class, "poll", Reference.class), refQueueGenerator);
    }

    @Override
    public void add(RendererListener listener) {
        this.rendererListeners.add(listener);
    }

    @Override
    public void add(MethodReference methodRef, Generator generator) {
        this.methodGenerators.put(methodRef, generator);
    }

    @Override
    public void add(MethodReference methodRef, Injector injector) {
        this.methodInjectors.put(methodRef, injector);
    }

    @Override
    public void addGeneratorProvider(Function<ProviderContext, Generator> provider) {
        this.generatorProviders.add(provider);
    }

    @Override
    public void addInjectorProvider(Function<ProviderContext, Injector> provider) {
        this.injectorProviders.add(provider);
    }

    public void setObfuscated(boolean obfuscated) {
        this.obfuscated = obfuscated;
    }

    public MethodNodeCache getAstCache() {
        return this.astCache;
    }

    public void setAstCache(MethodNodeCache methodAstCache) {
        this.astCache = methodAstCache;
    }

    public DebugInformationEmitter getDebugEmitter() {
        return this.debugEmitter;
    }

    public void setDebugEmitter(DebugInformationEmitter debugEmitter) {
        this.debugEmitter = debugEmitter;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setModuleType(JSModuleType moduleType) {
        this.moduleType = moduleType;
    }

    @Override
    public boolean requiresRegisterAllocation() {
        return true;
    }

    public void setStackTraceIncluded(boolean stackTraceIncluded) {
        this.stackTraceIncluded = stackTraceIncluded;
    }

    @Override
    public List<TeaVMHostExtension> getHostExtensions() {
        return Collections.singletonList(this);
    }

    @Override
    public void contributeDependencies(DependencyAnalyzer dependencyAnalyzer) {
        DependencyType stringType = dependencyAnalyzer.getType("java.lang.String");
        MethodDependency dep = dependencyAnalyzer.linkMethod(new MethodReference(Class.class.getName(), "getClass", ValueType.object("org.teavm.platform.PlatformClass"), ValueType.parse(Class.class)));
        dep.getVariable(0).propagate(dependencyAnalyzer.getType("org.teavm.platform.PlatformClass"));
        dep.getResult().propagate(dependencyAnalyzer.getType("java.lang.Class"));
        dep.use();
        dep = dependencyAnalyzer.linkMethod(new MethodReference(String.class, "<init>", Object.class, Void.TYPE));
        dep.getVariable(0).propagate(stringType);
        dep.use();
        dependencyAnalyzer.linkField(new FieldReference(String.class.getName(), "characters"));
        dep = dependencyAnalyzer.linkMethod(new MethodReference(Object.class, "toString", String.class));
        dep.getVariable(0).propagate(dependencyAnalyzer.getType("java.lang.Object"));
        dep.use();
        MethodDependency exceptionCons = dependencyAnalyzer.linkMethod(new MethodReference(RuntimeException.class, "<init>", String.class, Void.TYPE));
        exceptionCons.getVariable(0).propagate(dependencyAnalyzer.getType(RuntimeException.class.getName()));
        exceptionCons.getVariable(1).propagate(stringType);
        exceptionCons.use();
        if (this.strict) {
            exceptionCons = dependencyAnalyzer.linkMethod(new MethodReference(ArrayIndexOutOfBoundsException.class, "<init>", Void.TYPE));
            exceptionCons.getVariable(0).propagate(dependencyAnalyzer.getType(ArrayIndexOutOfBoundsException.class.getName()));
            exceptionCons.use();
            exceptionCons = dependencyAnalyzer.linkMethod(new MethodReference(NullPointerException.class, "<init>", Void.TYPE));
            exceptionCons.getVariable(0).propagate(dependencyAnalyzer.getType(NullPointerException.class.getName()));
            exceptionCons.use();
            exceptionCons = dependencyAnalyzer.linkMethod(new MethodReference(ClassCastException.class, "<init>", Void.TYPE));
            exceptionCons.getVariable(0).propagate(dependencyAnalyzer.getType(ClassCastException.class.getName()));
            exceptionCons.use();
        }
        if (this.stackTraceIncluded) {
            JavaScriptTarget.includeStackTraceMethods(dependencyAnalyzer);
        }
        dependencyAnalyzer.linkMethod(new MethodReference(Throwable.class, "getMessage", String.class)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(Throwable.class, "getCause", Throwable.class)).use();
        dependencyAnalyzer.addDependencyListener(new AbstractDependencyListener(){

            @Override
            public void methodReached(DependencyAgent agent, MethodDependency method) {
                if (method.getReference().equals(CURRENT_THREAD)) {
                    method.use();
                    agent.linkMethod(new MethodReference(Thread.class, "setCurrentThread", Thread.class, Void.TYPE)).use();
                }
            }
        });
        dependencyAnalyzer.addDependencyListener(new WeakReferenceDependencyListener());
    }

    public static void includeStackTraceMethods(DependencyAnalyzer dependencyAnalyzer) {
        DependencyType stringType = dependencyAnalyzer.getType("java.lang.String");
        MethodDependency dep = dependencyAnalyzer.linkMethod(new MethodReference(StackTraceElement.class, "<init>", String.class, String.class, String.class, Integer.TYPE, Void.TYPE));
        dep.getVariable(0).propagate(dependencyAnalyzer.getType(StackTraceElement.class.getName()));
        dep.getVariable(1).propagate(stringType);
        dep.getVariable(2).propagate(stringType);
        dep.getVariable(3).propagate(stringType);
        dep.use();
        dep = dependencyAnalyzer.linkMethod(new MethodReference(Throwable.class, "setStackTrace", StackTraceElement[].class, Void.TYPE));
        dep.getVariable(0).propagate(dependencyAnalyzer.getType(Throwable.class.getName()));
        dep.getVariable(1).propagate(dependencyAnalyzer.getType("[Ljava/lang/StackTraceElement;"));
        dep.getVariable(1).getArrayItem().propagate(dependencyAnalyzer.getType(StackTraceElement.class.getName()));
        dep.use();
    }

    @Override
    public void emit(ListableClassHolderSource classes, BuildTarget target, String outputName) {
        try (OutputStream output = target.createResource(outputName);
             OutputStreamWriter writer = new OutputStreamWriter(output, StandardCharsets.UTF_8);){
            this.emit(classes, writer, target);
        }
        catch (IOException e) {
            throw new RenderingException(e);
        }
    }

    @Override
    public void beforeInlining(Program program, MethodReader method) {
        if (this.strict) {
            this.nullCheckInsertion.transformProgram(program, method.getReference());
        }
    }

    @Override
    public void beforeOptimizations(Program program, MethodReader method) {
        if (this.strict) {
            this.boundCheckInsertion.transformProgram(program, method.getReference());
        }
    }

    @Override
    public void afterOptimizations(Program program, MethodReader method) {
    }

    private void emit(ListableClassHolderSource classes, Writer writer, BuildTarget target) {
        AliasProvider aliasProvider = this.obfuscated ? new MinifyingAliasProvider() : new DefaultAliasProvider();
        DefaultNamingStrategy naming = new DefaultNamingStrategy(aliasProvider, this.controller.getUnprocessedClassSource());
        DebugInformationEmitter debugEmitterToUse = this.debugEmitter;
        if (debugEmitterToUse == null) {
            debugEmitterToUse = new DummyDebugInformationEmitter();
        }
        VirtualMethodContributorContextImpl virtualMethodContributorContext = new VirtualMethodContributorContextImpl(classes);
        RenderingContext renderingContext = new RenderingContext(debugEmitterToUse, this.controller.getUnprocessedClassSource(), classes, this.controller.getClassLoader(), this.controller.getServices(), this.controller.getProperties(), naming, this.controller.getDependencyInfo(), m -> this.isVirtual(virtualMethodContributorContext, (MethodReference)m), this.controller.getClassInitializerInfo(), this.strict){

            @Override
            public String importModule(String name) {
                return JavaScriptTarget.this.importModule(name);
            }
        };
        renderingContext.setMinifying(this.obfuscated);
        if (this.controller.wasCancelled()) {
            return;
        }
        OutputSourceWriterBuilder builder = new OutputSourceWriterBuilder(naming);
        builder.setMinified(this.obfuscated);
        for (String string : classes.getClassNames()) {
            ClassHolder cls = classes.get(string);
            for (MethodHolder methodHolder : cls.getMethods()) {
                this.preprocessNativeMethod(methodHolder);
            }
        }
        for (Map.Entry entry : this.methodInjectors.entrySet()) {
            renderingContext.addInjector((MethodReference)entry.getKey(), (Injector)entry.getValue());
        }
        RememberingSourceWriter rememberingWriter = new RememberingSourceWriter(this.debugEmitter != null);
        Renderer renderer = new Renderer(rememberingWriter, this.asyncMethods, renderingContext, this.controller.getDiagnostics(), this.methodGenerators, this.astCache, this.controller.getCacheStatus(), this.templateFactory);
        renderer.setProperties(this.controller.getProperties());
        renderer.setProgressConsumer(this.controller::reportProgress);
        for (RendererListener rendererListener : this.rendererListeners) {
            rendererListener.begin(renderer, target);
        }
        if (!renderer.render(classes, this.controller.isFriendlyToDebugger())) {
            return;
        }
        RememberedSource declarations = rememberingWriter.save();
        rememberingWriter.clear();
        renderer.renderStringPool();
        renderer.renderStringConstants();
        renderer.renderCompatibilityStubs();
        for (Map.Entry<? extends String, ? extends TeaVMEntryPoint> entry : this.controller.getEntryPoints().entrySet()) {
            String alias = "$rt_export_" + entry.getKey();
            MethodReference ref = entry.getValue().getMethod();
            rememberingWriter.append("let ").appendFunction(alias).ws().append("=").ws().appendFunction("$rt_mainStarter").append("(").appendMethodBody(ref);
            rememberingWriter.append(");").newLine();
            rememberingWriter.appendFunction(alias).append(".").append("javaException").ws().append("=").ws().appendFunction("$rt_javaException").append(";").newLine();
        }
        for (RendererListener rendererListener : this.rendererListeners) {
            rendererListener.complete();
        }
        RememberedSource rememberedSource = rememberingWriter.save();
        rememberingWriter.clear();
        if (renderingContext.isMinifying()) {
            NameFrequencyEstimator nameFrequencyEstimator = new NameFrequencyEstimator();
            declarations.replay(nameFrequencyEstimator, 2);
            rememberedSource.replay(nameFrequencyEstimator, 2);
            nameFrequencyEstimator.apply(naming);
        }
        OutputSourceWriter outputSourceWriter = builder.build(writer);
        outputSourceWriter.setDebugInformationEmitter(debugEmitterToUse);
        this.printWrapperStart(outputSourceWriter);
        int start = outputSourceWriter.getOffset();
        RuntimeRenderer runtimeRenderer = new RuntimeRenderer(classes, outputSourceWriter, this.controller.getClassInitializerInfo());
        runtimeRenderer.prepareAstParts(renderer.isThreadLibraryUsed());
        declarations.replay(runtimeRenderer.sink, 2);
        rememberedSource.replay(runtimeRenderer.sink, 2);
        runtimeRenderer.removeUnusedParts();
        runtimeRenderer.renderRuntime();
        declarations.write(outputSourceWriter, 0);
        runtimeRenderer.renderEpilogue();
        rememberedSource.write(outputSourceWriter, 0);
        this.printWrapperEnd(outputSourceWriter);
        int totalSize = outputSourceWriter.getOffset() - start;
        this.printStats(outputSourceWriter, totalSize);
    }

    private void printWrapperStart(SourceWriter writer) {
        writer.append("\"use strict\";").newLine();
        this.printModuleStart(writer);
    }

    private String importModule(String name) {
        return this.importedModules.computeIfAbsent(name, n -> "$rt_imported_" + this.importedModules.size());
    }

    private void printModuleStart(SourceWriter writer) {
        switch (this.moduleType) {
            case UMD: {
                this.printUmdStart(writer);
                break;
            }
            case COMMON_JS: {
                this.printCommonJsStart(writer);
                break;
            }
            case NONE: {
                this.printIIFStart(writer);
                break;
            }
            case ES2015: {
                this.printES2015Start(writer);
            }
        }
    }

    private void printUmdStart(SourceWriter writer) {
        writer.append("(function(module)").appendBlockStart();
        writer.appendIf().append("typeof define").ws().append("===").ws().append("'function'").ws().append("&&").ws().append("define.amd)").appendBlockStart();
        writer.append("define(['exports'");
        for (String moduleName : this.importedModules.keySet()) {
            writer.append(',').ws().append('\"').append(RenderingUtil.escapeString(moduleName)).append('\"');
        }
        writer.append("],").ws().append("function(exports");
        for (String moduleAlias : this.importedModules.values()) {
            writer.append(',').ws().appendFunction(moduleAlias);
        }
        writer.append(")").ws().appendBlockStart();
        writer.append("module(exports");
        for (String moduleAlias : this.importedModules.values()) {
            writer.append(',').ws().appendFunction(moduleAlias);
        }
        writer.append(");").softNewLine();
        writer.outdent().append("});").softNewLine();
        writer.appendElseIf().append("typeof exports").ws().append("===").ws().append("'object'").ws().append("&&").ws().append("exports").ws().append("!==").ws().append("null").ws().append("&&").ws().append("typeof exports.nodeName").ws().append("!==").ws().append("'string')").appendBlockStart();
        writer.append("module(exports");
        for (String moduleName : this.importedModules.keySet()) {
            writer.append(',').ws().append("require(\"").append(RenderingUtil.escapeString(moduleName)).append("\")");
        }
        writer.append(");").softNewLine();
        writer.appendElse();
        writer.append("module(");
        writer.outdent().append("typeof self").ws().append("!==").ws().append("'undefined'").ws().append("?").ws().append("self").ws().append(":").ws().append("this");
        writer.append(");").softNewLine();
        writer.appendBlockEnd();
        writer.outdent().append("}(");
        writer.append("function(").appendFunction("$rt_exports");
        for (String moduleName : this.importedModules.values()) {
            writer.append(",").ws().appendFunction(moduleName);
        }
        writer.append(")").appendBlockStart();
    }

    private void printIIFStart(SourceWriter writer) {
        for (String string : this.controller.getEntryPoints().keySet()) {
            writer.append("var ").appendGlobal(string).append(";").softNewLine();
        }
        writer.append("(function()").appendBlockStart();
        for (Map.Entry entry : this.importedModules.entrySet()) {
            String moduleName = (String)entry.getKey();
            String alias = (String)entry.getValue();
            writer.append("let ").appendFunction(alias).ws().append('=').ws().append("this[\"").append(RenderingUtil.escapeString(moduleName)).append("\"];").softNewLine();
        }
    }

    private void printCommonJsStart(SourceWriter writer) {
        for (Map.Entry<String, String> entry : this.importedModules.entrySet()) {
            String moduleName = entry.getKey();
            String alias = entry.getValue();
            writer.append("let ").appendFunction(alias).ws().append('=').ws().append("require(\"").append(RenderingUtil.escapeString(moduleName)).append("\");").softNewLine();
        }
    }

    private void printES2015Start(SourceWriter writer) {
        for (Map.Entry<String, String> entry : this.importedModules.entrySet()) {
            String moduleName = entry.getKey();
            String alias = entry.getValue();
            writer.append("import").ws().append("*").ws().append("as ").appendFunction(alias).append(" from").ws().append("\"").append(RenderingUtil.escapeString(moduleName)).append("\";").softNewLine();
        }
    }

    private void printWrapperEnd(SourceWriter writer) {
        switch (this.moduleType) {
            case UMD: {
                this.printUmdEnd(writer);
                break;
            }
            case COMMON_JS: {
                this.printCommonJsEnd(writer);
                break;
            }
            case NONE: {
                this.printIFFEnd(writer);
                break;
            }
            case ES2015: {
                this.printES2015End(writer);
            }
        }
    }

    private void printUmdEnd(SourceWriter writer) {
        for (String string : this.controller.getEntryPoints().keySet()) {
            writer.appendFunction("$rt_exports").append(".").append(string).ws().append("=").ws().appendFunction("$rt_export_" + string);
        }
        writer.outdent().append("}));").newLine();
    }

    private void printCommonJsEnd(SourceWriter writer) {
        for (String string : this.controller.getEntryPoints().keySet()) {
            writer.appendFunction("exports.").append(string).ws().append("=").ws().appendFunction("$rt_export_" + string).append(";").softNewLine();
        }
    }

    private void printIFFEnd(SourceWriter writer) {
        for (String string : this.controller.getEntryPoints().keySet()) {
            writer.appendGlobal(string).ws().append("=").ws().appendFunction("$rt_export_" + string).append(";").softNewLine();
        }
        writer.outdent().append("})();");
    }

    private void printES2015End(SourceWriter writer) {
        if (this.controller.getEntryPoints().isEmpty()) {
            return;
        }
        writer.append("export").ws().append("{").ws();
        boolean first = true;
        for (String string : this.controller.getEntryPoints().keySet()) {
            if (!first) {
                writer.append(",").ws();
            }
            first = false;
            writer.appendFunction("$rt_export_" + string).append(" as ").append(string);
        }
        writer.ws().append("};").softNewLine();
    }

    private void printStats(OutputSourceWriter writer, int totalSize) {
        if (!Boolean.parseBoolean(System.getProperty("teavm.js.stats", "false"))) {
            return;
        }
        System.out.println("Total output size: " + STATS_NUM_FORMAT.format(totalSize));
        System.out.println("Metadata size: " + this.getSizeWithPercentage(writer.getSectionSize(1), totalSize));
        System.out.println("String pool size: " + this.getSizeWithPercentage(writer.getSectionSize(0), totalSize));
        ObjectIntHashMap packageSizeMap = new ObjectIntHashMap();
        for (String className : writer.getClassesInStats()) {
            String packageName = className.substring(0, className.lastIndexOf(46) + 1);
            int classSize = writer.getClassSize(className);
            packageSizeMap.put((Object)packageName, packageSizeMap.getOrDefault((Object)packageName, 0) + classSize);
        }
        String[] packageNames = (String[])packageSizeMap.keys().toArray(String.class);
        Arrays.sort(packageNames, Comparator.comparing(p -> -packageSizeMap.getOrDefault(p, 0)));
        for (String packageName : packageNames) {
            System.out.println("Package '" + packageName + "' size: " + this.getSizeWithPercentage(packageSizeMap.get((Object)packageName), totalSize));
        }
    }

    private String getSizeWithPercentage(int size, int totalSize) {
        return STATS_NUM_FORMAT.format(size) + " (" + STATS_PERCENT_FORMAT.format((double)size / (double)totalSize) + ")";
    }

    /*
     * WARNING - void declaration
     */
    private void preprocessNativeMethod(MethodHolder method) {
        void var5_9;
        if (!method.getModifiers().contains((Object)ElementModifier.NATIVE) || this.methodGenerators.get(method.getReference()) != null || this.methodInjectors.get(method.getReference()) != null) {
            return;
        }
        boolean found = false;
        ProviderContextImpl context = new ProviderContextImpl(method.getReference());
        for (Function<ProviderContext, Generator> function : this.generatorProviders) {
            Generator generator = function.apply(context);
            if (generator == null) continue;
            this.methodGenerators.put(method.getReference(), generator);
            found = true;
            break;
        }
        for (Function<ProviderContext, Object> function : this.injectorProviders) {
            Injector injector = (Injector)function.apply(context);
            if (injector == null) continue;
            this.methodInjectors.put(method.getReference(), injector);
            found = true;
            break;
        }
        if (found) {
            return;
        }
        if (!(JavaScriptTarget.isBootstrap() || method.getAnnotations().get(GeneratedBy.class.getName()) == null && method.getAnnotations().get(InjectedBy.class.getName()) == null)) {
            return;
        }
        method.getModifiers().remove((Object)ElementModifier.NATIVE);
        Program program = new Program();
        method.setProgram(program);
        boolean bl = false;
        while (var5_9 <= method.parameterCount()) {
            program.createVariable();
            ++var5_9;
        }
        BasicBlock basicBlock = program.createBasicBlock();
        Variable exceptionVar = program.createVariable();
        ConstructInstruction newExceptionInsn = new ConstructInstruction();
        newExceptionInsn.setType(NoSuchMethodError.class.getName());
        newExceptionInsn.setReceiver(exceptionVar);
        basicBlock.add(newExceptionInsn);
        Variable constVar = program.createVariable();
        StringConstantInstruction constInsn = new StringConstantInstruction();
        constInsn.setConstant("Native method implementation not found: " + method.getReference());
        constInsn.setReceiver(constVar);
        basicBlock.add(constInsn);
        InvokeInstruction initExceptionInsn = new InvokeInstruction();
        initExceptionInsn.setInstance(exceptionVar);
        initExceptionInsn.setMethod(new MethodReference(NoSuchMethodError.class, "<init>", String.class, Void.TYPE));
        initExceptionInsn.setType(InvocationType.SPECIAL);
        initExceptionInsn.setArguments(constVar);
        basicBlock.add(initExceptionInsn);
        RaiseInstruction raiseInsn = new RaiseInstruction();
        raiseInsn.setException(exceptionVar);
        basicBlock.add(raiseInsn);
        this.controller.getDiagnostics().error(new CallLocation(method.getReference()), "Native method {{m0}} has no implementation", method.getReference());
    }

    @PlatformMarker
    private static boolean isBootstrap() {
        return false;
    }

    private void emitCFG(DebugInformationEmitter emitter, ControlFlowEntry[] cfg) {
        for (ControlFlowEntry entry : cfg) {
            SourceLocation location = JavaScriptTarget.map(entry.from);
            SourceLocation[] successors = new SourceLocation[entry.to.length];
            for (int i = 0; i < entry.to.length; ++i) {
                successors[i] = JavaScriptTarget.map(entry.to[i]);
            }
            emitter.addSuccessors(location, successors);
        }
    }

    private static SourceLocation map(TextLocation location) {
        if (location == null || location.isEmpty()) {
            return null;
        }
        return new SourceLocation(location.getFileName(), location.getLine());
    }

    @Override
    public String[] getPlatformTags() {
        return new String[]{"javascript"};
    }

    @Override
    public void addVirtualMethods(VirtualMethodContributor virtualMethods) {
        this.customVirtualMethods.add(virtualMethods);
    }

    @Override
    public boolean isAsyncSupported() {
        return true;
    }

    private boolean isVirtual(VirtualMethodContributorContext context, MethodReference method) {
        if (this.controller.isVirtual(method)) {
            return true;
        }
        for (VirtualMethodContributor predicate : this.customVirtualMethods) {
            if (!predicate.isVirtual(context, method)) continue;
            return true;
        }
        return false;
    }

    static class VirtualMethodContributorContextImpl
    implements VirtualMethodContributorContext {
        private ClassReaderSource classSource;

        VirtualMethodContributorContextImpl(ClassReaderSource classSource) {
            this.classSource = classSource;
        }

        @Override
        public ClassReaderSource getClassSource() {
            return this.classSource;
        }
    }

    class ProviderContextImpl
    implements ProviderContext {
        private MethodReference method;

        ProviderContextImpl(MethodReference method) {
            this.method = method;
        }

        @Override
        public MethodReference getMethod() {
            return this.method;
        }

        @Override
        public ClassReaderSource getClassSource() {
            return JavaScriptTarget.this.controller.getUnprocessedClassSource();
        }

        @Override
        public <T> T getService(Class<T> type) {
            return JavaScriptTarget.this.controller.getServices().getService(type);
        }
    }
}

