/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.interop.SupportedOn;
import org.teavm.interop.UnsupportedOn;
import org.teavm.model.AnnotationContainerReader;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.BasicBlock;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassReader;
import org.teavm.model.FieldReference;
import org.teavm.model.Instruction;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.TextLocation;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.AbstractInstructionVisitor;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ConstructMultiArrayInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.InstructionVisitor;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.IsInstanceInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.optimization.UnreachableBasicBlockEliminator;
import org.teavm.model.util.ProgramUtils;

public class MissingItemsProcessor {
    private DependencyInfo dependencyInfo;
    private ClassHierarchy hierarchy;
    private Diagnostics diagnostics;
    private List<Instruction> instructionsToAdd = new ArrayList<Instruction>();
    private MethodReference methodRef;
    private Program program;
    private Collection<String> reachableClasses;
    private Collection<MethodReference> reachableMethods;
    private Collection<FieldReference> reachableFields;
    private Set<String> platformTags = new HashSet<String>();
    private InstructionVisitor instructionProcessor = new AbstractInstructionVisitor(){

        @Override
        public void visit(InitClassInstruction insn) {
            MissingItemsProcessor.this.checkClass(insn.getLocation(), insn.getClassName());
        }

        @Override
        public void visit(IsInstanceInstruction insn) {
            MissingItemsProcessor.this.checkClass(insn.getLocation(), insn.getType());
        }

        @Override
        public void visit(InvokeInstruction insn) {
            if (insn.getType() != InvocationType.VIRTUAL) {
                MissingItemsProcessor.this.checkMethod(insn.getLocation(), insn.getMethod());
            } else {
                MissingItemsProcessor.this.checkVirtualMethod(insn.getLocation(), insn.getMethod());
            }
        }

        @Override
        public void visit(PutFieldInstruction insn) {
            MissingItemsProcessor.this.checkField(insn.getLocation(), insn.getField());
        }

        @Override
        public void visit(GetFieldInstruction insn) {
            MissingItemsProcessor.this.checkField(insn.getLocation(), insn.getField());
        }

        @Override
        public void visit(ConstructMultiArrayInstruction insn) {
            MissingItemsProcessor.this.checkClass(insn.getLocation(), insn.getItemType());
        }

        @Override
        public void visit(ConstructInstruction insn) {
            MissingItemsProcessor.this.checkClass(insn.getLocation(), insn.getType());
        }

        @Override
        public void visit(ConstructArrayInstruction insn) {
            MissingItemsProcessor.this.checkClass(insn.getLocation(), insn.getItemType());
        }

        @Override
        public void visit(CastInstruction insn) {
            MissingItemsProcessor.this.checkClass(insn.getLocation(), insn.getTargetType());
        }

        @Override
        public void visit(ClassConstantInstruction insn) {
            MissingItemsProcessor.this.checkClass(insn.getLocation(), insn.getConstant());
        }
    };

    public MissingItemsProcessor(DependencyInfo dependencyInfo, ClassHierarchy hierarchy, Diagnostics diagnostics, String[] platformTags) {
        this.dependencyInfo = dependencyInfo;
        this.diagnostics = diagnostics;
        this.hierarchy = hierarchy;
        this.reachableClasses = dependencyInfo.getReachableClasses();
        this.reachableMethods = dependencyInfo.getReachableMethods();
        this.reachableFields = dependencyInfo.getReachableFields();
        this.platformTags.addAll(Arrays.asList(platformTags));
    }

    public void processClass(ClassHolder cls) {
        for (MethodHolder method : cls.getMethods()) {
            MethodDependencyInfo methodDep;
            if (!this.reachableMethods.contains(method.getReference()) || method.getProgram() == null || (methodDep = this.dependencyInfo.getMethod(method.getReference())) == null || !methodDep.isUsed()) continue;
            this.processMethod(method);
        }
    }

    public void processMethod(MethodHolder method) {
        this.processMethod(method.getReference(), method.getProgram());
    }

    public void processMethod(MethodReference method, Program program) {
        this.methodRef = method;
        this.program = program;
        boolean wasModified = false;
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            this.instructionsToAdd.clear();
            boolean missing = false;
            for (Instruction insn : block) {
                insn.acceptVisitor(this.instructionProcessor);
                if (this.instructionsToAdd.isEmpty()) continue;
                wasModified = true;
                this.truncateBlock(insn);
                missing = true;
                break;
            }
            if (missing) continue;
            for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                this.checkClass(null, tryCatch.getExceptionType());
            }
        }
        if (wasModified) {
            new UnreachableBasicBlockEliminator().optimize(program);
        }
    }

    private void truncateBlock(Instruction instruction) {
        ProgramUtils.truncateBlock(instruction);
        instruction.insertNextAll(this.instructionsToAdd);
        instruction.delete();
    }

    private void emitExceptionThrow(TextLocation location, String exceptionName, String text) {
        Variable exceptionVar = this.program.createVariable();
        ConstructInstruction newExceptionInsn = new ConstructInstruction();
        newExceptionInsn.setType(exceptionName);
        newExceptionInsn.setReceiver(exceptionVar);
        newExceptionInsn.setLocation(location);
        this.instructionsToAdd.add(newExceptionInsn);
        Variable constVar = this.program.createVariable();
        StringConstantInstruction constInsn = new StringConstantInstruction();
        constInsn.setConstant(text);
        constInsn.setReceiver(constVar);
        constInsn.setLocation(location);
        this.instructionsToAdd.add(constInsn);
        InvokeInstruction initExceptionInsn = new InvokeInstruction();
        initExceptionInsn.setInstance(exceptionVar);
        initExceptionInsn.setMethod(new MethodReference(exceptionName, "<init>", ValueType.object("java.lang.String"), ValueType.VOID));
        initExceptionInsn.setType(InvocationType.SPECIAL);
        initExceptionInsn.setArguments(constVar);
        initExceptionInsn.setLocation(location);
        this.instructionsToAdd.add(initExceptionInsn);
        RaiseInstruction raiseInsn = new RaiseInstruction();
        raiseInsn.setException(exceptionVar);
        raiseInsn.setLocation(location);
        this.instructionsToAdd.add(raiseInsn);
    }

    private boolean checkClass(TextLocation location, String className) {
        if (!this.reachableClasses.contains(className)) {
            return true;
        }
        if (!this.dependencyInfo.getClass(className).isMissing()) {
            ClassReader cls = this.dependencyInfo.getClassSource().get(className);
            if (cls != null && !this.checkPlatformSupported(cls.getAnnotations())) {
                this.diagnostics.error(new CallLocation(this.methodRef, location), "Class {{c0}} is not supported on current target", className);
                this.emitExceptionThrow(location, NoClassDefFoundError.class.getName(), "Class not found: " + className);
                return false;
            }
            return true;
        }
        this.diagnostics.error(new CallLocation(this.methodRef, location), "Class {{c0}} was not found", className);
        this.emitExceptionThrow(location, NoClassDefFoundError.class.getName(), "Class not found: " + className);
        return false;
    }

    private boolean checkClass(TextLocation location, ValueType type) {
        while (type instanceof ValueType.Array) {
            type = ((ValueType.Array)type).getItemType();
        }
        if (type instanceof ValueType.Object) {
            return this.checkClass(location, ((ValueType.Object)type).getClassName());
        }
        return true;
    }

    private boolean checkMethod(TextLocation location, MethodReference method) {
        if (!this.checkClass(location, method.getClassName())) {
            return false;
        }
        if (!this.reachableMethods.contains(method)) {
            return true;
        }
        MethodDependencyInfo methodDep = this.dependencyInfo.getMethod(method);
        if (!methodDep.isUsed()) {
            return true;
        }
        if (!methodDep.isMissing()) {
            MethodReader methodReader;
            ClassReader cls = this.dependencyInfo.getClassSource().get(method.getClassName());
            if (cls != null && (methodReader = cls.getMethod(method.getDescriptor())) != null && !this.checkPlatformSupported(methodReader.getAnnotations())) {
                this.diagnostics.error(new CallLocation(this.methodRef, location), "Method {{m0}} is not supported on current target", method);
                this.emitExceptionThrow(location, NoSuchMethodError.class.getName(), "Method not found: " + String.valueOf(method));
                return false;
            }
            return true;
        }
        this.diagnostics.error(new CallLocation(this.methodRef, location), "Method {{m0}} was not found", method);
        this.emitExceptionThrow(location, NoSuchMethodError.class.getName(), "Method not found: " + String.valueOf(method));
        return false;
    }

    private boolean checkVirtualMethod(TextLocation location, MethodReference method) {
        if (!this.checkClass(location, method.getClassName())) {
            return false;
        }
        if (this.hierarchy.resolve(method) != null) {
            return true;
        }
        this.diagnostics.error(new CallLocation(this.methodRef, location), "Method {{m0}} was not found", method);
        this.emitExceptionThrow(location, NoSuchMethodError.class.getName(), "Method not found: " + String.valueOf(method));
        return true;
    }

    private boolean checkField(TextLocation location, FieldReference field) {
        if (!this.checkClass(location, field.getClassName())) {
            return false;
        }
        if (!this.reachableFields.contains(field) || !this.dependencyInfo.getField(field).isMissing()) {
            return true;
        }
        this.diagnostics.error(new CallLocation(this.methodRef, location), "Field {{f0}} was not found", field);
        this.emitExceptionThrow(location, NoSuchFieldError.class.getName(), "Field not found: " + String.valueOf(field));
        return true;
    }

    private boolean checkPlatformSupported(AnnotationContainerReader annotations) {
        AnnotationReader supportedAnnot = annotations.get(SupportedOn.class.getName());
        AnnotationReader unsupportedAnnot = annotations.get(UnsupportedOn.class.getName());
        if (supportedAnnot != null) {
            for (AnnotationValue value : supportedAnnot.getValue("value").getList()) {
                if (!this.platformTags.contains(value.getString())) continue;
                return true;
            }
            return false;
        }
        if (unsupportedAnnot != null) {
            for (AnnotationValue value : unsupportedAnnot.getValue("value").getList()) {
                if (!this.platformTags.contains(value.getString())) continue;
                return false;
            }
            return true;
        }
        return true;
    }
}

