/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.render;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.teavm.backend.wasm.render.WasmBinaryStatsCollector;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;
import org.teavm.hppc.cursors.ObjectIntCursor;

public class ReportingWasmBinaryStatsCollector
implements WasmBinaryStatsCollector {
    private Map<String, ClassStats> statsByClass = new LinkedHashMap<String, ClassStats>();
    private ObjectIntMap<String> sectionSizes = new ObjectIntHashMap();
    private int stringsSize;

    @Override
    public void addClassCodeSize(String className, int bytes) {
        this.getStats((String)className).codeSize += bytes;
    }

    @Override
    public void addClassMetadataSize(String className, int bytes) {
        this.getStats((String)className).metadataSize += bytes;
    }

    private ClassStats getStats(String className) {
        return this.statsByClass.computeIfAbsent(className, k -> new ClassStats());
    }

    @Override
    public void addSectionSize(String name, int bytes) {
        this.sectionSizes.put((Object)name, this.sectionSizes.get((Object)name) + bytes);
    }

    @Override
    public void addStringsSize(int bytes) {
        this.stringsSize += bytes;
    }

    public void write(Writer writer) throws IOException {
        PrintWriter pw = new PrintWriter(writer);
        pw.println("[classes]");
        for (Map.Entry<String, ClassStats> entry : this.statsByClass.entrySet()) {
            pw.append(entry.getKey()).append(" ");
            pw.print(entry.getValue().codeSize);
            pw.append(" ");
            pw.print(entry.getValue().metadataSize);
            pw.println();
        }
        pw.println();
        pw.println("[strings]");
        pw.println(this.stringsSize);
        pw.println();
        pw.println("[sections]");
        for (ObjectIntCursor objectIntCursor : this.sectionSizes) {
            pw.append((CharSequence)objectIntCursor.key).append(" ");
            pw.print(objectIntCursor.value);
            pw.println();
        }
    }

    private static class ClassStats {
        int codeSize;
        int metadataSize;

        private ClassStats() {
        }
    }
}

