/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.rendering;

import java.util.Set;
import org.teavm.ast.ArrayFromDataExpr;
import org.teavm.ast.AssignmentStatement;
import org.teavm.ast.AsyncMethodNode;
import org.teavm.ast.AsyncMethodPart;
import org.teavm.ast.BinaryExpr;
import org.teavm.ast.BoundCheckExpr;
import org.teavm.ast.CastExpr;
import org.teavm.ast.ConstantExpr;
import org.teavm.ast.InitClassStatement;
import org.teavm.ast.InstanceOfExpr;
import org.teavm.ast.InvocationExpr;
import org.teavm.ast.MethodNodeVisitor;
import org.teavm.ast.MonitorEnterStatement;
import org.teavm.ast.MonitorExitStatement;
import org.teavm.ast.NewArrayExpr;
import org.teavm.ast.NewExpr;
import org.teavm.ast.NewMultiArrayExpr;
import org.teavm.ast.OperationType;
import org.teavm.ast.PrimitiveCastExpr;
import org.teavm.ast.QualificationExpr;
import org.teavm.ast.RecursiveVisitor;
import org.teavm.ast.RegularMethodNode;
import org.teavm.ast.ThrowStatement;
import org.teavm.ast.TryCatchStatement;
import org.teavm.ast.UnaryExpr;
import org.teavm.backend.javascript.codegen.NameFrequencyConsumer;
import org.teavm.backend.javascript.decompile.PreparedClass;
import org.teavm.backend.javascript.decompile.PreparedMethod;
import org.teavm.backend.javascript.rendering.RenderingUtil;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

class NameFrequencyEstimator
extends RecursiveVisitor
implements MethodNodeVisitor {
    static final MethodReference MONITOR_ENTER_METHOD = new MethodReference(Object.class, "monitorEnter", Object.class, Void.TYPE);
    static final MethodReference MONITOR_ENTER_SYNC_METHOD = new MethodReference(Object.class, "monitorEnterSync", Object.class, Void.TYPE);
    static final MethodReference MONITOR_EXIT_METHOD = new MethodReference(Object.class, "monitorExit", Object.class, Void.TYPE);
    static final MethodReference MONITOR_EXIT_SYNC_METHOD = new MethodReference(Object.class, "monitorExitSync", Object.class, Void.TYPE);
    private static final MethodDescriptor CLINIT_METHOD = new MethodDescriptor("<clinit>", ValueType.VOID);
    private final NameFrequencyConsumer consumer;
    private final ClassReaderSource classSource;
    private boolean async;
    private final Set<MethodReference> injectedMethods;
    private final Set<MethodReference> asyncFamilyMethods;
    private final boolean strict;

    NameFrequencyEstimator(NameFrequencyConsumer consumer, ClassReaderSource classSource, Set<MethodReference> injectedMethods, Set<MethodReference> asyncFamilyMethods, boolean strict) {
        this.consumer = consumer;
        this.classSource = classSource;
        this.injectedMethods = injectedMethods;
        this.asyncFamilyMethods = asyncFamilyMethods;
        this.strict = strict;
    }

    public void estimate(PreparedClass cls) {
        boolean bl;
        this.consumer.consume(cls.getName());
        if (cls.getParentName() != null) {
            this.consumer.consume(cls.getParentName());
        }
        for (FieldHolder fieldHolder : cls.getClassHolder().getFields()) {
            this.consumer.consume(new FieldReference(cls.getName(), fieldHolder.getName()));
            if (!fieldHolder.getModifiers().contains((Object)ElementModifier.STATIC)) continue;
            this.consumer.consume(cls.getName());
        }
        MethodReader clinit = this.classSource.get(cls.getName()).getMethod(CLINIT_METHOD);
        for (PreparedMethod method : cls.getMethods()) {
            this.consumer.consume(method.reference);
            if (this.asyncFamilyMethods.contains(method.reference)) {
                this.consumer.consume(method.reference);
            }
            if (clinit != null && (method.methodHolder.getModifiers().contains((Object)ElementModifier.STATIC) || method.reference.getName().equals("<init>"))) {
                this.consumer.consume(method.reference);
            }
            if (!method.methodHolder.getModifiers().contains((Object)ElementModifier.STATIC)) {
                this.consumer.consume(method.reference.getDescriptor());
                this.consumer.consume(method.reference);
            }
            if (method.async) {
                this.consumer.consumeFunction("$rt_nativeThread");
                this.consumer.consumeFunction("$rt_nativeThread");
                this.consumer.consumeFunction("$rt_resuming");
                this.consumer.consumeFunction("$rt_invalidPointer");
            }
            if (method.node == null) continue;
            method.node.acceptVisitor(this);
        }
        if (clinit != null) {
            this.consumer.consumeFunction("$rt_eraseClinit");
        }
        this.consumer.consume(cls.getName());
        this.consumer.consume(cls.getName());
        if (cls.getParentName() != null) {
            this.consumer.consume(cls.getParentName());
        }
        for (String iface : cls.getClassHolder().getInterfaces()) {
            this.consumer.consume(iface);
        }
        boolean bl2 = false;
        for (FieldHolder field : cls.getClassHolder().getFields()) {
            if (field.hasModifier(ElementModifier.STATIC)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.consumer.consumeFunction("$rt_classWithoutFields");
        }
    }

    @Override
    public void visit(RegularMethodNode methodNode) {
        this.async = false;
        methodNode.getBody().acceptVisitor(this);
    }

    @Override
    public void visit(AsyncMethodNode methodNode) {
        this.async = true;
        for (AsyncMethodPart part : methodNode.getBody()) {
            part.getStatement().acceptVisitor(this);
        }
    }

    @Override
    public void visit(AssignmentStatement statement) {
        super.visit(statement);
        if (statement.isAsync()) {
            this.consumer.consumeFunction("$rt_suspending");
        }
    }

    @Override
    public void visit(ThrowStatement statement) {
        statement.getException().acceptVisitor(this);
        this.consumer.consumeFunction("$rt_throw");
    }

    @Override
    public void visit(InitClassStatement statement) {
        this.consumer.consumeClassInit(statement.getClassName());
    }

    @Override
    public void visit(TryCatchStatement statement) {
        super.visit(statement);
        if (statement.getExceptionType() != null) {
            this.consumer.consume(statement.getExceptionType());
        }
        this.consumer.consumeFunction("$rt_wrapException");
    }

    @Override
    public void visit(MonitorEnterStatement statement) {
        super.visit(statement);
        if (this.async) {
            this.consumer.consume(MONITOR_ENTER_METHOD);
            this.consumer.consumeFunction("$rt_suspending");
        } else {
            this.consumer.consume(MONITOR_ENTER_SYNC_METHOD);
        }
    }

    @Override
    public void visit(MonitorExitStatement statement) {
        super.visit(statement);
        if (this.async) {
            this.consumer.consume(MONITOR_EXIT_METHOD);
        } else {
            this.consumer.consume(MONITOR_EXIT_SYNC_METHOD);
        }
    }

    @Override
    public void visit(BinaryExpr expr) {
        super.visit(expr);
        if (expr.getType() == OperationType.LONG) {
            switch (expr.getOperation()) {
                case ADD: {
                    this.consumer.consumeFunction("Long_add");
                    break;
                }
                case SUBTRACT: {
                    this.consumer.consumeFunction("Long_sub");
                    break;
                }
                case MULTIPLY: {
                    this.consumer.consumeFunction("Long_mul");
                    break;
                }
                case DIVIDE: {
                    this.consumer.consumeFunction("Long_div");
                    break;
                }
                case MODULO: {
                    this.consumer.consumeFunction("Long_rem");
                    break;
                }
                case BITWISE_OR: {
                    this.consumer.consumeFunction("Long_or");
                    break;
                }
                case BITWISE_AND: {
                    this.consumer.consumeFunction("Long_and");
                    break;
                }
                case BITWISE_XOR: {
                    this.consumer.consumeFunction("Long_xor");
                    break;
                }
                case LEFT_SHIFT: {
                    this.consumer.consumeFunction("Long_shl");
                    break;
                }
                case RIGHT_SHIFT: {
                    this.consumer.consumeFunction("Long_shr");
                    break;
                }
                case UNSIGNED_RIGHT_SHIFT: {
                    this.consumer.consumeFunction("Long_shru");
                    break;
                }
                case COMPARE: {
                    this.consumer.consumeFunction("Long_compare");
                    break;
                }
                case EQUALS: {
                    this.consumer.consumeFunction("Long_eq");
                    break;
                }
                case NOT_EQUALS: {
                    this.consumer.consumeFunction("Long_ne");
                    break;
                }
                case LESS: {
                    this.consumer.consumeFunction("Long_lt");
                    break;
                }
                case LESS_OR_EQUALS: {
                    this.consumer.consumeFunction("Long_le");
                    break;
                }
                case GREATER: {
                    this.consumer.consumeFunction("Long_gt");
                    break;
                }
                case GREATER_OR_EQUALS: {
                    this.consumer.consumeFunction("Long_ge");
                }
            }
            return;
        }
        switch (expr.getOperation()) {
            case COMPARE: {
                this.consumer.consumeFunction("$rt_compare");
                break;
            }
            case MULTIPLY: {
                if (expr.getType() != OperationType.INT || RenderingUtil.isSmallInteger(expr.getFirstOperand()) || RenderingUtil.isSmallInteger(expr.getSecondOperand())) break;
                this.consumer.consumeFunction("$rt_imul");
                break;
            }
        }
    }

    @Override
    public void visit(UnaryExpr expr) {
        super.visit(expr);
        switch (expr.getOperation()) {
            case NULL_CHECK: {
                this.consumer.consumeFunction("$rt_nullCheck");
                break;
            }
            case NEGATE: {
                if (expr.getType() != OperationType.LONG) break;
                this.consumer.consumeFunction("Long_neg");
                break;
            }
            case NOT: {
                if (expr.getType() != OperationType.LONG) break;
                this.consumer.consumeFunction("Long_not");
                break;
            }
        }
    }

    @Override
    public void visit(PrimitiveCastExpr expr) {
        super.visit(expr);
        if (expr.getSource() == OperationType.LONG) {
            if (expr.getTarget() == OperationType.DOUBLE || expr.getTarget() == OperationType.FLOAT) {
                this.consumer.consumeFunction("Long_toNumber");
            } else if (expr.getTarget() == OperationType.INT) {
                this.consumer.consumeFunction("Long_lo");
            }
        } else if (expr.getTarget() == OperationType.LONG) {
            switch (expr.getSource()) {
                case INT: {
                    this.consumer.consumeFunction("Long_fromInt");
                    break;
                }
                case FLOAT: 
                case DOUBLE: {
                    this.consumer.consumeFunction("Long_fromNUmber");
                }
            }
        }
    }

    @Override
    public void visit(ConstantExpr expr) {
        if (expr.getValue() instanceof ValueType) {
            this.visitType((ValueType)expr.getValue());
        } else if (expr.getValue() instanceof String) {
            this.consumer.consumeFunction("$rt_s");
        } else if (expr.getValue() instanceof Long) {
            long value = (Long)expr.getValue();
            if (value == 0L) {
                this.consumer.consumeFunction("Long_ZERO");
            } else if ((long)((int)value) == value) {
                this.consumer.consumeFunction("Long_fromInt");
            } else {
                this.consumer.consumeFunction("Long_create");
            }
        }
    }

    private void visitType(ValueType type) {
        while (type instanceof ValueType.Array) {
            type = ((ValueType.Array)type).getItemType();
        }
        if (type instanceof ValueType.Object) {
            String clsName = ((ValueType.Object)type).getClassName();
            this.consumer.consume(clsName);
            this.consumer.consumeFunction("$rt_cls");
        }
    }

    @Override
    public void visit(InvocationExpr expr) {
        super.visit(expr);
        if (this.injectedMethods.contains(expr.getMethod())) {
            return;
        }
        switch (expr.getType()) {
            case SPECIAL: 
            case STATIC: {
                this.consumer.consume(expr.getMethod());
                break;
            }
            case CONSTRUCTOR: {
                this.consumer.consumeInit(expr.getMethod());
                break;
            }
            case DYNAMIC: {
                this.consumer.consume(expr.getMethod().getDescriptor());
            }
        }
    }

    @Override
    public void visit(QualificationExpr expr) {
        super.visit(expr);
        this.consumer.consume(expr.getField());
    }

    @Override
    public void visit(NewExpr expr) {
        super.visit(expr);
        this.consumer.consume(expr.getConstructedClass());
    }

    @Override
    public void visit(NewArrayExpr expr) {
        super.visit(expr);
        this.visitType(expr.getType());
        if (expr.getType() instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)expr.getType()).getKind()) {
                case BOOLEAN: {
                    this.consumer.consumeFunction("$rt_createBooleanArray");
                    break;
                }
                case BYTE: {
                    this.consumer.consumeFunction("$rt_createByteArray");
                    break;
                }
                case SHORT: {
                    this.consumer.consumeFunction("$rt_createShortArray");
                    break;
                }
                case CHARACTER: {
                    this.consumer.consumeFunction("$rt_createCharArray");
                    break;
                }
                case INTEGER: {
                    this.consumer.consumeFunction("$rt_createIntArray");
                    break;
                }
                case LONG: {
                    this.consumer.consumeFunction("$rt_createLongArray");
                    break;
                }
                case FLOAT: {
                    this.consumer.consumeFunction("$rt_createFloatArray");
                    break;
                }
                case DOUBLE: {
                    this.consumer.consumeFunction("$rt_createDoubleArray");
                }
            }
        } else {
            this.consumer.consumeFunction("$rt_createArray");
        }
    }

    @Override
    public void visit(ArrayFromDataExpr expr) {
        super.visit(expr);
        this.visitType(expr.getType());
        if (expr.getType() instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)expr.getType()).getKind()) {
                case BOOLEAN: {
                    this.consumer.consumeFunction("$rt_createBooleanArrayFromData");
                    break;
                }
                case BYTE: {
                    this.consumer.consumeFunction("$rt_createByteArrayFromData");
                    break;
                }
                case SHORT: {
                    this.consumer.consumeFunction("$rt_createShortArrayFromData");
                    break;
                }
                case CHARACTER: {
                    this.consumer.consumeFunction("$rt_createCharArrayFromData");
                    break;
                }
                case INTEGER: {
                    this.consumer.consumeFunction("$rt_createIntArrayFromData");
                    break;
                }
                case LONG: {
                    this.consumer.consumeFunction("$rt_createLongArrayFromData");
                    break;
                }
                case FLOAT: {
                    this.consumer.consumeFunction("$rt_createFloatArrayFromData");
                    break;
                }
                case DOUBLE: {
                    this.consumer.consumeFunction("$rt_createDoubleArrayFromData");
                }
            }
        } else {
            this.consumer.consumeFunction("$rt_createArrayFromData");
        }
    }

    @Override
    public void visit(NewMultiArrayExpr expr) {
        super.visit(expr);
        this.visitType(expr.getType());
    }

    @Override
    public void visit(InstanceOfExpr expr) {
        super.visit(expr);
        this.visitType(expr.getType());
        if (!this.isClass(expr.getType())) {
            this.consumer.consumeFunction("$rt_isInstance");
        }
    }

    @Override
    public void visit(CastExpr expr) {
        super.visit(expr);
        if (this.strict) {
            this.visitType(expr.getTarget());
            if (this.isClass(expr.getTarget())) {
                this.consumer.consumeFunction("$rt_castToClass");
            } else {
                this.consumer.consumeFunction("$rt_castToInterface");
            }
        }
    }

    private boolean isClass(ValueType type) {
        if (!(type instanceof ValueType.Object)) {
            return false;
        }
        String className = ((ValueType.Object)type).getClassName();
        ClassReader cls = this.classSource.get(className);
        return cls != null && !cls.hasModifier(ElementModifier.INTERFACE);
    }

    @Override
    public void visit(BoundCheckExpr expr) {
        super.visit(expr);
        if (expr.getArray() != null && expr.getIndex() != null) {
            this.consumer.consumeFunction("$rt_checkBounds");
        } else if (expr.getArray() != null) {
            this.consumer.consumeFunction("$rt_checkUpperBound");
        } else if (expr.isLower()) {
            this.consumer.consumeFunction("$rt_checkLowerBound");
        }
    }
}

