/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.codegen;

import java.io.IOException;
import org.teavm.backend.javascript.codegen.LocationProvider;
import org.teavm.backend.javascript.codegen.NamingStrategy;
import org.teavm.backend.javascript.codegen.ScopedName;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class SourceWriter
implements Appendable,
LocationProvider {
    private final Appendable innerWriter;
    private int indentSize;
    private final NamingStrategy naming;
    private boolean lineStart;
    private boolean minified;
    private final int lineWidth;
    private int column;
    private int line;
    private int offset;

    SourceWriter(NamingStrategy naming, Appendable innerWriter, int lineWidth) {
        this.naming = naming;
        this.innerWriter = innerWriter;
        this.lineWidth = lineWidth;
    }

    void setMinified(boolean minified) {
        this.minified = minified;
    }

    public SourceWriter append(String value) throws IOException {
        this.append((CharSequence)value);
        return this;
    }

    public SourceWriter appendBlockStart() throws IOException {
        return this.ws().append("{").indent().softNewLine();
    }

    public SourceWriter appendBlockEnd() throws IOException {
        return this.outdent().append("}").softNewLine();
    }

    public SourceWriter appendIf() throws IOException {
        return this.append("if").ws().append("(");
    }

    public SourceWriter appendElseIf() throws IOException {
        return this.outdent().append("}").ws().append("else ").appendIf();
    }

    public SourceWriter appendElse() throws IOException {
        return this.outdent().append("}").ws().append("else").appendBlockStart();
    }

    public SourceWriter append(int value) throws IOException {
        return this.append(String.valueOf(value));
    }

    @Override
    public SourceWriter append(char value) throws IOException {
        this.appendIndent();
        this.innerWriter.append(value);
        if (value == '\n') {
            this.newLine();
        } else {
            ++this.column;
            ++this.offset;
        }
        return this;
    }

    @Override
    public SourceWriter append(CharSequence csq) throws IOException {
        this.append(csq, 0, csq.length());
        return this;
    }

    @Override
    public SourceWriter append(CharSequence csq, int start, int end) throws IOException {
        int last = start;
        for (int i = start; i < end; ++i) {
            if (csq.charAt(i) != '\n') continue;
            this.appendSingleLine(csq, last, i);
            this.newLine();
            last = i + 1;
        }
        this.appendSingleLine(csq, last, end);
        return this;
    }

    private void appendSingleLine(CharSequence csq, int start, int end) throws IOException {
        if (start == end) {
            return;
        }
        this.appendIndent();
        this.column += end - start;
        this.offset += end - start;
        this.innerWriter.append(csq, start, end);
    }

    public SourceWriter appendClass(String cls) throws IOException {
        return this.appendName(this.naming.getNameFor(cls));
    }

    public SourceWriter appendClass(Class<?> cls) throws IOException {
        return this.appendClass(cls.getName());
    }

    public SourceWriter appendField(FieldReference field) throws IOException {
        return this.append(this.naming.getNameFor(field));
    }

    public SourceWriter appendStaticField(FieldReference field) throws IOException {
        return this.appendName(this.naming.getFullNameFor(field));
    }

    public SourceWriter appendMethod(MethodDescriptor method) throws IOException {
        return this.append(this.naming.getNameFor(method));
    }

    public SourceWriter appendMethod(String name, Class<?> ... params) throws IOException {
        return this.append(this.naming.getNameFor(new MethodDescriptor(name, params)));
    }

    public SourceWriter appendMethodBody(MethodReference method) throws IOException {
        return this.appendName(this.naming.getFullNameFor(method));
    }

    public SourceWriter appendMethodBody(String className, String name, ValueType ... params) throws IOException {
        return this.appendMethodBody(new MethodReference(className, new MethodDescriptor(name, params)));
    }

    public SourceWriter appendMethodBody(Class<?> cls, String name, Class<?> ... params) throws IOException {
        return this.appendMethodBody(new MethodReference(cls, name, params));
    }

    public SourceWriter appendFunction(String name) throws IOException {
        return this.append(this.naming.getNameForFunction(name));
    }

    public SourceWriter appendInit(MethodReference method) throws IOException {
        return this.appendName(this.naming.getNameForInit(method));
    }

    public SourceWriter appendClassInit(String className) throws IOException {
        return this.appendName(this.naming.getNameForClassInit(className));
    }

    private SourceWriter appendName(ScopedName name) throws IOException {
        if (name.scoped) {
            this.append(this.naming.getScopeName()).append(".");
        }
        this.append(name.value);
        return this;
    }

    private void appendIndent() throws IOException {
        if (this.minified) {
            return;
        }
        if (this.lineStart) {
            for (int i = 0; i < this.indentSize; ++i) {
                this.innerWriter.append("    ");
                this.column += 4;
                this.offset += 4;
            }
            this.lineStart = false;
        }
    }

    public SourceWriter newLine() throws IOException {
        this.innerWriter.append('\n');
        this.column = 0;
        ++this.line;
        ++this.offset;
        this.lineStart = true;
        return this;
    }

    public SourceWriter ws() throws IOException {
        if (this.column >= this.lineWidth) {
            this.newLine();
        } else if (!this.minified) {
            this.innerWriter.append(' ');
            ++this.column;
            ++this.offset;
        }
        return this;
    }

    public SourceWriter tokenBoundary() throws IOException {
        if (this.column >= this.lineWidth) {
            this.newLine();
        }
        return this;
    }

    public SourceWriter softNewLine() throws IOException {
        if (!this.minified) {
            this.innerWriter.append('\n');
            this.column = 0;
            ++this.offset;
            ++this.line;
            this.lineStart = true;
        }
        return this;
    }

    public SourceWriter indent() {
        ++this.indentSize;
        return this;
    }

    public SourceWriter outdent() {
        --this.indentSize;
        return this;
    }

    public NamingStrategy getNaming() {
        return this.naming;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }
}

