/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.codegen;

import java.util.HashSet;
import java.util.Set;
import org.teavm.backend.javascript.codegen.AliasProvider;
import org.teavm.backend.javascript.codegen.ScopedName;
import org.teavm.backend.javascript.rendering.RenderingUtil;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;

public class MinifyingAliasProvider
implements AliasProvider {
    private int topLevelAliasLimit;
    private static final String startLetters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String startVirtualLetters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private int lastSuffix;
    private int lastScopedSuffix;
    private int lastVirtual;
    private final Set<String> usedAliases = new HashSet<String>();
    private final Set<String> usedVirtualAliases = new HashSet<String>();
    private final Set<String> usedScopedAliases = new HashSet<String>();

    public MinifyingAliasProvider(int topLevelAliasLimit) {
        this.topLevelAliasLimit = topLevelAliasLimit;
    }

    @Override
    public String getFieldAlias(FieldReference field) {
        String result;
        while (!this.usedVirtualAliases.add(result = RenderingUtil.indexToId(this.lastVirtual++, startVirtualLetters)) || RenderingUtil.KEYWORDS.contains(result)) {
        }
        return result;
    }

    @Override
    public ScopedName getStaticFieldAlias(FieldReference field) {
        return this.createTopLevelName();
    }

    @Override
    public ScopedName getStaticMethodAlias(MethodReference method) {
        return this.createTopLevelName();
    }

    @Override
    public String getMethodAlias(MethodDescriptor method) {
        String result;
        while (!this.usedVirtualAliases.add(result = RenderingUtil.indexToId(this.lastVirtual++, startVirtualLetters)) || RenderingUtil.KEYWORDS.contains(result)) {
        }
        return result;
    }

    @Override
    public ScopedName getClassAlias(String className) {
        return this.createTopLevelName();
    }

    @Override
    public String getFunctionAlias(String className) {
        return RenderingUtil.indexToId(this.lastSuffix++, startLetters);
    }

    @Override
    public ScopedName getClassInitAlias(String className) {
        return this.createTopLevelName();
    }

    @Override
    public String getScopeAlias() {
        String result;
        while (!this.usedAliases.add(result = RenderingUtil.indexToId(this.lastSuffix++, startLetters)) || RenderingUtil.KEYWORDS.contains(result)) {
        }
        return result;
    }

    private ScopedName createTopLevelName() {
        String result;
        if (this.usedAliases.size() < this.topLevelAliasLimit) {
            String result2;
            while (!this.usedAliases.add(result2 = RenderingUtil.indexToId(this.lastSuffix++, startLetters)) || RenderingUtil.KEYWORDS.contains(result2)) {
            }
            return new ScopedName(false, result2);
        }
        while (!this.usedScopedAliases.add(result = RenderingUtil.indexToId(this.lastScopedSuffix++, startLetters)) || RenderingUtil.KEYWORDS.contains(result)) {
        }
        return new ScopedName(true, result);
    }
}

