/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.c.intrinsic;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.c.intrinsic.Intrinsic;
import org.teavm.backend.c.intrinsic.IntrinsicContext;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReference;
import org.teavm.runtime.RuntimeClass;

public class PlatformClassMetadataIntrinsic
implements Intrinsic {
    private static final String PLATFORM_CLASS_METADATA = "org.teavm.platform.PlatformClassMetadata";
    private static final FieldReference ITEM_TYPE_FIELD = new FieldReference(RuntimeClass.class.getName(), "itemType");
    private static final FieldReference SUPERCLASS_FIELD = new FieldReference(RuntimeClass.class.getName(), "parent");
    private static final FieldReference NAME_FIELD = new FieldReference(RuntimeClass.class.getName(), "name");
    private static final FieldReference SIMPLE_NAME_FIELD = new FieldReference(RuntimeClass.class.getName(), "simpleName");
    private static final FieldReference DECLARING_CLASS_FIELD = new FieldReference(RuntimeClass.class.getName(), "declaringClass");
    private static final FieldReference ENCLOSING_CLASS_FIELD = new FieldReference(RuntimeClass.class.getName(), "enclosingClass");

    @Override
    public boolean canHandle(MethodReference method) {
        if (!method.getClassName().equals(PLATFORM_CLASS_METADATA)) {
            return false;
        }
        switch (method.getName()) {
            case "getArrayItem": 
            case "getSuperclass": 
            case "getName": 
            case "getSimpleName": 
            case "getDeclaringClass": 
            case "getEnclosingClass": {
                return true;
            }
        }
        return false;
    }

    @Override
    public void apply(IntrinsicContext context, InvocationExpr invocation) {
        switch (invocation.getMethod().getName()) {
            case "getArrayItem": {
                this.printFieldAccess(context, invocation, ITEM_TYPE_FIELD);
                break;
            }
            case "getSuperclass": {
                this.printFieldAccess(context, invocation, SUPERCLASS_FIELD);
                break;
            }
            case "getName": {
                context.writer().print("(");
                this.printFieldAccess(context, invocation, NAME_FIELD);
                context.writer().print(" ? *");
                this.printFieldAccess(context, invocation, NAME_FIELD);
                context.writer().print(" : NULL)");
                break;
            }
            case "getSimpleName": {
                context.writer().print("(");
                this.printFieldAccess(context, invocation, SIMPLE_NAME_FIELD);
                context.writer().print(" ? *");
                this.printFieldAccess(context, invocation, SIMPLE_NAME_FIELD);
                context.writer().print(" : NULL)");
                break;
            }
            case "getDeclaringClass": {
                this.printFieldAccess(context, invocation, DECLARING_CLASS_FIELD);
                break;
            }
            case "getEnclosingClass": {
                this.printFieldAccess(context, invocation, ENCLOSING_CLASS_FIELD);
            }
        }
    }

    private void printFieldAccess(IntrinsicContext context, InvocationExpr invocation, FieldReference field) {
        context.writer().print("TEAVM_FIELD(");
        context.emit(invocation.getArguments().get(0));
        context.writer().print(",");
        context.writer().print(context.names().forClass(field.getClassName())).print(", ");
        context.writer().print(context.names().forMemberField(field));
        context.writer().print(")");
    }
}

