/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics;

import org.teavm.ast.InvocationExpr;
import org.teavm.ast.InvocationType;
import org.teavm.backend.wasm.WasmRuntime;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.model.MethodReference;
import org.teavm.runtime.ShadowStack;

public class ShadowStackIntrinsic
implements WasmIntrinsic {
    @Override
    public boolean isApplicable(MethodReference methodReference) {
        if (!methodReference.getClassName().equals(ShadowStack.class.getName())) {
            return false;
        }
        switch (methodReference.getName()) {
            case "getStackTop": 
            case "getNextStackFrame": 
            case "getStackRootCount": 
            case "getStackRootPointer": 
            case "getCallSiteId": 
            case "setExceptionHandlerId": {
                return true;
            }
        }
        return false;
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        InvocationExpr expr = new InvocationExpr();
        MethodReference method = new MethodReference(WasmRuntime.class.getName(), invocation.getMethod().getDescriptor());
        expr.setMethod(method);
        expr.setType(InvocationType.SPECIAL);
        expr.getArguments().addAll(invocation.getArguments());
        return manager.generate(expr);
    }
}

