/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.teavm.backend.lowlevel.generate.NameProvider;
import org.teavm.backend.wasm.generate.WasmStringPool;
import org.teavm.backend.wasm.generators.WasmMethodGenerator;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.interop.Import;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.model.classes.TagRegistry;
import org.teavm.model.classes.VirtualTableProvider;

public class WasmGenerationContext {
    private ClassReaderSource classSource;
    private WasmModule module;
    private Diagnostics diagnostics;
    private VirtualTableProvider vtableProvider;
    private TagRegistry tagRegistry;
    private WasmStringPool stringPool;
    public final NameProvider names;
    private Map<MethodReference, ImportedMethod> importedMethods = new HashMap<MethodReference, ImportedMethod>();
    private List<WasmIntrinsic> intrinsics = new ArrayList<WasmIntrinsic>();
    private List<WasmMethodGenerator> generators = new ArrayList<WasmMethodGenerator>();
    private Map<MethodReference, IntrinsicHolder> intrinsicCache = new HashMap<MethodReference, IntrinsicHolder>();
    private Map<MethodReference, GeneratorHolder> generatorCache = new HashMap<MethodReference, GeneratorHolder>();

    public WasmGenerationContext(ClassReaderSource classSource, WasmModule module, Diagnostics diagnostics, VirtualTableProvider vtableProvider, TagRegistry tagRegistry, WasmStringPool stringPool, NameProvider names) {
        this.classSource = classSource;
        this.module = module;
        this.diagnostics = diagnostics;
        this.vtableProvider = vtableProvider;
        this.tagRegistry = tagRegistry;
        this.stringPool = stringPool;
        this.names = names;
    }

    public void addIntrinsic(WasmIntrinsic intrinsic) {
        this.intrinsics.add(intrinsic);
    }

    public void addGenerator(WasmMethodGenerator generator) {
        this.generators.add(generator);
    }

    public WasmIntrinsic getIntrinsic(MethodReference method) {
        return this.intrinsicCache.computeIfAbsent((MethodReference)method, (Function<MethodReference, IntrinsicHolder>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getIntrinsic$1(org.teavm.model.MethodReference ), (Lorg/teavm/model/MethodReference;)Lorg/teavm/backend/wasm/generate/WasmGenerationContext$IntrinsicHolder;)((WasmGenerationContext)this)).value;
    }

    public WasmMethodGenerator getGenerator(MethodReference method) {
        return this.generatorCache.computeIfAbsent((MethodReference)method, (Function<MethodReference, GeneratorHolder>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getGenerator$3(org.teavm.model.MethodReference ), (Lorg/teavm/model/MethodReference;)Lorg/teavm/backend/wasm/generate/WasmGenerationContext$GeneratorHolder;)((WasmGenerationContext)this)).value;
    }

    public ImportedMethod getImportedMethod(MethodReference reference) {
        return this.importedMethods.computeIfAbsent(reference, ref -> {
            String module;
            ClassReader cls = this.classSource.get(ref.getClassName());
            if (cls == null) {
                return null;
            }
            MethodReader method = cls.getMethod(ref.getDescriptor());
            if (method == null) {
                return null;
            }
            AnnotationReader annotation = method.getAnnotations().get(Import.class.getName());
            if (annotation == null) {
                return null;
            }
            String name = annotation.getValue("name").getString();
            AnnotationValue moduleValue = annotation.getValue("module");
            String string = module = moduleValue != null ? moduleValue.getString() : null;
            if (module != null && module.isEmpty()) {
                module = null;
            }
            return new ImportedMethod(name, module);
        });
    }

    public WasmFunction getFunction(String name) {
        return this.module.getFunctions().get(name);
    }

    public ClassReaderSource getClassSource() {
        return this.classSource;
    }

    public ValueType getFieldType(FieldReference fieldReference) {
        ClassReader cls = this.classSource.get(fieldReference.getClassName());
        FieldReader field = cls.getField(fieldReference.getFieldName());
        return field.getType();
    }

    public VirtualTableProvider getVirtualTableProvider() {
        return this.vtableProvider;
    }

    public TagRegistry getTagRegistry() {
        return this.tagRegistry;
    }

    public WasmStringPool getStringPool() {
        return this.stringPool;
    }

    public Diagnostics getDiagnostics() {
        return this.diagnostics;
    }

    private /* synthetic */ GeneratorHolder lambda$getGenerator$3(MethodReference key) {
        return new GeneratorHolder(this.generators.stream().filter(generator -> generator.isApplicable(key)).findFirst().orElse(null));
    }

    private /* synthetic */ IntrinsicHolder lambda$getIntrinsic$1(MethodReference key) {
        return new IntrinsicHolder(this.intrinsics.stream().filter(intrinsic -> intrinsic.isApplicable(key)).findFirst().orElse(null));
    }

    static class IntrinsicHolder {
        WasmIntrinsic value;

        IntrinsicHolder(WasmIntrinsic value) {
            this.value = value;
        }
    }

    static class GeneratorHolder {
        WasmMethodGenerator value;

        GeneratorHolder(WasmMethodGenerator value) {
            this.value = value;
        }
    }

    public static class ImportedMethod {
        public final String name;
        public final String module;

        ImportedMethod(String name, String module) {
            this.name = name;
            this.module = module;
        }
    }
}

