/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.debug.parser;

import java.util.ArrayList;
import org.teavm.backend.wasm.debug.info.ClassInfo;
import org.teavm.backend.wasm.debug.info.PackageInfo;
import org.teavm.backend.wasm.debug.parser.DebugPackageParser;
import org.teavm.backend.wasm.debug.parser.DebugSectionParser;
import org.teavm.backend.wasm.debug.parser.DebugStringParser;

public class DebugClassParser
extends DebugSectionParser {
    private DebugStringParser strings;
    private DebugPackageParser packages;
    private ClassInfoImpl[] classes;

    public DebugClassParser(DebugStringParser strings, DebugPackageParser packages) {
        super("teavm_cls", strings, packages);
        this.strings = strings;
        this.packages = packages;
    }

    public ClassInfo getClass(int ptr) {
        return this.classes[ptr];
    }

    @Override
    protected void doParse() {
        ArrayList<ClassInfoImpl> classes = new ArrayList<ClassInfoImpl>();
        while (this.ptr < this.data.length) {
            PackageInfo pkg = this.packages.getPackage(this.readLEB());
            String name = this.strings.getString(this.readLEB());
            classes.add(new ClassInfoImpl(pkg, name));
        }
        this.classes = classes.toArray(new ClassInfoImpl[0]);
    }

    private static class ClassInfoImpl
    extends ClassInfo {
        private PackageInfo pkg;
        private String name;

        ClassInfoImpl(PackageInfo pkg, String name) {
            this.pkg = pkg;
            this.name = name;
        }

        @Override
        public PackageInfo pkg() {
            return this.pkg;
        }

        @Override
        public String name() {
            return this.name;
        }
    }
}

