/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.c.analyze;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.ast.AssignmentStatement;
import org.teavm.ast.BlockStatement;
import org.teavm.ast.BreakStatement;
import org.teavm.ast.ConditionalStatement;
import org.teavm.ast.ContinueStatement;
import org.teavm.ast.Expr;
import org.teavm.ast.IdentifiedStatement;
import org.teavm.ast.RecursiveVisitor;
import org.teavm.ast.ReturnStatement;
import org.teavm.ast.Statement;
import org.teavm.ast.SwitchClause;
import org.teavm.ast.SwitchStatement;
import org.teavm.ast.ThrowStatement;
import org.teavm.ast.TryCatchStatement;
import org.teavm.ast.VariableExpr;
import org.teavm.ast.WhileStatement;
import org.teavm.common.Graph;
import org.teavm.common.GraphBuilder;
import org.teavm.hppc.IntArrayList;
import org.teavm.hppc.IntHashSet;
import org.teavm.hppc.IntIntHashMap;
import org.teavm.hppc.IntIntMap;
import org.teavm.hppc.IntObjectHashMap;
import org.teavm.hppc.IntObjectMap;
import org.teavm.hppc.IntSet;
import org.teavm.hppc.IntStack;
import org.teavm.hppc.LongHashSet;
import org.teavm.hppc.LongSet;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;
import org.teavm.hppc.cursors.IntCursor;

public class AstDefinitionUsageAnalysis {
    private GraphBuilder graphBuilder = new GraphBuilder();
    private GraphBuilder exceptionGraphBuilder = new GraphBuilder();
    private Graph cfg;
    private Graph exceptionGraph;
    private List<Node> nodes = new ArrayList<Node>();
    private int lastNode = -1;
    private IdentifiedStatement defaultBreakTarget;
    private IdentifiedStatement defaultContinueTarget;
    private ObjectIntMap<IdentifiedStatement> breakTargets = new ObjectIntHashMap();
    private ObjectIntMap<IdentifiedStatement> continueTargets = new ObjectIntHashMap();
    private List<Definition> definitions = new ArrayList<Definition>();
    private List<? extends Definition> readonlyDefinitions = Collections.unmodifiableList(this.definitions);
    private ObjectIntMap<Definition> definitionIds = new ObjectIntHashMap();
    private List<VariableExpr> usages = new ArrayList<VariableExpr>();
    private IntStack stack = new IntStack();
    private IntStack exceptionHandlerStack = new IntStack();
    private RecursiveVisitor visitor = new RecursiveVisitor(){

        @Override
        public void visit(ConditionalStatement statement) {
            statement.getCondition().acceptVisitor(this);
            int forkNode = AstDefinitionUsageAnalysis.this.createNode();
            int joinNode = AstDefinitionUsageAnalysis.this.createNode();
            AstDefinitionUsageAnalysis.this.connect(AstDefinitionUsageAnalysis.this.lastNode, forkNode);
            AstDefinitionUsageAnalysis.this.lastNode = forkNode;
            this.visit(statement.getConsequent());
            AstDefinitionUsageAnalysis.this.connect(AstDefinitionUsageAnalysis.this.lastNode, joinNode);
            AstDefinitionUsageAnalysis.this.lastNode = forkNode;
            this.visit(statement.getAlternative());
            AstDefinitionUsageAnalysis.this.connect(AstDefinitionUsageAnalysis.this.lastNode, joinNode);
            AstDefinitionUsageAnalysis.this.lastNode = joinNode;
        }

        @Override
        public void visit(SwitchStatement statement) {
            IdentifiedStatement oldDefaultBreakTarget = AstDefinitionUsageAnalysis.this.defaultBreakTarget;
            AstDefinitionUsageAnalysis.this.defaultBreakTarget = statement;
            statement.getValue().acceptVisitor(this);
            int forkNode = AstDefinitionUsageAnalysis.this.createNode();
            int joinNode = AstDefinitionUsageAnalysis.this.createNode();
            AstDefinitionUsageAnalysis.this.connect(AstDefinitionUsageAnalysis.this.lastNode, forkNode);
            for (SwitchClause clause : statement.getClauses()) {
                AstDefinitionUsageAnalysis.this.lastNode = forkNode;
                this.visit(clause.getBody());
                AstDefinitionUsageAnalysis.this.connect(AstDefinitionUsageAnalysis.this.lastNode, joinNode);
            }
            AstDefinitionUsageAnalysis.this.lastNode = forkNode;
            this.visit(statement.getDefaultClause());
            AstDefinitionUsageAnalysis.this.connect(AstDefinitionUsageAnalysis.this.lastNode, joinNode);
            AstDefinitionUsageAnalysis.this.lastNode = joinNode;
            AstDefinitionUsageAnalysis.this.defaultBreakTarget = oldDefaultBreakTarget;
        }

        @Override
        public void visit(WhileStatement statement) {
            IdentifiedStatement oldDefaultBreakTarget = AstDefinitionUsageAnalysis.this.defaultBreakTarget;
            IdentifiedStatement oldDefaultContinueTarget = AstDefinitionUsageAnalysis.this.defaultContinueTarget;
            AstDefinitionUsageAnalysis.this.defaultBreakTarget = statement;
            AstDefinitionUsageAnalysis.this.defaultContinueTarget = statement;
            int continueNode = AstDefinitionUsageAnalysis.this.createNode();
            int forkNode = AstDefinitionUsageAnalysis.this.createNode();
            int breakNode = AstDefinitionUsageAnalysis.this.createNode();
            AstDefinitionUsageAnalysis.this.breakTargets.put((Object)statement, breakNode);
            AstDefinitionUsageAnalysis.this.continueTargets.put((Object)statement, continueNode);
            AstDefinitionUsageAnalysis.this.connect(AstDefinitionUsageAnalysis.this.lastNode, continueNode);
            AstDefinitionUsageAnalysis.this.lastNode = continueNode;
            if (statement.getCondition() != null) {
                statement.getCondition().acceptVisitor(this);
            }
            AstDefinitionUsageAnalysis.this.connect(AstDefinitionUsageAnalysis.this.lastNode, forkNode);
            AstDefinitionUsageAnalysis.this.connect(forkNode, breakNode);
            AstDefinitionUsageAnalysis.this.lastNode = forkNode;
            this.visit(statement.getBody());
            AstDefinitionUsageAnalysis.this.connect(AstDefinitionUsageAnalysis.this.lastNode, continueNode);
            AstDefinitionUsageAnalysis.this.lastNode = breakNode;
            AstDefinitionUsageAnalysis.this.breakTargets.remove((Object)statement);
            AstDefinitionUsageAnalysis.this.continueTargets.remove((Object)statement);
            AstDefinitionUsageAnalysis.this.defaultBreakTarget = oldDefaultBreakTarget;
            AstDefinitionUsageAnalysis.this.defaultContinueTarget = oldDefaultContinueTarget;
        }

        @Override
        public void visit(BlockStatement statement) {
            int breakNode = AstDefinitionUsageAnalysis.this.createNode();
            AstDefinitionUsageAnalysis.this.breakTargets.put((Object)statement, breakNode);
            this.visit(statement.getBody());
            AstDefinitionUsageAnalysis.this.connect(AstDefinitionUsageAnalysis.this.lastNode, breakNode);
            AstDefinitionUsageAnalysis.this.lastNode = breakNode;
            AstDefinitionUsageAnalysis.this.breakTargets.remove((Object)statement);
        }

        @Override
        public void visit(TryCatchStatement statement) {
            int handlerNode = AstDefinitionUsageAnalysis.this.createNode();
            Node handlerNodeData = AstDefinitionUsageAnalysis.this.nodes.get(handlerNode);
            handlerNodeData.catchStatement = statement;
            if (statement.getExceptionVariable() != null) {
                handlerNodeData.exceptionVariable = statement.getExceptionVariable();
            }
            AstDefinitionUsageAnalysis.this.exceptionHandlerStack.push(handlerNode);
            this.visit(statement.getProtectedBody());
            AstDefinitionUsageAnalysis.this.exceptionHandlerStack.pop();
            int node = AstDefinitionUsageAnalysis.this.lastNode;
            AstDefinitionUsageAnalysis.this.lastNode = handlerNode;
            this.visit(statement.getHandler());
            AstDefinitionUsageAnalysis.this.connect(AstDefinitionUsageAnalysis.this.lastNode, node);
            AstDefinitionUsageAnalysis.this.lastNode = node;
        }

        @Override
        public void visit(ReturnStatement statement) {
            super.visit(statement);
            AstDefinitionUsageAnalysis.this.lastNode = -1;
        }

        @Override
        public void visit(ThrowStatement statement) {
            super.visit(statement);
            AstDefinitionUsageAnalysis.this.lastNode = -1;
        }

        @Override
        public void visit(BreakStatement statement) {
            IdentifiedStatement target = statement.getTarget();
            if (target == null) {
                target = AstDefinitionUsageAnalysis.this.defaultBreakTarget;
            }
            AstDefinitionUsageAnalysis.this.connect(AstDefinitionUsageAnalysis.this.lastNode, AstDefinitionUsageAnalysis.this.breakTargets.getOrDefault((Object)target, -1));
            AstDefinitionUsageAnalysis.this.lastNode = -1;
        }

        @Override
        public void visit(ContinueStatement statement) {
            IdentifiedStatement target = statement.getTarget();
            if (target == null) {
                target = AstDefinitionUsageAnalysis.this.defaultContinueTarget;
            }
            AstDefinitionUsageAnalysis.this.connect(AstDefinitionUsageAnalysis.this.lastNode, AstDefinitionUsageAnalysis.this.continueTargets.getOrDefault((Object)target, -1));
            AstDefinitionUsageAnalysis.this.lastNode = -1;
        }

        @Override
        public void visit(AssignmentStatement statement) {
            if (!this.processAssignment(statement)) {
                super.visit(statement);
            }
        }

        private boolean processAssignment(AssignmentStatement statement) {
            if (!(statement.getLeftValue() instanceof VariableExpr)) {
                return false;
            }
            int leftIndex = ((VariableExpr)statement.getLeftValue()).getIndex();
            statement.getRightValue().acceptVisitor(this);
            Definition definition = new Definition(statement, AstDefinitionUsageAnalysis.this.definitions.size(), leftIndex);
            AstDefinitionUsageAnalysis.this.definitions.add(definition);
            AstDefinitionUsageAnalysis.this.definitionIds.put((Object)definition, definition.id);
            if (AstDefinitionUsageAnalysis.this.lastNode >= 0) {
                Node node = AstDefinitionUsageAnalysis.this.nodes.get(AstDefinitionUsageAnalysis.this.lastNode);
                node.definitions.put(definition.variableIndex, definition.id);
                IntArrayList handlerDefinitions = (IntArrayList)node.handlerDefinitions.get(leftIndex);
                if (handlerDefinitions == null) {
                    handlerDefinitions = new IntArrayList();
                    node.handlerDefinitions.put(leftIndex, (Object)handlerDefinitions);
                }
                handlerDefinitions.add(definition.id);
            }
            return true;
        }

        @Override
        public void visit(VariableExpr expr) {
            if (AstDefinitionUsageAnalysis.this.lastNode < 0) {
                return;
            }
            Node node = AstDefinitionUsageAnalysis.this.nodes.get(AstDefinitionUsageAnalysis.this.lastNode);
            int definitionId = node.definitions.getOrDefault(expr.getIndex(), -1);
            if (definitionId >= 0) {
                Definition definition = AstDefinitionUsageAnalysis.this.definitions.get(definitionId);
                definition.usages.add(expr);
            } else if (node.exceptionVariable != expr.getIndex()) {
                int id = AstDefinitionUsageAnalysis.this.usages.size();
                AstDefinitionUsageAnalysis.this.usages.add(expr);
                node.usages.add(id);
                AstDefinitionUsageAnalysis.this.stack.push(id);
                AstDefinitionUsageAnalysis.this.stack.push(AstDefinitionUsageAnalysis.this.lastNode);
                AstDefinitionUsageAnalysis.this.stack.push(0);
            }
        }
    };

    public List<? extends Definition> getDefinitions() {
        return this.readonlyDefinitions;
    }

    public void analyze(Statement statement) {
        this.prepare(statement);
        this.propagate();
        this.cleanup();
    }

    private void prepare(Statement statement) {
        this.lastNode = this.createNode();
        statement.acceptVisitor(this.visitor);
        this.cfg = this.graphBuilder.build();
        this.exceptionGraph = this.exceptionGraphBuilder.build();
        this.graphBuilder = null;
        this.exceptionGraphBuilder = null;
        this.breakTargets = null;
        this.continueTargets = null;
        this.exceptionHandlerStack = null;
    }

    private void connect(int from, int to) {
        if (from >= 0 && to >= 0) {
            this.graphBuilder.addEdge(from, to);
        }
    }

    private int createNode() {
        int id = this.nodes.size();
        this.nodes.add(new Node());
        for (IntCursor cursor : this.exceptionHandlerStack) {
            this.exceptionGraphBuilder.addEdge(id, cursor.value);
        }
        return id;
    }

    private void propagate() {
        while (!this.stack.isEmpty()) {
            int exceptionHandlerId = this.stack.pop();
            int nodeId = this.stack.pop();
            int usageId = this.stack.pop();
            int variableId = this.usages.get(usageId).getIndex();
            Node node = this.nodes.get(nodeId);
            if (exceptionHandlerId < 0) {
                if (!node.usages.add(usageId)) continue;
                int definitionId = node.definitions.getOrDefault(variableId, -1);
                if (definitionId >= 0) {
                    Definition definition = this.definitions.get(definitionId);
                    definition.usages.add(this.usages.get(usageId));
                    continue;
                }
                if (variableId == node.exceptionVariable) {
                    continue;
                }
            } else {
                if (!node.handlerUsages.add(AstDefinitionUsageAnalysis.pack(usageId, exceptionHandlerId))) continue;
                IntArrayList definitionIds = (IntArrayList)node.handlerDefinitions.get(variableId);
                if (definitionIds != null) {
                    TryCatchStatement handlerStatement = this.nodes.get((int)exceptionHandlerId).catchStatement;
                    Expr usage = this.usages.get(usageId);
                    for (IntCursor cursor : definitionIds) {
                        Definition definition = this.definitions.get(cursor.value);
                        definition.usages.add(this.usages.get(usageId));
                        Set<Expr> handlerUsages = definition.exceptionHandlingUsages.get(handlerStatement);
                        if (handlerUsages == null) {
                            handlerUsages = new LinkedHashSet<Expr>();
                            definition.exceptionHandlingUsages.put(handlerStatement, handlerUsages);
                        }
                        handlerUsages.add(usage);
                    }
                }
            }
            if (nodeId < this.cfg.size()) {
                for (int predecessorId : this.cfg.incomingEdges(nodeId)) {
                    if (this.nodes.get((int)predecessorId).usages.contains(usageId)) continue;
                    this.stack.push(usageId);
                    this.stack.push(predecessorId);
                    this.stack.push(-1);
                }
            }
            if (nodeId >= this.exceptionGraph.size()) continue;
            for (int predecessorId : this.exceptionGraph.incomingEdges(nodeId)) {
                if (this.nodes.get((int)predecessorId).handlerUsages.contains((long)usageId)) continue;
                this.stack.push(usageId);
                this.stack.push(predecessorId);
                this.stack.push(nodeId);
            }
        }
    }

    private void cleanup() {
        this.cfg = null;
        this.stack = null;
    }

    private static long pack(int a, int b) {
        return (long)a << 32 | (long)b;
    }

    static class Node {
        IntIntMap definitions = new IntIntHashMap();
        IntObjectMap<IntArrayList> handlerDefinitions = new IntObjectHashMap();
        IntSet usages = new IntHashSet();
        LongSet handlerUsages = new LongHashSet();
        TryCatchStatement catchStatement;
        int exceptionVariable = -1;

        Node() {
        }
    }

    public static class Definition {
        private AssignmentStatement statement;
        private int id;
        private int variableIndex;
        final Set<Expr> usages = new LinkedHashSet<Expr>();
        private Set<? extends Expr> readonlyUsages = Collections.unmodifiableSet(this.usages);
        final Map<TryCatchStatement, Set<Expr>> exceptionHandlingUsages = new LinkedHashMap<TryCatchStatement, Set<Expr>>();
        private Map<? extends TryCatchStatement, Set<? extends Expr>> readonlyExceptionHandlingUsages = Collections.unmodifiableMap(this.exceptionHandlingUsages);

        Definition(AssignmentStatement statement, int id, int variableIndex) {
            this.statement = statement;
            this.id = id;
            this.variableIndex = variableIndex;
        }

        public AssignmentStatement getStatement() {
            return this.statement;
        }

        public int getId() {
            return this.id;
        }

        public int getVariableIndex() {
            return this.variableIndex;
        }

        public Set<? extends Expr> getUsages() {
            return this.readonlyUsages;
        }

        public Map<? extends TryCatchStatement, Set<? extends Expr>> getExceptionHandlingUsages() {
            return this.readonlyExceptionHandlingUsages;
        }
    }
}

