/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import org.teavm.hppc.BitMixer;
import org.teavm.hppc.ByteIntHashMap;
import org.teavm.hppc.HashOrderMixing;

public class ByteIntScatterMap
extends ByteIntHashMap {
    public ByteIntScatterMap() {
        this(4);
    }

    public ByteIntScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ByteIntScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(byte key) {
        return BitMixer.mixPhi(key);
    }

    public static ByteIntScatterMap from(byte[] keys, int[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ByteIntScatterMap map = new ByteIntScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

