/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.transformation;

import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmMemoryAccess;
import org.teavm.backend.wasm.model.expression.WasmReplacingExpressionVisitor;

public class MemoryAccessTraceTransformation {
    private WasmModule module;

    public MemoryAccessTraceTransformation(WasmModule module) {
        this.module = module;
    }

    public void apply() {
        WasmFunction traceFunction = new WasmFunction("traceMemoryAccess");
        traceFunction.setImportModule("debug");
        traceFunction.setImportName("traceMemoryAccess");
        traceFunction.getParameters().add(WasmType.INT32);
        traceFunction.getParameters().add(WasmType.INT32);
        traceFunction.setResult(WasmType.INT32);
        this.module.add(traceFunction);
        int[] positionHolder = new int[]{0};
        WasmReplacingExpressionVisitor visitor = new WasmReplacingExpressionVisitor(expression -> {
            if (expression instanceof WasmMemoryAccess) {
                WasmMemoryAccess memoryAccess = (WasmMemoryAccess)((Object)expression);
                WasmCall call = new WasmCall(traceFunction.getName());
                call.setImported(true);
                int n = positionHolder[0];
                positionHolder[0] = n + 1;
                call.getArguments().add(new WasmInt32Constant(n));
                call.getArguments().add(memoryAccess.getIndex());
                memoryAccess.setIndex(call);
            }
            return expression;
        });
        for (WasmFunction function : this.module.getFunctions().values()) {
            visitor.replace(function);
        }
    }
}

