/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teavm.dependency.AbstractInstructionAnalyzer;
import org.teavm.dependency.DataFlowGraphBuilder;
import org.teavm.dependency.DefaultCallGraphNode;
import org.teavm.dependency.DependencyAnalyzer;
import org.teavm.dependency.DependencyConsumer;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.DependencyType;
import org.teavm.dependency.MethodDependency;
import org.teavm.dependency.VirtualCallConsumer;
import org.teavm.model.BasicBlock;
import org.teavm.model.BasicBlockReader;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.IncomingReader;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.PhiReader;
import org.teavm.model.Program;
import org.teavm.model.TryCatchBlockReader;
import org.teavm.model.ValueType;
import org.teavm.model.VariableReader;
import org.teavm.model.instructions.ArrayElementType;
import org.teavm.model.text.ListingBuilder;

class DependencyGraphBuilder {
    private static final MethodDescriptor GET_CLASS = new MethodDescriptor("getClass", Class.class);
    private DependencyAnalyzer dependencyAnalyzer;
    private DependencyNode[] nodes;
    private DependencyNode resultNode;
    private Program program;
    private DefaultCallGraphNode caller;
    private ExceptionConsumer currentExceptionConsumer;
    private AbstractInstructionAnalyzer reader = new AbstractInstructionAnalyzer(){

        @Override
        public void assign(VariableReader receiver, VariableReader assignee) {
            DependencyNode valueNode = DependencyGraphBuilder.this.nodes[assignee.getIndex()];
            DependencyNode receiverNode = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            if (valueNode != null && receiverNode != null) {
                valueNode.connect(receiverNode);
            }
        }

        @Override
        public void cast(VariableReader receiver, VariableReader value, ValueType targetType) {
            DependencyNode valueNode = DependencyGraphBuilder.this.nodes[value.getIndex()];
            DependencyNode receiverNode = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            ClassReaderSource classSource = DependencyGraphBuilder.this.dependencyAnalyzer.getClassSource();
            if (targetType instanceof ValueType.Object) {
                String targetClsName = ((ValueType.Object)targetType).getClassName();
                ClassReader targetClass = classSource.get(targetClsName);
                if (targetClass != null && !targetClass.getName().equals("java.lang.Object")) {
                    if (valueNode != null && receiverNode != null) {
                        valueNode.connect(receiverNode, DependencyGraphBuilder.this.dependencyAnalyzer.getSuperClassFilter(targetClass.getName()));
                    }
                    return;
                }
            } else if (targetType instanceof ValueType.Array) {
                ClassReader targetClass;
                ValueType itemType = targetType;
                while (itemType instanceof ValueType.Array) {
                    itemType = ((ValueType.Array)itemType).getItemType();
                }
                if (itemType instanceof ValueType.Object && (targetClass = classSource.get(((ValueType.Object)itemType).getClassName())) == null) {
                    valueNode.connect(receiverNode);
                    return;
                }
                if (valueNode != null && receiverNode != null) {
                    valueNode.connect(receiverNode, DependencyGraphBuilder.this.dependencyAnalyzer.getSuperClassFilter(targetType.toString()));
                }
                return;
            }
            if (valueNode != null && receiverNode != null) {
                valueNode.connect(receiverNode);
            }
        }

        @Override
        public void exit(VariableReader valueToReturn) {
            DependencyNode node;
            if (valueToReturn != null && (node = DependencyGraphBuilder.this.nodes[valueToReturn.getIndex()]) != null) {
                node.connect(DependencyGraphBuilder.this.resultNode);
            }
        }

        @Override
        public void raise(VariableReader exception) {
            DependencyGraphBuilder.this.nodes[exception.getIndex()].addConsumer(DependencyGraphBuilder.this.currentExceptionConsumer);
        }

        @Override
        public void unwrapArray(VariableReader receiver, VariableReader array, ArrayElementType elementType) {
            DependencyNode arrayNode = DependencyGraphBuilder.this.nodes[array.getIndex()];
            DependencyNode receiverNode = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            if (arrayNode != null && receiverNode != null) {
                arrayNode.connect(receiverNode);
            }
        }

        @Override
        public void cloneArray(VariableReader receiver, VariableReader array) {
            DependencyNode arrayNode = this.getNode(array);
            DependencyNode receiverNode = this.getNode(receiver);
            if (arrayNode != null && receiverNode != null) {
                arrayNode.addConsumer(receiverNode::propagate);
                arrayNode.getArrayItem().connect(receiverNode.getArrayItem());
            }
            MethodDependency cloneDep = this.getAnalyzer().linkMethod(CLONE_METHOD);
            cloneDep.addLocation(this.getCallLocation());
            arrayNode.connect(cloneDep.getVariable(0));
            cloneDep.use();
        }

        @Override
        public void getElement(VariableReader receiver, VariableReader array, VariableReader index, ArrayElementType type) {
            if (this.isPrimitive(type)) {
                return;
            }
            DependencyNode arrayNode = DependencyGraphBuilder.this.nodes[array.getIndex()];
            DependencyNode receiverNode = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            if (arrayNode != null && receiverNode != null && receiverNode != arrayNode.getArrayItem()) {
                arrayNode.getArrayItem().connect(receiverNode);
            }
        }

        @Override
        public void putElement(VariableReader array, VariableReader index, VariableReader value, ArrayElementType type) {
            if (this.isPrimitive(type)) {
                return;
            }
            DependencyNode valueNode = DependencyGraphBuilder.this.nodes[value.getIndex()];
            DependencyNode arrayNode = DependencyGraphBuilder.this.nodes[array.getIndex()];
            if (valueNode != null && arrayNode != null && valueNode != arrayNode.getArrayItem()) {
                valueNode.connect(arrayNode.getArrayItem());
            }
        }

        private boolean isPrimitive(ArrayElementType type) {
            return type != ArrayElementType.OBJECT;
        }

        @Override
        protected void invokeSpecial(VariableReader receiver, VariableReader instance, MethodReference method, List<? extends VariableReader> arguments) {
            if (method.getDescriptor().equals(GET_CLASS)) {
                this.invokeGetClass(receiver, instance);
                return;
            }
            CallLocation callLocation = this.getCallLocation();
            if (instance == null) {
                DependencyGraphBuilder.this.dependencyAnalyzer.linkClass(method.getClassName()).initClass(callLocation);
            } else {
                DependencyGraphBuilder.this.dependencyAnalyzer.linkClass(method.getClassName());
            }
            MethodDependency methodDep = DependencyGraphBuilder.this.dependencyAnalyzer.linkMethod(method);
            methodDep.addLocation(callLocation);
            methodDep.use(false);
            if (methodDep.isMissing()) {
                return;
            }
            DependencyNode[] targetParams = methodDep.getVariables();
            for (int i = 0; i < arguments.size(); ++i) {
                DependencyNode value = DependencyGraphBuilder.this.nodes[arguments.get(i).getIndex()];
                DependencyNode param = targetParams[i + 1];
                if (value == null || param == null) continue;
                value.connect(param);
            }
            if (instance != null) {
                DependencyGraphBuilder.this.nodes[instance.getIndex()].connect(targetParams[0]);
            }
            if (methodDep.getResult() != null && receiver != null) {
                DependencyNode receiverNode = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
                if (methodDep.getResult() != null && receiverNode != null) {
                    methodDep.getResult().connect(receiverNode);
                }
            }
            methodDep.getThrown().addConsumer(DependencyGraphBuilder.this.currentExceptionConsumer);
            this.initClass(method.getClassName());
        }

        @Override
        protected void invokeVirtual(VariableReader receiver, VariableReader instance, MethodReference method, List<? extends VariableReader> arguments) {
            if (method.getDescriptor().equals(GET_CLASS)) {
                this.invokeGetClass(receiver, instance);
                return;
            }
            DependencyNode[] actualArgs = new DependencyNode[arguments.size() + 1];
            for (int i = 0; i < arguments.size(); ++i) {
                actualArgs[i + 1] = DependencyGraphBuilder.this.nodes[arguments.get(i).getIndex()];
            }
            actualArgs[0] = this.getNode(instance);
            VirtualCallConsumer listener = new VirtualCallConsumer(this.getNode(instance), method.getClassName(), method.getDescriptor(), DependencyGraphBuilder.this.dependencyAnalyzer, actualArgs, receiver != null ? this.getNode(receiver) : null, this.getCallLocation(), DependencyGraphBuilder.this.currentExceptionConsumer);
            this.getNode(instance).addConsumer(listener);
            DependencyGraphBuilder.this.dependencyAnalyzer.getClassSource().overriddenMethods(method).forEach(methodImpl -> DependencyGraphBuilder.this.dependencyAnalyzer.linkMethod(methodImpl.getReference()).addLocation(this.getCallLocation()));
        }

        private void invokeGetClass(VariableReader receiver, VariableReader instance) {
            MethodDependency getClassDep = DependencyGraphBuilder.this.dependencyAnalyzer.linkMethod("java.lang.Object", GET_CLASS);
            getClassDep.addLocation(this.getCallLocation());
            this.getNode(instance).addConsumer(t -> {
                getClassDep.getVariable(0).propagate(t);
                if (receiver != null) {
                    this.getNode(receiver).getClassValueNode().propagate(t);
                }
            });
            if (receiver != null) {
                this.getNode(receiver).propagate(DependencyGraphBuilder.this.dependencyAnalyzer.getType("java.lang.Class"));
            }
            getClassDep.use();
        }

        @Override
        public void nullCheck(VariableReader receiver, VariableReader value) {
            super.nullCheck(receiver, value);
            DependencyGraphBuilder.this.currentExceptionConsumer.consume(DependencyGraphBuilder.this.dependencyAnalyzer.getType("java.lang.NullPointerException"));
        }

        @Override
        protected DependencyNode getNode(VariableReader variable) {
            return DependencyGraphBuilder.this.nodes[variable.getIndex()];
        }

        @Override
        protected DependencyAnalyzer getAnalyzer() {
            return DependencyGraphBuilder.this.dependencyAnalyzer;
        }
    };

    DependencyGraphBuilder(DependencyAnalyzer dependencyAnalyzer) {
        this.dependencyAnalyzer = dependencyAnalyzer;
    }

    public void buildGraph(MethodDependency dep) {
        block17: {
            int i;
            this.caller = this.dependencyAnalyzer.callGraph.getNode(dep.getReference());
            MethodHolder method = dep.method;
            if (method.getProgram() == null || method.getProgram().basicBlockCount() == 0) {
                return;
            }
            this.program = method.getProgram();
            this.resultNode = dep.getResult();
            DataFlowGraphBuilder dfgBuilder = new DataFlowGraphBuilder();
            boolean[] significantParams = new boolean[dep.getParameterCount()];
            significantParams[0] = true;
            for (int i2 = 1; i2 < dep.getParameterCount(); ++i2) {
                ValueType arg = method.parameterType(i2 - 1);
                if (arg instanceof ValueType.Primitive) continue;
                significantParams[i2] = true;
            }
            int[] nodeMapping = dfgBuilder.buildMapping(this.program, significantParams, !(method.getResultType() instanceof ValueType.Primitive) && method.getResultType() != ValueType.VOID);
            if (DependencyAnalyzer.shouldLog) {
                System.out.println("Method reached: " + method.getReference());
                System.out.print(new ListingBuilder().buildListing(this.program, "    "));
                for (int i3 = 0; i3 < nodeMapping.length; ++i3) {
                    System.out.print(i3 + ":" + nodeMapping[i3] + " ");
                }
                System.out.println();
                System.out.println();
            }
            int nodeClassCount = 0;
            for (int i4 = 0; i4 < nodeMapping.length; ++i4) {
                nodeClassCount = Math.max(nodeClassCount, nodeMapping[i4] + 1);
            }
            DependencyNode[] nodeClasses = Arrays.copyOf(dep.getVariables(), nodeClassCount);
            MethodReference ref = method.getReference();
            for (i = dep.getVariableCount(); i < nodeClasses.length; ++i) {
                nodeClasses[i] = this.dependencyAnalyzer.createNode();
                nodeClasses[i].method = ref;
                if (!DependencyAnalyzer.shouldTag) continue;
                nodeClasses[i].setTag(dep.getMethod().getReference() + ":" + i);
            }
            this.nodes = new DependencyNode[dep.getMethod().getProgram().variableCount()];
            for (i = 0; i < this.nodes.length; ++i) {
                int mappedNode = nodeMapping[i];
                this.nodes[i] = mappedNode >= 0 ? nodeClasses[mappedNode] : null;
            }
            dep.setVariables(this.nodes);
            this.reader.setCaller(this.caller.getMethod());
            for (i = 0; i < this.program.basicBlockCount(); ++i) {
                BasicBlock block = this.program.basicBlockAt(i);
                this.currentExceptionConsumer = this.createExceptionConsumer(dep, block);
                block.readAllInstructions(this.reader);
                for (PhiReader phiReader : block.readPhis()) {
                    DependencyNode receiverNode = this.nodes[phiReader.getReceiver().getIndex()];
                    for (IncomingReader incomingReader : phiReader.readIncomings()) {
                        DependencyNode incomingNode = this.nodes[incomingReader.getValue().getIndex()];
                        if (incomingNode == null || receiverNode == null) continue;
                        incomingNode.connect(receiverNode);
                    }
                }
                for (TryCatchBlockReader tryCatchBlockReader : block.readTryCatchBlocks()) {
                    if (tryCatchBlockReader.getExceptionType() == null) continue;
                    this.dependencyAnalyzer.linkClass(tryCatchBlockReader.getExceptionType());
                }
            }
            if (!method.hasModifier(ElementModifier.SYNCHRONIZED)) break block17;
            ArrayList<DependencyNode> syncNodes = new ArrayList<DependencyNode>();
            if (this.dependencyAnalyzer.asyncSupported) {
                MethodDependency methodDep = this.dependencyAnalyzer.linkMethod(AbstractInstructionAnalyzer.MONITOR_ENTER_METHOD);
                syncNodes.add(methodDep.getVariable(1));
                methodDep.use();
            }
            MethodDependency methodDep = this.dependencyAnalyzer.linkMethod(AbstractInstructionAnalyzer.MONITOR_ENTER_SYNC_METHOD);
            syncNodes.add(methodDep.getVariable(1));
            methodDep.use();
            if (this.dependencyAnalyzer.asyncSupported) {
                methodDep = this.dependencyAnalyzer.linkMethod(AbstractInstructionAnalyzer.MONITOR_EXIT_METHOD);
                syncNodes.add(methodDep.getVariable(1));
                methodDep.use();
            }
            methodDep = this.dependencyAnalyzer.linkMethod(AbstractInstructionAnalyzer.MONITOR_EXIT_SYNC_METHOD);
            syncNodes.add(methodDep.getVariable(1));
            methodDep.use();
            if (method.hasModifier(ElementModifier.STATIC)) {
                for (DependencyNode dependencyNode : syncNodes) {
                    dependencyNode.propagate(this.dependencyAnalyzer.getType("java.lang.Class"));
                }
            } else {
                for (DependencyNode dependencyNode : syncNodes) {
                    this.nodes[0].connect(dependencyNode);
                }
            }
        }
    }

    private ExceptionConsumer createExceptionConsumer(MethodDependency methodDep, BasicBlockReader block) {
        List<? extends TryCatchBlockReader> tryCatchBlocks = block.readTryCatchBlocks();
        ClassReader[] exceptions = new ClassReader[tryCatchBlocks.size()];
        DependencyNode[] vars = new DependencyNode[tryCatchBlocks.size()];
        for (int i = 0; i < tryCatchBlocks.size(); ++i) {
            TryCatchBlockReader tryCatch = tryCatchBlocks.get(i);
            if (tryCatch.getExceptionType() != null) {
                exceptions[i] = this.dependencyAnalyzer.getClassSource().get(tryCatch.getExceptionType());
            }
            if (tryCatch.getHandler().getExceptionVariable() == null) continue;
            vars[i] = methodDep.getVariable(tryCatch.getHandler().getExceptionVariable().getIndex());
        }
        return new ExceptionConsumer(this.dependencyAnalyzer, exceptions, vars, methodDep);
    }

    static class ExceptionConsumer
    implements DependencyConsumer {
        private DependencyAnalyzer analyzer;
        private ClassReader[] exceptions;
        private DependencyNode[] vars;
        private MethodDependency method;

        ExceptionConsumer(DependencyAnalyzer analyzer, ClassReader[] exceptions, DependencyNode[] vars, MethodDependency method) {
            this.analyzer = analyzer;
            this.exceptions = exceptions;
            this.vars = vars;
            this.method = method;
        }

        @Override
        public void consume(DependencyType type) {
            ClassHierarchy hierarchy = this.analyzer.getClassHierarchy();
            for (int i = 0; i < this.exceptions.length; ++i) {
                if (this.exceptions[i] != null && !hierarchy.isSuperType(this.exceptions[i].getName(), type.getName(), false)) continue;
                if (this.vars[i] != null) {
                    this.vars[i].propagate(type);
                }
                return;
            }
            this.method.getThrown().propagate(type);
        }
    }
}

