/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.debugging.information;

import org.teavm.common.RecordArray;
import org.teavm.debugging.information.DebugInformation;
import org.teavm.debugging.information.GeneratedLocation;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;

public class ExactMethodIterator {
    private DebugInformation debugInformation;
    private GeneratedLocation location;
    private int classIndex;
    private int methodIndex;
    private int classId = -1;
    private int methodId = -1;

    ExactMethodIterator(DebugInformation debugInformation) {
        this.debugInformation = debugInformation;
        if (!this.isEndReached()) {
            this.read();
        }
    }

    public boolean isEndReached() {
        return this.methodIndex >= this.debugInformation.methodMapping.size() && this.classIndex >= this.debugInformation.classMapping.size();
    }

    private void read() {
        if (this.classIndex < this.debugInformation.classMapping.size() && this.methodIndex < this.debugInformation.methodMapping.size()) {
            GeneratedLocation methodLoc;
            RecordArray.Record classRecord = this.debugInformation.classMapping.get(this.classIndex);
            RecordArray.Record methodRecord = this.debugInformation.methodMapping.get(this.methodIndex);
            GeneratedLocation classLoc = DebugInformation.key(classRecord);
            int cmp = classLoc.compareTo(methodLoc = DebugInformation.key(methodRecord));
            if (cmp < 0) {
                this.nextClassRecord();
            } else if (cmp > 0) {
                this.nextMethodRecord();
            } else {
                this.nextClassRecord();
                this.nextMethodRecord();
            }
        } else if (this.classIndex < this.debugInformation.classMapping.size()) {
            this.nextClassRecord();
        } else if (this.methodIndex < this.debugInformation.methodMapping.size()) {
            this.nextMethodRecord();
        } else {
            throw new IllegalStateException("End already reached");
        }
    }

    private void nextClassRecord() {
        RecordArray.Record record = this.debugInformation.classMapping.get(this.classIndex++);
        this.classId = record.get(2);
        this.location = DebugInformation.key(record);
    }

    private void nextMethodRecord() {
        RecordArray.Record record = this.debugInformation.methodMapping.get(this.methodIndex++);
        this.methodId = record.get(2);
        this.location = DebugInformation.key(record);
    }

    public void next() {
        if (this.isEndReached()) {
            throw new IllegalStateException("End already reached");
        }
        this.read();
    }

    public int getClassNameId() {
        if (this.isEndReached()) {
            throw new IllegalStateException("End already reached");
        }
        return this.classId;
    }

    public String getClassName() {
        int classId = this.getClassNameId();
        return classId >= 0 ? this.debugInformation.getClassName(classId) : null;
    }

    public int getMethodId() {
        if (this.isEndReached()) {
            throw new IllegalStateException("End already reached");
        }
        return this.methodId;
    }

    public MethodDescriptor getMethod() {
        int methodId = this.getMethodId();
        return methodId >= 0 ? this.debugInformation.getMethod(methodId) : null;
    }

    public int getExactMethodId() {
        if (this.classId < 0 || this.methodId < 0) {
            return -1;
        }
        return this.debugInformation.getExactMethodId(this.classId, this.methodId);
    }

    public MethodReference getExactMethod() {
        int methodId = this.getExactMethodId();
        return methodId >= 0 ? this.debugInformation.getExactMethod(this.getExactMethodId()) : null;
    }

    public GeneratedLocation getLocation() {
        return this.location;
    }
}

