/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.teavm.cache.AnnotationIO;
import org.teavm.cache.CachedAnnotations;
import org.teavm.cache.CachedClassReader;
import org.teavm.cache.CachedField;
import org.teavm.cache.CachedMethod;
import org.teavm.cache.ProgramIO;
import org.teavm.cache.SymbolTable;
import org.teavm.cache.VarDataInput;
import org.teavm.cache.VarDataOutput;
import org.teavm.model.AccessLevel;
import org.teavm.model.AnnotationContainerReader;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.ReferenceCache;
import org.teavm.model.ValueType;

public class ClassIO {
    private static AccessLevel[] accessLevels = AccessLevel.values();
    private static ElementModifier[] elementModifiers = ElementModifier.values();
    private ReferenceCache referenceCache;
    private SymbolTable symbolTable;
    private ProgramIO programIO;
    private AnnotationIO annotationIO;

    public ClassIO(ReferenceCache referenceCache, SymbolTable symbolTable, SymbolTable fileTable, SymbolTable varTable) {
        this.referenceCache = referenceCache;
        this.symbolTable = symbolTable;
        this.programIO = new ProgramIO(referenceCache, symbolTable, fileTable, varTable);
        this.annotationIO = new AnnotationIO(referenceCache, symbolTable);
    }

    public void writeClass(OutputStream stream, ClassReader cls) throws IOException {
        VarDataOutput output = new VarDataOutput(stream);
        output.writeUnsigned(cls.getLevel().ordinal());
        output.writeUnsigned(this.packModifiers(cls.readModifiers()));
        output.writeUnsigned(cls.getParent() != null ? this.symbolTable.lookup(cls.getParent()) + 1 : 0);
        output.writeUnsigned(cls.getOwnerName() != null ? this.symbolTable.lookup(cls.getOwnerName()) + 1 : 0);
        output.writeUnsigned(cls.getInterfaces().size());
        for (String string : cls.getInterfaces()) {
            output.writeUnsigned(this.symbolTable.lookup(string));
        }
        this.annotationIO.writeAnnotations(output, cls.getAnnotations());
        output.writeUnsigned(cls.getFields().size());
        for (FieldReader fieldReader : cls.getFields()) {
            this.writeField(output, fieldReader);
        }
        output.writeUnsigned(cls.getMethods().size());
        for (MethodReader methodReader : cls.getMethods()) {
            this.writeMethod(output, methodReader);
        }
    }

    public ClassReader readClass(InputStream stream, String name) throws IOException {
        VarDataInput input = new VarDataInput(stream);
        CachedClassReader cls = new CachedClassReader();
        cls.name = name;
        cls.level = accessLevels[input.readUnsigned()];
        cls.modifiers = this.unpackModifiers(input.readUnsigned());
        int parentIndex = input.readUnsigned();
        cls.parent = parentIndex > 0 ? this.referenceCache.getCached(this.symbolTable.at(parentIndex - 1)) : null;
        int ownerIndex = input.readUnsigned();
        cls.owner = ownerIndex > 0 ? this.referenceCache.getCached(this.symbolTable.at(ownerIndex - 1)) : null;
        int ifaceCount = input.readUnsigned();
        LinkedHashSet<String> interfaces = new LinkedHashSet<String>();
        for (int i = 0; i < ifaceCount; ++i) {
            interfaces.add(this.referenceCache.getCached(this.symbolTable.at(input.readUnsigned())));
        }
        cls.interfaces = Collections.unmodifiableSet(interfaces);
        cls.annotations = this.annotationIO.readAnnotations(input);
        LinkedHashMap<String, CachedField> fields = new LinkedHashMap<String, CachedField>();
        int fieldCount = input.readUnsigned();
        for (int i = 0; i < fieldCount; ++i) {
            CachedField field = this.readField(name, input);
            fields.put(field.name, field);
        }
        cls.fields = fields;
        LinkedHashMap<MethodDescriptor, CachedMethod> methods = new LinkedHashMap<MethodDescriptor, CachedMethod>();
        int methodCount = input.readUnsigned();
        for (int i = 0; i < methodCount; ++i) {
            CachedMethod method = this.readMethod(cls.name, input);
            methods.put(method.reference.getDescriptor(), method);
        }
        cls.methods = methods;
        return cls;
    }

    private void writeField(VarDataOutput output, FieldReader field) throws IOException {
        output.writeUnsigned(this.symbolTable.lookup(field.getName()));
        output.writeUnsigned(this.symbolTable.lookup(field.getType().toString()));
        output.writeUnsigned(field.getLevel().ordinal());
        output.writeUnsigned(this.packModifiers(field.readModifiers()));
        this.writeFieldValue(output, field.getInitialValue());
        this.annotationIO.writeAnnotations(output, field.getAnnotations());
    }

    private CachedField readField(String className, VarDataInput input) throws IOException {
        CachedField field = new CachedField();
        field.name = this.referenceCache.getCached(this.symbolTable.at(input.readUnsigned()));
        field.type = this.referenceCache.getCached(ValueType.parse(this.symbolTable.at(input.readUnsigned())));
        field.level = accessLevels[input.readUnsigned()];
        field.modifiers = this.unpackModifiers(input.readUnsigned());
        field.initialValue = this.readFieldValue(input);
        field.annotations = this.annotationIO.readAnnotations(input);
        field.ownerName = className;
        field.reference = this.referenceCache.getCached(new FieldReference(className, field.name));
        return field;
    }

    private void writeFieldValue(VarDataOutput output, Object value) throws IOException {
        if (value == null) {
            output.writeUnsigned(0);
        } else if (value instanceof Integer) {
            output.writeUnsigned(1);
            output.writeSigned((Integer)value);
        } else if (value instanceof Long) {
            output.writeUnsigned(2);
            output.writeSigned((Long)value);
        } else if (value instanceof Float) {
            output.writeUnsigned(3);
            output.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            output.writeUnsigned(4);
            output.writeDouble((Double)value);
        } else if (value instanceof String) {
            output.writeUnsigned(5);
            output.write((String)value);
        }
    }

    private Object readFieldValue(VarDataInput input) throws IOException {
        int type = input.readUnsigned();
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                return input.readSigned();
            }
            case 2: {
                return input.readSignedLong();
            }
            case 3: {
                return Float.valueOf(input.readFloat());
            }
            case 4: {
                return input.readDouble();
            }
            case 5: {
                return input.read();
            }
        }
        throw new RuntimeException("Unexpected field value type: " + type);
    }

    private void writeMethod(VarDataOutput output, MethodReader method) throws IOException {
        output.writeUnsigned(this.symbolTable.lookup(method.getDescriptor().toString()));
        output.writeUnsigned(method.getLevel().ordinal());
        output.writeUnsigned(this.packModifiers(method.readModifiers()));
        this.annotationIO.writeAnnotations(output, method.getAnnotations());
        for (AnnotationContainerReader parameterAnnotation : method.getParameterAnnotations()) {
            this.annotationIO.writeAnnotations(output, parameterAnnotation);
        }
        if (method.getAnnotationDefault() != null) {
            output.writeUnsigned(1);
            this.annotationIO.writeAnnotationValue(output, method.getAnnotationDefault());
        } else {
            output.writeUnsigned(0);
        }
        if (method.getProgram() != null) {
            output.writeUnsigned(1);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            VarDataOutput programOutput = new VarDataOutput(buffer);
            this.programIO.write(method.getProgram(), programOutput);
            output.writeBytes(buffer.toByteArray());
        } else {
            output.writeUnsigned(0);
        }
    }

    private CachedMethod readMethod(String className, VarDataInput input) throws IOException {
        CachedMethod method = new CachedMethod();
        MethodDescriptor descriptor = this.referenceCache.getCached(MethodDescriptor.parse(this.symbolTable.at(input.readUnsigned())));
        method.reference = this.referenceCache.getCached(className, descriptor);
        method.level = accessLevels[input.readUnsigned()];
        method.modifiers = this.unpackModifiers(input.readUnsigned());
        method.annotations = this.annotationIO.readAnnotations(input);
        method.ownerName = className;
        method.name = descriptor.getName();
        method.parameterAnnotations = new CachedAnnotations[descriptor.parameterCount()];
        for (int i = 0; i < method.parameterCount(); ++i) {
            method.parameterAnnotations[i] = this.annotationIO.readAnnotations(input);
        }
        if (input.readUnsigned() != 0) {
            method.annotationDefault = this.annotationIO.readAnnotationValue(input);
        }
        if (input.readUnsigned() != 0) {
            byte[] programData = input.readBytes();
            method.programSupplier = () -> {
                VarDataInput programInput = new VarDataInput(new ByteArrayInputStream(programData));
                try {
                    return this.programIO.read(programInput);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            };
        }
        return method;
    }

    private int packModifiers(Set<ElementModifier> modifiers) {
        int result = 0;
        for (ElementModifier modifier : modifiers) {
            result |= 1 << modifier.ordinal();
        }
        return result;
    }

    private EnumSet<ElementModifier> unpackModifiers(int packed) {
        EnumSet<ElementModifier> modifiers = EnumSet.noneOf(ElementModifier.class);
        while (packed != 0) {
            int n = Integer.numberOfTrailingZeros(packed);
            packed ^= 1 << n;
            modifiers.add(elementModifiers[n]);
        }
        return modifiers;
    }
}

