/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.rendering;

import java.io.IOException;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.rendering.AstWriter;
import org.teavm.backend.javascript.rendering.RuntimeAstTransformer;
import org.teavm.backend.javascript.rendering.StringConstantElimination;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.rhino.javascript.ast.AstNode;
import org.teavm.rhino.javascript.ast.AstRoot;
import org.teavm.vm.RenderingException;

public class RuntimeRenderer {
    private static final String STRING_CLASS = String.class.getName();
    private static final String THREAD_CLASS = Thread.class.getName();
    private static final MethodReference NPE_INIT_METHOD = new MethodReference(NullPointerException.class, "<init>", Void.TYPE);
    private static final MethodDescriptor STRING_INTERN_METHOD = new MethodDescriptor("intern", String.class);
    private static final MethodDescriptor CURRENT_THREAD_METHOD = new MethodDescriptor("currentThread", Thread.class);
    private static final MethodReference STACK_TRACE_ELEM_INIT = new MethodReference(StackTraceElement.class, "<init>", String.class, String.class, String.class, Integer.TYPE, Void.TYPE);
    private static final MethodReference SET_STACK_TRACE_METHOD = new MethodReference(Throwable.class, "setStackTrace", StackTraceElement[].class, Void.TYPE);
    private final ClassReaderSource classSource;
    private final SourceWriter writer;

    public RuntimeRenderer(ClassReaderSource classSource, SourceWriter writer) {
        this.classSource = classSource;
        this.writer = writer;
    }

    public void renderRuntime() throws RenderingException {
        try {
            this.renderHandWrittenRuntime("runtime.js");
            this.renderSetCloneMethod();
            this.renderRuntimeCls();
            this.renderRuntimeString();
            this.renderRuntimeUnwrapString();
            this.renderRuntimeObjcls();
            this.renderRuntimeNullCheck();
            this.renderRuntimeIntern();
            this.renderRuntimeThreads();
            this.renderRuntimeCreateException();
            this.renderCreateStackTraceElement();
            this.renderSetStackTrace();
        }
        catch (IOException e) {
            throw new RenderingException("IO error", e);
        }
    }

    public void renderHandWrittenRuntime(String name) throws IOException {
        AstRoot ast = this.parseRuntime(name);
        ast.visit(new StringConstantElimination());
        new RuntimeAstTransformer(this.writer.getNaming()).accept(ast);
        AstWriter astWriter = new AstWriter(this.writer);
        astWriter.hoist(ast);
        astWriter.print((AstNode)ast);
    }

    /*
     * Exception decompiling
     */
    private AstRoot parseRuntime(String name) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void renderSetCloneMethod() throws IOException {
        this.writer.append("function $rt_setCloneMethod(target, f)").ws().append("{").softNewLine().indent();
        this.writer.append("target.").appendMethod("clone", Object.class).ws().append('=').ws().append("f;").softNewLine();
        this.writer.outdent().append("}").newLine();
    }

    private void renderRuntimeCls() throws IOException {
        this.writer.append("function $rt_cls(cls)").ws().append("{").softNewLine().indent();
        this.writer.append("return ").appendMethodBody("java.lang.Class", "getClass", ValueType.object("org.teavm.platform.PlatformClass"), ValueType.object("java.lang.Class")).append("(cls);").softNewLine();
        this.writer.outdent().append("}").newLine();
    }

    private void renderRuntimeString() throws IOException {
        MethodReference stringCons = new MethodReference(String.class, "<init>", char[].class, Void.TYPE);
        this.writer.append("function $rt_str(str) {").indent().softNewLine();
        this.writer.append("if (str === null) {").indent().softNewLine();
        this.writer.append("return null;").softNewLine();
        this.writer.outdent().append("}").softNewLine();
        this.writer.append("var characters = $rt_createCharArray(str.length);").softNewLine();
        this.writer.append("var charsBuffer = characters.data;").softNewLine();
        this.writer.append("for (var i = 0; i < str.length; i = (i + 1) | 0) {").indent().softNewLine();
        this.writer.append("charsBuffer[i] = str.charCodeAt(i) & 0xFFFF;").softNewLine();
        this.writer.outdent().append("}").softNewLine();
        this.writer.append("return ").appendInit(stringCons).append("(characters);").softNewLine();
        this.writer.outdent().append("}").newLine();
    }

    private void renderRuntimeUnwrapString() throws IOException {
        FieldReference stringChars = new FieldReference(STRING_CLASS, "characters");
        this.writer.append("function $rt_ustr(str) {").indent().softNewLine();
        this.writer.append("if (str === null) {").indent().softNewLine();
        this.writer.append("return null;").softNewLine();
        this.writer.outdent().append("}").softNewLine();
        this.writer.append("var data = str.").appendField(stringChars).append(".data;").softNewLine();
        this.writer.append("var result = \"\";").softNewLine();
        this.writer.append("for (var i = 0; i < data.length; i = (i + 1) | 0) {").indent().softNewLine();
        this.writer.append("result += String.fromCharCode(data[i]);").softNewLine();
        this.writer.outdent().append("}").softNewLine();
        this.writer.append("return result;").softNewLine();
        this.writer.outdent().append("}").newLine();
    }

    private void renderRuntimeNullCheck() throws IOException {
        this.writer.append("function $rt_nullCheck(val) {").indent().softNewLine();
        this.writer.append("if (val === null) {").indent().softNewLine();
        this.writer.append("$rt_throw(").appendInit(NPE_INIT_METHOD).append("());").softNewLine();
        this.writer.outdent().append("}").softNewLine();
        this.writer.append("return val;").softNewLine();
        this.writer.outdent().append("}").newLine();
    }

    private void renderRuntimeIntern() throws IOException {
        if (!this.needInternMethod()) {
            this.writer.append("function $rt_intern(str) {").indent().softNewLine();
            this.writer.append("return str;").softNewLine();
            this.writer.outdent().append("}").softNewLine();
        } else {
            this.renderHandWrittenRuntime("intern.js");
            this.writer.append("function $rt_stringHash(s)").ws().append("{").indent().softNewLine();
            this.writer.append("return ").appendMethodBody(String.class, "hashCode", Integer.TYPE).append("(s);").softNewLine();
            this.writer.outdent().append("}").softNewLine();
            this.writer.append("function $rt_stringEquals(a,").ws().append("b)").ws().append("{").indent().softNewLine();
            this.writer.append("return ").appendMethodBody(String.class, "equals", Object.class, Boolean.TYPE).append("(a").ws().append(",b);").softNewLine();
            this.writer.outdent().append("}").softNewLine();
        }
    }

    private boolean needInternMethod() {
        ClassReader cls = this.classSource.get(STRING_CLASS);
        if (cls == null) {
            return false;
        }
        MethodReader method = cls.getMethod(STRING_INTERN_METHOD);
        return method != null && method.getProgram() != null;
    }

    private void renderRuntimeObjcls() throws IOException {
        this.writer.append("function $rt_objcls() { return ").appendClass("java.lang.Object").append("; }").newLine();
    }

    private void renderRuntimeThreads() throws IOException {
        ClassReader threadCls = this.classSource.get(THREAD_CLASS);
        MethodReader currentThreadMethod = threadCls != null ? threadCls.getMethod(CURRENT_THREAD_METHOD) : null;
        boolean threadUsed = currentThreadMethod != null && currentThreadMethod.getProgram() != null;
        this.writer.append("function $rt_getThread()").ws().append("{").indent().softNewLine();
        if (threadUsed) {
            this.writer.append("return ").appendMethodBody(Thread.class, "currentThread", Thread.class).append("();").softNewLine();
        } else {
            this.writer.append("return null;").softNewLine();
        }
        this.writer.outdent().append("}").newLine();
        this.writer.append("function $rt_setThread(t)").ws().append("{").indent().softNewLine();
        if (threadUsed) {
            this.writer.append("return ").appendMethodBody(Thread.class, "setCurrentThread", Thread.class, Void.TYPE).append("(t);").softNewLine();
        }
        this.writer.outdent().append("}").newLine();
    }

    private void renderRuntimeCreateException() throws IOException {
        this.writer.append("function $rt_createException(message)").ws().append("{").indent().softNewLine();
        this.writer.append("return ");
        this.writer.appendInit(new MethodReference(RuntimeException.class, "<init>", String.class, Void.TYPE));
        this.writer.append("(message);").softNewLine();
        this.writer.outdent().append("}").newLine();
    }

    private void renderCreateStackTraceElement() throws IOException {
        ClassReader cls = this.classSource.get(STACK_TRACE_ELEM_INIT.getClassName());
        MethodReader stackTraceElemInit = cls != null ? cls.getMethod(STACK_TRACE_ELEM_INIT.getDescriptor()) : null;
        boolean supported = stackTraceElemInit != null && stackTraceElemInit.getProgram() != null;
        this.writer.append("function $rt_createStackElement(").append("className,").ws().append("methodName,").ws().append("fileName,").ws().append("lineNumber)").ws().append("{").indent().softNewLine();
        this.writer.append("return ");
        if (supported) {
            this.writer.appendInit(STACK_TRACE_ELEM_INIT);
            this.writer.append("(className,").ws().append("methodName,").ws().append("fileName,").ws().append("lineNumber)");
        } else {
            this.writer.append("null");
        }
        this.writer.append(";").softNewLine();
        this.writer.outdent().append("}").newLine();
    }

    private void renderSetStackTrace() throws IOException {
        ClassReader cls = this.classSource.get(SET_STACK_TRACE_METHOD.getClassName());
        MethodReader setStackTrace = cls != null ? cls.getMethod(SET_STACK_TRACE_METHOD.getDescriptor()) : null;
        boolean supported = setStackTrace != null && setStackTrace.getProgram() != null;
        this.writer.append("function $rt_setStack(e,").ws().append("stack)").ws().append("{").indent().softNewLine();
        if (supported) {
            this.writer.appendMethodBody(SET_STACK_TRACE_METHOD);
            this.writer.append("(e,").ws().append("stack);").softNewLine();
        }
        this.writer.outdent().append("}").newLine();
    }
}

