/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.runtime;

import org.teavm.interop.Address;
import org.teavm.interop.Export;
import org.teavm.interop.StaticInit;
import org.teavm.interop.Unmanaged;
import org.teavm.runtime.CallSite;
import org.teavm.runtime.CallSiteLocation;
import org.teavm.runtime.Console;
import org.teavm.runtime.ExceptionHandler;
import org.teavm.runtime.MethodLocation;
import org.teavm.runtime.RuntimeClass;
import org.teavm.runtime.RuntimeObject;
import org.teavm.runtime.ShadowStack;

@StaticInit
public final class ExceptionHandling {
    private static Throwable thrownException;

    private ExceptionHandling() {
    }

    @Unmanaged
    public static native CallSite findCallSiteById(int var0, Address var1);

    @Unmanaged
    public static native boolean isJumpSupported();

    @Unmanaged
    public static native void jumpToFrame(Address var0, int var1);

    @Unmanaged
    public static native void abort();

    @Unmanaged
    public static void printStack() {
        Address stackFrame = ShadowStack.getStackTop();
        while (stackFrame != null) {
            int callSiteId = ShadowStack.getCallSiteId(stackFrame);
            CallSite callSite = ExceptionHandling.findCallSiteById(callSiteId, stackFrame);
            CallSiteLocation location = callSite.location;
            MethodLocation methodLocation = location != null ? location.method : null;
            Console.printString("    at ");
            if (methodLocation.className == null || methodLocation.methodName == null) {
                Console.printString("(Unknown method)");
            } else {
                Console.printString(methodLocation.className.value);
                Console.printString(".");
                Console.printString(methodLocation.methodName.value);
            }
            Console.printString("(");
            if (methodLocation.fileName != null && location.lineNumber >= 0) {
                Console.printString(methodLocation.fileName.value);
                Console.printString(":");
                Console.printInt(location.lineNumber);
            }
            Console.printString(")\n");
            stackFrame = ShadowStack.getNextStackFrame(stackFrame);
        }
    }

    @Export(name="teavm_catchException")
    @Unmanaged
    public static Throwable catchException() {
        Throwable exception = thrownException;
        thrownException = null;
        return exception;
    }

    @Unmanaged
    public static void throwException(Throwable exception) {
        thrownException = exception;
        RuntimeObject exceptionPtr = (RuntimeObject)Address.ofObject((Object)exception).toStructure();
        RuntimeClass exceptionClass = RuntimeClass.getClass(exceptionPtr);
        Address stackFrame = ShadowStack.getStackTop();
        int handlerId = 0;
        block0: while (stackFrame != null) {
            int callSiteId = ShadowStack.getCallSiteId(stackFrame);
            CallSite callSite = ExceptionHandling.findCallSiteById(callSiteId, stackFrame);
            ExceptionHandler handler = callSite.firstHandler;
            while (handler != null) {
                if (handler.exceptionClass == null || handler.exceptionClass.isSupertypeOf.apply(exceptionClass)) {
                    handlerId = handler.id;
                    ShadowStack.setExceptionHandlerId(stackFrame, handler.id);
                    break block0;
                }
                handler = handler.next;
            }
            ShadowStack.setExceptionHandlerId(stackFrame, callSiteId - 1);
            stackFrame = ShadowStack.getNextStackFrame(stackFrame);
        }
        if (stackFrame == null) {
            ExceptionHandling.printStack();
            ExceptionHandling.abort();
        } else if (ExceptionHandling.isJumpSupported()) {
            ExceptionHandling.jumpToFrame(stackFrame, handlerId);
        }
    }

    @Unmanaged
    public static void throwClassCastException() {
        throw new ClassCastException();
    }

    @Unmanaged
    @Export(name="teavm_throwNullPointerException")
    public static void throwNullPointerException() {
        throw new NullPointerException();
    }

    @Unmanaged
    public static int callStackSize() {
        Address stackFrame = ShadowStack.getStackTop();
        int size = 0;
        while (stackFrame != null) {
            stackFrame = ShadowStack.getNextStackFrame(stackFrame);
            ++size;
        }
        return size + 1;
    }

    public static void fillStackTrace(StackTraceElement[] target) {
        Address stackFrame = ShadowStack.getStackTop();
        int index = 0;
        while (stackFrame != null && index < target.length) {
            int callSiteId = ShadowStack.getCallSiteId(stackFrame);
            CallSite callSite = ExceptionHandling.findCallSiteById(callSiteId, stackFrame);
            CallSiteLocation location = callSite.location;
            MethodLocation methodLocation = location != null ? location.method : null;
            StackTraceElement element = ExceptionHandling.createElement(methodLocation != null && methodLocation.className != null ? methodLocation.className.value : "", methodLocation != null && methodLocation.methodName != null ? methodLocation.methodName.value : "", methodLocation != null && methodLocation.fileName != null ? methodLocation.fileName.value : null, location != null ? location.lineNumber : -1);
            target[index++] = element;
            stackFrame = ShadowStack.getNextStackFrame(stackFrame);
        }
    }

    private static StackTraceElement createElement(String className, String methodName, String fileName, int lineNumber) {
        return new StackTraceElement(className, methodName, fileName, lineNumber);
    }
}

