/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.runtime;

import java.util.Arrays;
import org.teavm.backend.c.intrinsic.RuntimeInclude;
import org.teavm.interop.Import;
import org.teavm.interop.StaticInit;

@StaticInit
public final class EventQueue {
    private static Node[] data = new Node[16];
    private static int size;
    private static boolean finished;
    private static int idGenerator;

    private EventQueue() {
    }

    public static int offer(Event action) {
        return EventQueue.offer(action, System.currentTimeMillis());
    }

    public static int offer(Event action, long time) {
        EventQueue.ensureCapacity(size + 1);
        int current = size;
        while (current > 0) {
            int parent = (current - 1) / 2;
            if (time >= EventQueue.data[parent].time) break;
            EventQueue.data[current] = data[parent];
            current = parent;
        }
        int id = idGenerator++;
        EventQueue.data[current] = new Node(id, action, time);
        ++size;
        if (current == 0) {
            EventQueue.interrupt();
        }
        return id;
    }

    public static void kill(int id) {
        for (int i = 0; i < size; ++i) {
            if (EventQueue.data[i].id != id) continue;
            EventQueue.remove(i);
            break;
        }
    }

    public static void process() {
        while (size > 0 && !finished) {
            EventQueue.next();
        }
    }

    public static void stop() {
        finished = true;
    }

    private static void next() {
        while (data.length == 0) {
            EventQueue.waitUntil(System.currentTimeMillis() + 1000L);
        }
        Node node = data[0];
        EventQueue.waitUntil(node.time);
        if (node.time <= System.currentTimeMillis()) {
            EventQueue.remove(0);
            node.event.run();
        }
    }

    private static void remove(int index) {
        if (index < --size) {
            EventQueue.data[index] = data[size];
            EventQueue.update(index);
        }
        EventQueue.data[EventQueue.size] = null;
    }

    private static void update(int index) {
        Node item = data[index];
        while (true) {
            int left = index * 2 + 1;
            int right = left + 1;
            if (left >= size) break;
            int next = right >= size || EventQueue.data[left].time < EventQueue.data[right].time ? left : right;
            if (item.time <= EventQueue.data[next].time) break;
            EventQueue.data[index] = data[next];
            index = next;
        }
        EventQueue.data[index] = item;
    }

    private static void waitUntil(long time) {
        long diff = time - System.currentTimeMillis();
        if (diff <= 0L) {
            return;
        }
        EventQueue.waitFor(diff);
    }

    @Import(name="teavm_waitFor")
    @RuntimeInclude(value="fiber.h")
    private static native void waitFor(long var0);

    @Import(name="teavm_interrupt")
    @RuntimeInclude(value="fiber.h")
    private static native void interrupt();

    private static void ensureCapacity(int capacity) {
        if (data.length >= capacity) {
            return;
        }
        capacity = Math.max(capacity, data.length * 3 / 2);
        data = Arrays.copyOf(data, capacity);
    }

    public static interface Event {
        public void run();
    }

    static class Node {
        final int id;
        final Event event;
        final long time;

        Node(int id, Event event, long time) {
            this.id = id;
            this.event = event;
            this.time = time;
        }
    }
}

