/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.lowlevel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.teavm.common.DominatorTree;
import org.teavm.common.Graph;
import org.teavm.common.GraphUtils;
import org.teavm.hppc.IntHashSet;
import org.teavm.hppc.IntObjectHashMap;
import org.teavm.hppc.IntSet;
import org.teavm.model.BasicBlock;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.MethodReference;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.TextLocation;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.BinaryBranchingCondition;
import org.teavm.model.instructions.BinaryBranchingInstruction;
import org.teavm.model.instructions.CloneArrayInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ConstructMultiArrayInstruction;
import org.teavm.model.instructions.DoubleConstantInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.FloatConstantInstruction;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.instructions.LongConstantInstruction;
import org.teavm.model.instructions.MonitorEnterInstruction;
import org.teavm.model.instructions.MonitorExitInstruction;
import org.teavm.model.instructions.NullCheckInstruction;
import org.teavm.model.instructions.NullConstantInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.instructions.SwitchInstruction;
import org.teavm.model.instructions.SwitchTableEntry;
import org.teavm.model.lowlevel.CallSiteDescriptor;
import org.teavm.model.lowlevel.CallSiteLocation;
import org.teavm.model.lowlevel.Characteristics;
import org.teavm.model.lowlevel.ExceptionHandlerDescriptor;
import org.teavm.model.util.DefinitionExtractor;
import org.teavm.model.util.ProgramUtils;
import org.teavm.runtime.ExceptionHandling;
import org.teavm.runtime.ShadowStack;

public class ExceptionHandlingShadowStackContributor {
    private Characteristics characteristics;
    private List<CallSiteDescriptor> callSites;
    private BasicBlock defaultExceptionHandler;
    private MethodReference method;
    private Program program;
    private DominatorTree dom;
    private BasicBlock[] variableDefinitionPlaces;
    private boolean hasExceptionHandlers;
    private int parameterCount;

    public ExceptionHandlingShadowStackContributor(Characteristics characteristics, List<CallSiteDescriptor> callSites, MethodReference method, Program program) {
        this.characteristics = characteristics;
        this.callSites = callSites;
        this.method = method;
        this.program = program;
        Graph cfg = ProgramUtils.buildControlFlowGraph(program);
        this.dom = GraphUtils.buildDominatorTree(cfg);
        this.variableDefinitionPlaces = ProgramUtils.getVariableDefinitionPlaces(program);
        this.parameterCount = method.parameterCount() + 1;
    }

    public boolean contribute() {
        int[] blockMapping = new int[this.program.basicBlockCount()];
        for (int i = 0; i < blockMapping.length; ++i) {
            blockMapping[i] = i;
        }
        ArrayList<Phi> allPhis = new ArrayList<Phi>();
        int blockCount = this.program.basicBlockCount();
        for (int i = 0; i < blockCount; ++i) {
            allPhis.addAll(this.program.basicBlockAt(i).getPhis());
        }
        HashSet<BasicBlock> exceptionHandlers = new HashSet<BasicBlock>();
        for (int i = 0; i < blockCount; ++i) {
            int newIndex;
            BasicBlock block = this.program.basicBlockAt(i);
            for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                exceptionHandlers.add(tryCatch.getHandler());
            }
            if (block.getExceptionVariable() != null) {
                InvokeInstruction catchCall = new InvokeInstruction();
                catchCall.setType(InvocationType.SPECIAL);
                catchCall.setMethod(new MethodReference(ExceptionHandling.class, "catchException", Throwable.class));
                catchCall.setReceiver(block.getExceptionVariable());
                block.addFirst(catchCall);
                block.setExceptionVariable(null);
            }
            if ((newIndex = this.contributeToBasicBlock(block)) == i) continue;
            blockMapping[i] = newIndex;
            this.hasExceptionHandlers = true;
        }
        for (Phi phi : allPhis) {
            if (exceptionHandlers.contains(phi.getBasicBlock())) continue;
            for (Incoming incoming : phi.getIncomings()) {
                int mappedSource = blockMapping[incoming.getSource().getIndex()];
                incoming.setSource(this.program.basicBlockAt(mappedSource));
            }
        }
        return this.hasExceptionHandlers;
    }

    private int contributeToBasicBlock(BasicBlock block) {
        int[] currentJointSources = new int[this.program.variableCount()];
        IntObjectHashMap<int[]> jointReceiverMaps = new IntObjectHashMap<int[]>();
        Arrays.fill(currentJointSources, -1);
        IntHashSet variablesDefinedHere = new IntHashSet();
        for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
            int[] jointReceiverMap = new int[this.program.variableCount()];
            Arrays.fill(jointReceiverMap, -1);
            for (Phi phi : tryCatch.getHandler().getPhis()) {
                List sourceVariables = phi.getIncomings().stream().filter(incoming -> incoming.getSource() == tryCatch.getProtectedBlock()).map(incoming -> incoming.getValue()).collect(Collectors.toList());
                if (sourceVariables.isEmpty()) continue;
                for (Variable sourceVar : sourceVariables) {
                    BasicBlock sourceVarDefinedAt = this.variableDefinitionPlaces[sourceVar.getIndex()];
                    if (sourceVar.getIndex() >= this.parameterCount && (!this.dom.dominates(sourceVarDefinedAt.getIndex(), block.getIndex()) || block == sourceVarDefinedAt)) continue;
                    currentJointSources[phi.getReceiver().getIndex()] = sourceVar.getIndex();
                    if (sourceVarDefinedAt == block) continue;
                    break;
                }
                for (Variable sourceVar : sourceVariables) {
                    jointReceiverMap[sourceVar.getIndex()] = phi.getReceiver().getIndex();
                }
            }
            jointReceiverMaps.put(tryCatch.getHandler().getIndex(), jointReceiverMap);
        }
        for (Phi phi : block.getPhis()) {
            Variable definedVar = phi.getReceiver();
            for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                int jointReceiver = ((int[])jointReceiverMaps.get(tryCatch.getHandler().getIndex()))[definedVar.getIndex()];
                if (jointReceiver < 0) continue;
                currentJointSources[jointReceiver] = definedVar.getIndex();
            }
            variablesDefinedHere.add(definedVar.getIndex());
        }
        DefinitionExtractor defExtractor = new DefinitionExtractor();
        ArrayList<BasicBlock> blocksToClearHandlers = new ArrayList<BasicBlock>();
        blocksToClearHandlers.add(block);
        BasicBlock initialBlock = block;
        for (Instruction insn : block) {
            int lineNumber;
            BasicBlock next;
            insn.acceptVisitor(defExtractor);
            for (Variable definedVar : defExtractor.getDefinedVariables()) {
                for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                    int jointReceiver = ((int[])jointReceiverMaps.get(tryCatch.getHandler().getIndex()))[definedVar.getIndex()];
                    if (jointReceiver < 0) continue;
                    currentJointSources[jointReceiver] = definedVar.getIndex();
                }
                variablesDefinedHere.add(definedVar.getIndex());
            }
            if (!this.isCallInstruction(insn)) continue;
            boolean last = false;
            if (this.isSpecialCallInstruction(insn)) {
                next = null;
                while (insn.getNext() != null) {
                    Instruction nextInsn = insn.getNext();
                    nextInsn.delete();
                }
                last = true;
            } else if (insn instanceof RaiseInstruction) {
                InvokeInstruction raise = new InvokeInstruction();
                raise.setMethod(new MethodReference(ExceptionHandling.class, "throwException", Throwable.class, Void.TYPE));
                raise.setType(InvocationType.SPECIAL);
                raise.setArguments(((RaiseInstruction)insn).getException());
                raise.setLocation(insn.getLocation());
                insn.replace(raise);
                insn = raise;
                next = null;
            } else if (insn.getNext() != null && insn.getNext() instanceof JumpInstruction) {
                next = ((JumpInstruction)insn.getNext()).getTarget();
                insn.getNext().delete();
                last = true;
            } else {
                next = this.program.createBasicBlock();
                next.getTryCatchBlocks().addAll(ProgramUtils.copyTryCatches(block, this.program));
                blocksToClearHandlers.add(next);
                while (insn.getNext() != null) {
                    Instruction nextInsn = insn.getNext();
                    nextInsn.delete();
                    next.add(nextInsn);
                }
            }
            String fileName = insn.getLocation() != null ? insn.getLocation().getFileName() : null;
            int n = lineNumber = insn.getLocation() != null ? insn.getLocation().getLine() : -1;
            if (fileName != null) {
                fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
            }
            CallSiteLocation location = new CallSiteLocation(fileName, this.method.getClassName(), this.method.getName(), lineNumber);
            CallSiteDescriptor callSite = new CallSiteDescriptor(this.callSites.size(), location);
            this.callSites.add(callSite);
            List<Instruction> pre = this.setLocation(this.getInstructionsBeforeCallSite(callSite), insn.getLocation());
            List<Instruction> post = this.getInstructionsAfterCallSite(initialBlock, block, next, callSite, currentJointSources, variablesDefinedHere);
            post = this.setLocation(post, insn.getLocation());
            block.getLastInstruction().insertPreviousAll(pre);
            block.addAll(post);
            this.hasExceptionHandlers = true;
            if (next == null || last) break;
            block = next;
            variablesDefinedHere.clear();
        }
        this.fixOutgoingPhis(initialBlock, block, currentJointSources, variablesDefinedHere);
        for (BasicBlock blockToClear : blocksToClearHandlers) {
            blockToClear.getTryCatchBlocks().clear();
        }
        return block.getIndex();
    }

    private boolean isCallInstruction(Instruction insn) {
        return ExceptionHandlingShadowStackContributor.isCallInstruction(this.characteristics, insn);
    }

    public static boolean isCallInstruction(Characteristics characteristics, Instruction insn) {
        if (insn instanceof InitClassInstruction || insn instanceof ConstructInstruction || insn instanceof ConstructArrayInstruction || insn instanceof ConstructMultiArrayInstruction || insn instanceof CloneArrayInstruction || insn instanceof RaiseInstruction || insn instanceof MonitorEnterInstruction || insn instanceof MonitorExitInstruction || insn instanceof NullCheckInstruction) {
            return true;
        }
        if (insn instanceof InvokeInstruction) {
            return ExceptionHandlingShadowStackContributor.isManagedMethodCall(characteristics, ((InvokeInstruction)insn).getMethod());
        }
        return false;
    }

    public static boolean isManagedMethodCall(Characteristics characteristics, MethodReference method) {
        if (characteristics.isManaged(method)) {
            return true;
        }
        return method.getClassName().equals(ExceptionHandling.class.getName()) && method.getName().startsWith("throw");
    }

    private boolean isSpecialCallInstruction(Instruction insn) {
        if (!(insn instanceof InvokeInstruction)) {
            return false;
        }
        MethodReference method = ((InvokeInstruction)insn).getMethod();
        return method.getClassName().equals(ExceptionHandling.class.getName()) && method.getName().startsWith("throw");
    }

    private List<Instruction> setLocation(List<Instruction> instructions, TextLocation location) {
        if (location != null) {
            for (Instruction instruction : instructions) {
                instruction.setLocation(location);
            }
        }
        return instructions;
    }

    private List<Instruction> getInstructionsBeforeCallSite(CallSiteDescriptor callSite) {
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        Variable idVariable = this.program.createVariable();
        IntegerConstantInstruction idInsn = new IntegerConstantInstruction();
        idInsn.setConstant(callSite.getId());
        idInsn.setReceiver(idVariable);
        instructions.add(idInsn);
        InvokeInstruction registerInsn = new InvokeInstruction();
        registerInsn.setMethod(new MethodReference(ShadowStack.class, "registerCallSite", Integer.TYPE, Void.TYPE));
        registerInsn.setType(InvocationType.SPECIAL);
        registerInsn.setArguments(idVariable);
        instructions.add(registerInsn);
        return instructions;
    }

    private List<Instruction> getInstructionsAfterCallSite(BasicBlock initialBlock, BasicBlock block, BasicBlock next, CallSiteDescriptor callSite, int[] currentJointSources, IntSet variablesDefinedHere) {
        Program program = block.getProgram();
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        Variable handlerIdVariable = program.createVariable();
        InvokeInstruction getHandlerIdInsn = new InvokeInstruction();
        getHandlerIdInsn.setMethod(new MethodReference(ShadowStack.class, "getExceptionHandlerId", Integer.TYPE));
        getHandlerIdInsn.setType(InvocationType.SPECIAL);
        getHandlerIdInsn.setReceiver(handlerIdVariable);
        instructions.add(getHandlerIdInsn);
        SwitchInstruction switchInsn = new SwitchInstruction();
        switchInsn.setCondition(handlerIdVariable);
        if (next != null) {
            SwitchTableEntry continueExecutionEntry = new SwitchTableEntry();
            continueExecutionEntry.setCondition(callSite.getId());
            continueExecutionEntry.setTarget(next);
            switchInsn.getEntries().add(continueExecutionEntry);
        }
        boolean defaultExists = false;
        int nextHandlerId = callSite.getId();
        for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
            ExceptionHandlerDescriptor handler = new ExceptionHandlerDescriptor(++nextHandlerId, tryCatch.getExceptionType());
            callSite.getHandlers().add(handler);
            if (tryCatch.getExceptionType() == null) {
                defaultExists = true;
                switchInsn.setDefaultTarget(tryCatch.getHandler());
                continue;
            }
            SwitchTableEntry catchEntry = new SwitchTableEntry();
            catchEntry.setTarget(tryCatch.getHandler());
            catchEntry.setCondition(handler.getId());
            switchInsn.getEntries().add(catchEntry);
        }
        this.fixOutgoingPhis(initialBlock, block, currentJointSources, variablesDefinedHere);
        if (!defaultExists) {
            switchInsn.setDefaultTarget(this.getDefaultExceptionHandler());
        }
        if (switchInsn.getEntries().isEmpty()) {
            instructions.clear();
            JumpInstruction jump = new JumpInstruction();
            jump.setTarget(switchInsn.getDefaultTarget());
            instructions.add(jump);
        } else if (switchInsn.getEntries().size() == 1) {
            SwitchTableEntry entry = switchInsn.getEntries().get(0);
            IntegerConstantInstruction singleTestConstant = new IntegerConstantInstruction();
            singleTestConstant.setConstant(entry.getCondition());
            singleTestConstant.setReceiver(program.createVariable());
            instructions.add(singleTestConstant);
            BinaryBranchingInstruction branching = new BinaryBranchingInstruction(BinaryBranchingCondition.EQUAL);
            branching.setConsequent(entry.getTarget());
            branching.setAlternative(switchInsn.getDefaultTarget());
            branching.setFirstOperand(switchInsn.getCondition());
            branching.setSecondOperand(singleTestConstant.getReceiver());
            instructions.add(branching);
        } else {
            instructions.add(switchInsn);
        }
        return instructions;
    }

    private void fixOutgoingPhis(BasicBlock block, BasicBlock newBlock, int[] currentJointSources, IntSet variablesDefinedHere) {
        for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
            for (Phi phi : tryCatch.getHandler().getPhis()) {
                int value = currentJointSources[phi.getReceiver().getIndex()];
                if (value < 0) continue;
                ArrayList<Incoming> additionalIncomings = new ArrayList<Incoming>();
                for (int i = 0; i < phi.getIncomings().size(); ++i) {
                    Incoming incoming = phi.getIncomings().get(i);
                    if (incoming.getSource() != block || incoming.getSource() == newBlock || incoming.getValue().getIndex() != value) continue;
                    if (variablesDefinedHere.contains(value)) {
                        incoming.setSource(newBlock);
                        continue;
                    }
                    Incoming incomingCopy = new Incoming();
                    incomingCopy.setSource(newBlock);
                    incomingCopy.setValue(incoming.getValue());
                    additionalIncomings.add(incomingCopy);
                }
                phi.getIncomings().addAll(additionalIncomings);
            }
        }
    }

    private BasicBlock getDefaultExceptionHandler() {
        if (this.defaultExceptionHandler == null) {
            this.defaultExceptionHandler = this.program.createBasicBlock();
            Variable result = this.createReturnValueInstructions(this.defaultExceptionHandler);
            ExitInstruction exit = new ExitInstruction();
            exit.setValueToReturn(result);
            this.defaultExceptionHandler.add(exit);
        }
        return this.defaultExceptionHandler;
    }

    private Variable createReturnValueInstructions(BasicBlock block) {
        ValueType returnType = this.method.getReturnType();
        if (returnType == ValueType.VOID) {
            return null;
        }
        Variable variable = this.program.createVariable();
        if (returnType instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)returnType).getKind()) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case CHARACTER: 
                case INTEGER: {
                    IntegerConstantInstruction intConstant = new IntegerConstantInstruction();
                    intConstant.setReceiver(variable);
                    block.add(intConstant);
                    return variable;
                }
                case LONG: {
                    LongConstantInstruction longConstant = new LongConstantInstruction();
                    longConstant.setReceiver(variable);
                    block.add(longConstant);
                    return variable;
                }
                case FLOAT: {
                    FloatConstantInstruction floatConstant = new FloatConstantInstruction();
                    floatConstant.setReceiver(variable);
                    block.add(floatConstant);
                    return variable;
                }
                case DOUBLE: {
                    DoubleConstantInstruction doubleConstant = new DoubleConstantInstruction();
                    doubleConstant.setReceiver(variable);
                    block.add(doubleConstant);
                    return variable;
                }
            }
        }
        NullConstantInstruction nullConstant = new NullConstantInstruction();
        nullConstant.setReceiver(variable);
        block.add(nullConstant);
        return variable;
    }
}

