/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.debugging.information;

import org.teavm.common.RecordArray;
import org.teavm.debugging.information.DebugInformation;
import org.teavm.debugging.information.GeneratedLocation;

public class SourceLocationIterator {
    private DebugInformation debugInformation;
    private int lineIndex;
    private int fileIndex;
    private GeneratedLocation location;
    private int fileId = -1;
    private int line = -1;
    private boolean endReached;

    SourceLocationIterator(DebugInformation debugInformation) {
        this.debugInformation = debugInformation;
        if (!this.isEndReached()) {
            this.read();
        }
    }

    public boolean isEndReached() {
        return this.endReached;
    }

    private void read() {
        if (this.fileIndex < this.debugInformation.fileMapping.size() && this.lineIndex < this.debugInformation.lineMapping.size()) {
            GeneratedLocation lineLoc;
            RecordArray.Record fileRecord = this.debugInformation.fileMapping.get(this.fileIndex);
            RecordArray.Record lineRecord = this.debugInformation.lineMapping.get(this.lineIndex);
            GeneratedLocation fileLoc = DebugInformation.key(fileRecord);
            int cmp = fileLoc.compareTo(lineLoc = DebugInformation.key(lineRecord));
            if (cmp < 0) {
                this.nextFileRecord();
            } else if (cmp > 0) {
                this.nextLineRecord();
            } else {
                this.nextFileRecord();
                this.nextLineRecord();
            }
        } else if (this.fileIndex < this.debugInformation.fileMapping.size()) {
            this.nextFileRecord();
        } else if (this.lineIndex < this.debugInformation.lineMapping.size()) {
            this.nextLineRecord();
        } else {
            if (this.endReached) {
                throw new IllegalStateException("End already reached");
            }
            this.endReached = true;
        }
    }

    private void nextFileRecord() {
        RecordArray.Record record = this.debugInformation.fileMapping.get(this.fileIndex++);
        this.location = DebugInformation.key(record);
        this.fileId = record.get(2);
    }

    private void nextLineRecord() {
        RecordArray.Record record = this.debugInformation.lineMapping.get(this.lineIndex++);
        this.location = DebugInformation.key(record);
        this.line = record.get(2);
    }

    public void next() {
        if (this.isEndReached()) {
            throw new IllegalStateException("End already reached");
        }
        this.read();
    }

    public GeneratedLocation getLocation() {
        if (this.isEndReached()) {
            throw new IllegalStateException("End already reached");
        }
        return this.location;
    }

    public int getFileNameId() {
        if (this.isEndReached()) {
            throw new IllegalStateException("End already reached");
        }
        return this.fileId;
    }

    public String getFileName() {
        int fileId = this.getFileNameId();
        return fileId >= 0 ? this.debugInformation.getFileName(fileId) : null;
    }

    public int getLine() {
        if (this.isEndReached()) {
            throw new IllegalStateException("End already reached");
        }
        return this.line;
    }
}

