/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.debugging.information;

import org.teavm.debugging.information.DebugInformation;
import org.teavm.debugging.information.GeneratedLocation;

public class LineNumberIterator {
    private DebugInformation debugInformation;
    private int index;

    LineNumberIterator(DebugInformation debugInformation) {
        this.debugInformation = debugInformation;
    }

    public boolean isEndReached() {
        return this.index < this.debugInformation.lineMapping.size();
    }

    public GeneratedLocation getLocation() {
        if (this.isEndReached()) {
            throw new IllegalStateException("End already reached");
        }
        return DebugInformation.key(this.debugInformation.lineMapping.get(this.index));
    }

    public int getLineNumber() {
        if (this.isEndReached()) {
            throw new IllegalStateException("End already reached");
        }
        return this.debugInformation.lineMapping.get(this.index).get(2);
    }

    public void next() {
        if (this.isEndReached()) {
            throw new IllegalStateException("End already reached");
        }
        ++this.index;
    }
}

