/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public class Promise<T> {
    public static final Promise<Void> VOID = Promise.of(null);
    private T value;
    private Promise<T> promise;
    private Throwable error;
    private State state = State.PENDING;
    private List<Then<T>> thenList;
    private List<Catch> catchList;

    Promise() {
    }

    public static <T> Promise<T> of(T value) {
        Promise<T> promise = new Promise<T>();
        promise.complete(value);
        return promise;
    }

    public static Promise<?> error(Throwable e) {
        Promise promise = new Promise();
        promise.completeWithError(e);
        return promise;
    }

    public static Promise<Void> allVoid(Collection<Promise<Void>> promises) {
        if (promises.isEmpty()) {
            return VOID;
        }
        AllVoidFunction all = new AllVoidFunction(promises.size());
        for (Promise<Void> promise : promises) {
            promise.then(all.thenF).catchError(all.catchF);
        }
        return all.result;
    }

    public static <T> Promise<List<T>> all(Collection<Promise<T>> promises) {
        if (promises.isEmpty()) {
            return Promise.of(Collections.emptyList());
        }
        AllFunction all = new AllFunction(promises.size());
        int i = 0;
        for (Promise promise : promises) {
            promise.then(all.thenF(i++)).catchError(all.catchF);
        }
        return all.result;
    }

    public <S> Promise<S> then(Function<? super T, S> f) {
        Promise<T> result = new Promise<T>();
        if (this.state == State.PENDING || this.state == State.WAITING_PROMISE) {
            if (this.thenList == null) {
                this.thenList = new ArrayList<Then<T>>();
                this.thenList.add(new Then<T>(f, result, false));
            }
        } else {
            this.passValue(f, result);
        }
        return result;
    }

    public Promise<Void> thenVoid(Consumer<T> f) {
        return this.then(r -> {
            f.accept(r);
            return null;
        });
    }

    public <S> Promise<S> thenAsync(Function<T, Promise<S>> f) {
        Promise<T> result = new Promise<T>();
        if (this.state == State.PENDING || this.state == State.WAITING_PROMISE) {
            if (this.thenList == null) {
                this.thenList = new ArrayList<Then<T>>();
                this.thenList.add(new Then<T>(f, result, true));
            }
        } else if (this.state == State.COMPLETED) {
            this.passValueAsync(f, result);
        }
        return result;
    }

    public <S> Promise<S> catchError(Function<Throwable, S> f) {
        Promise<T> result = new Promise<T>();
        if (this.state == State.PENDING || this.state == State.WAITING_PROMISE) {
            if (this.catchList == null) {
                this.catchList = new ArrayList<Catch>();
                this.catchList.add(new Catch(f, result));
            }
        } else if (this.state == State.ERRORED) {
            this.passError(f, result);
        }
        return result;
    }

    public Promise<Void> catchVoid(Consumer<Throwable> f) {
        return this.catchError(e -> {
            f.accept((Throwable)e);
            return null;
        });
    }

    <S> void passValue(Function<? super T, S> f, Promise<? super S> target) {
        if (this.state == State.COMPLETED) {
            S next;
            try {
                next = f.apply(this.value);
            }
            catch (Throwable e) {
                target.completeWithError(e);
                return;
            }
            target.complete(next);
        } else {
            target.completeWithError(this.error);
        }
    }

    <S> void passValueAsync(Function<T, Promise<S>> f, Promise<S> target) {
        if (this.state == State.COMPLETED) {
            target.completeAsync(f.apply(this.value));
        } else {
            target.completeWithError(this.error);
        }
    }

    <S> void passError(Function<Throwable, S> f, Promise<? super S> target) {
        S next;
        try {
            next = f.apply(this.error);
        }
        catch (Throwable e) {
            target.completeWithError(e);
            return;
        }
        target.complete(next);
    }

    void complete(T value) {
        if (this.state != State.PENDING) {
            throw new IllegalStateException("Already completed");
        }
        this.completeImpl(value);
    }

    void completeAsync(Promise<T> value) {
        if (this.state != State.PENDING) {
            throw new IllegalStateException("Already completed");
        }
        this.state = State.WAITING_PROMISE;
        value.then(result -> {
            this.completeImpl(result);
            return null;
        }).catchError(e -> {
            this.completeWithErrorImpl((Throwable)e);
            return null;
        });
    }

    private void completeImpl(T value) {
        this.state = State.COMPLETED;
        this.value = value;
        if (this.thenList != null) {
            List<Then<T>> list = this.thenList;
            this.thenList = null;
            for (Then<T> then : list) {
                if (then.promise) {
                    this.passValueAsync(then.f, then.target);
                    continue;
                }
                this.passValue(then.f, then.target);
            }
        }
        this.catchList = null;
    }

    void completeWithError(Throwable e) {
        if (this.state != State.PENDING) {
            throw new IllegalStateException("Already completed");
        }
        this.completeWithErrorImpl(e);
    }

    void completeWithErrorImpl(Throwable e) {
        this.state = State.ERRORED;
        this.error = e;
        if (this.catchList != null) {
            List<Catch> list = this.catchList;
            this.thenList = null;
            for (Catch c : list) {
                this.passError(c.f, c.target);
            }
        } else {
            e.printStackTrace();
        }
        this.thenList = null;
    }

    static class Catch {
        Function<Throwable, ?> f;
        Promise<?> target;

        Catch(Function<Throwable, ?> f, Promise<?> target) {
            this.f = f;
            this.target = target;
        }
    }

    static class Then<T> {
        Function<? super T, ?> f;
        Promise<?> target;
        boolean promise;

        Then(Function<? super T, ?> f, Promise<?> target, boolean promise) {
            this.f = f;
            this.target = target;
            this.promise = promise;
        }
    }

    static enum State {
        PENDING,
        WAITING_PROMISE,
        COMPLETED,
        ERRORED;

    }

    static class AllFunction<T> {
        Promise<List<T>> result = new Promise();
        List<T> list = new ArrayList<T>();
        int count;
        boolean error;
        Function<Throwable, Void> catchF = e -> {
            if (!this.error) {
                this.error = true;
                this.result.completeWithError((Throwable)e);
            }
            return null;
        };

        AllFunction(int count) {
            this.result = this.result;
            this.count = count;
            this.list.addAll(Collections.nCopies(count, null));
        }

        Function<T, Void> thenF(int index) {
            return v -> {
                if (!this.error) {
                    this.list.set(index, v);
                    if (--this.count == 0) {
                        this.result.complete(this.list);
                    }
                }
                return null;
            };
        }
    }

    static class AllVoidFunction {
        Promise<Void> result = new Promise();
        int count;
        boolean error;
        Function<Object, Void> thenF = v -> {
            if (!this.error && --this.count == 0) {
                this.result.complete(null);
            }
            return null;
        };
        Function<Throwable, Void> catchF = e -> {
            if (!this.error) {
                this.error = true;
                this.result.completeWithError((Throwable)e);
            }
            return null;
        };

        AllVoidFunction(int count) {
            this.result = this.result;
            this.count = count;
        }
    }
}

