/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.render;

import org.teavm.backend.wasm.generate.WasmGenerationContext;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmBreak;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmConditional;
import org.teavm.backend.wasm.model.expression.WasmConversion;
import org.teavm.backend.wasm.model.expression.WasmDrop;
import org.teavm.backend.wasm.model.expression.WasmExpressionVisitor;
import org.teavm.backend.wasm.model.expression.WasmFloat32Constant;
import org.teavm.backend.wasm.model.expression.WasmFloat64Constant;
import org.teavm.backend.wasm.model.expression.WasmFloatBinary;
import org.teavm.backend.wasm.model.expression.WasmFloatType;
import org.teavm.backend.wasm.model.expression.WasmFloatUnary;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmIndirectCall;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt64Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmIntUnary;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat32;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat64;
import org.teavm.backend.wasm.model.expression.WasmLoadInt32;
import org.teavm.backend.wasm.model.expression.WasmLoadInt64;
import org.teavm.backend.wasm.model.expression.WasmReturn;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat32;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat64;
import org.teavm.backend.wasm.model.expression.WasmStoreInt32;
import org.teavm.backend.wasm.model.expression.WasmStoreInt64;
import org.teavm.backend.wasm.model.expression.WasmSwitch;
import org.teavm.backend.wasm.model.expression.WasmUnreachable;

public class WasmTypeInference
implements WasmExpressionVisitor {
    private WasmGenerationContext context;
    private WasmType result;

    public WasmTypeInference(WasmGenerationContext context) {
        this.context = context;
    }

    public WasmType getResult() {
        return this.result;
    }

    @Override
    public void visit(WasmBlock expression) {
        this.result = expression.getType();
    }

    @Override
    public void visit(WasmBranch expression) {
        this.result = null;
    }

    @Override
    public void visit(WasmBreak expression) {
        this.result = null;
    }

    @Override
    public void visit(WasmSwitch expression) {
        this.result = null;
    }

    @Override
    public void visit(WasmConditional expression) {
        this.result = expression.getType();
    }

    @Override
    public void visit(WasmReturn expression) {
        this.result = null;
    }

    @Override
    public void visit(WasmUnreachable expression) {
        this.result = null;
    }

    @Override
    public void visit(WasmInt32Constant expression) {
        this.result = WasmType.INT32;
    }

    @Override
    public void visit(WasmInt64Constant expression) {
        this.result = WasmType.INT64;
    }

    @Override
    public void visit(WasmFloat32Constant expression) {
        this.result = WasmType.FLOAT32;
    }

    @Override
    public void visit(WasmFloat64Constant expression) {
        this.result = WasmType.FLOAT64;
    }

    @Override
    public void visit(WasmGetLocal expression) {
        this.result = expression.getLocal().getType();
    }

    @Override
    public void visit(WasmSetLocal expression) {
        this.result = null;
    }

    @Override
    public void visit(WasmIntBinary expression) {
        this.result = WasmTypeInference.map(expression.getType());
    }

    @Override
    public void visit(WasmFloatBinary expression) {
        this.result = WasmTypeInference.map(expression.getType());
    }

    @Override
    public void visit(WasmIntUnary expression) {
        this.result = WasmTypeInference.map(expression.getType());
    }

    @Override
    public void visit(WasmFloatUnary expression) {
        this.result = WasmTypeInference.map(expression.getType());
    }

    @Override
    public void visit(WasmConversion expression) {
        this.result = expression.getTargetType();
    }

    @Override
    public void visit(WasmCall expression) {
        WasmFunction function = this.context.getFunction(expression.getFunctionName());
        this.result = function == null ? null : function.getResult();
    }

    @Override
    public void visit(WasmIndirectCall expression) {
        this.result = expression.getReturnType();
    }

    @Override
    public void visit(WasmDrop expression) {
        this.result = null;
    }

    @Override
    public void visit(WasmLoadInt32 expression) {
        this.result = WasmType.INT32;
    }

    @Override
    public void visit(WasmLoadInt64 expression) {
        this.result = WasmType.INT64;
    }

    @Override
    public void visit(WasmLoadFloat32 expression) {
        this.result = WasmType.FLOAT32;
    }

    @Override
    public void visit(WasmLoadFloat64 expression) {
        this.result = WasmType.FLOAT64;
    }

    @Override
    public void visit(WasmStoreInt32 expression) {
        this.result = null;
    }

    @Override
    public void visit(WasmStoreInt64 expression) {
        this.result = null;
    }

    @Override
    public void visit(WasmStoreFloat32 expression) {
        this.result = null;
    }

    @Override
    public void visit(WasmStoreFloat64 expression) {
        this.result = null;
    }

    private static WasmType map(WasmIntType type) {
        switch (type) {
            case INT32: {
                return WasmType.INT32;
            }
            case INT64: {
                return WasmType.INT64;
            }
        }
        throw new IllegalArgumentException(type.toString());
    }

    private static WasmType map(WasmFloatType type) {
        switch (type) {
            case FLOAT32: {
                return WasmType.FLOAT32;
            }
            case FLOAT64: {
                return WasmType.FLOAT64;
            }
        }
        throw new IllegalArgumentException(type.toString());
    }
}

