/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.generate.WasmClassGenerator;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt32Subtype;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmLoadInt32;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReference;
import org.teavm.runtime.RuntimeObject;

public class PlatformObjectIntrinsic
implements WasmIntrinsic {
    private static final String PLATFORM_OBJECT = "org.teavm.platform.PlatformObject";
    private static final FieldReference classField = new FieldReference(RuntimeObject.class.getName(), "classReference");
    private WasmClassGenerator classGenerator;

    public PlatformObjectIntrinsic(WasmClassGenerator classGenerator) {
        this.classGenerator = classGenerator;
    }

    @Override
    public boolean isApplicable(MethodReference methodReference) {
        return methodReference.getClassName().equals(PLATFORM_OBJECT);
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        switch (invocation.getMethod().getName()) {
            case "getPlatformClass": {
                int offset = this.classGenerator.getFieldOffset(classField);
                WasmExpression object = manager.generate(invocation.getArguments().get(0));
                if (offset > 0) {
                    object = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, object, new WasmInt32Constant(offset));
                }
                WasmLoadInt32 classPtr = new WasmLoadInt32(4, object, WasmInt32Subtype.INT32);
                return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, classPtr, new WasmInt32Constant(3));
            }
        }
        throw new IllegalArgumentException(invocation.getMethod().toString());
    }
}

