/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.teavm.dependency.DependencyInfo;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.BasicBlock;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHolder;
import org.teavm.model.FieldReference;
import org.teavm.model.Instruction;
import org.teavm.model.InvokeDynamicInstruction;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.TextLocation;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.ArrayLengthInstruction;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.BinaryBranchingInstruction;
import org.teavm.model.instructions.BinaryInstruction;
import org.teavm.model.instructions.BranchingInstruction;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.CastIntegerInstruction;
import org.teavm.model.instructions.CastNumberInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.CloneArrayInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ConstructMultiArrayInstruction;
import org.teavm.model.instructions.DoubleConstantInstruction;
import org.teavm.model.instructions.EmptyInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.FloatConstantInstruction;
import org.teavm.model.instructions.GetElementInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.InstructionVisitor;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.IsInstanceInstruction;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.instructions.LongConstantInstruction;
import org.teavm.model.instructions.MonitorEnterInstruction;
import org.teavm.model.instructions.MonitorExitInstruction;
import org.teavm.model.instructions.NegateInstruction;
import org.teavm.model.instructions.NullCheckInstruction;
import org.teavm.model.instructions.NullConstantInstruction;
import org.teavm.model.instructions.PutElementInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.instructions.SwitchInstruction;
import org.teavm.model.instructions.UnwrapArrayInstruction;
import org.teavm.model.optimization.UnreachableBasicBlockEliminator;
import org.teavm.model.util.InstructionTransitionExtractor;

public class MissingItemsProcessor {
    private DependencyInfo dependencyInfo;
    private Diagnostics diagnostics;
    private List<Instruction> instructionsToAdd = new ArrayList<Instruction>();
    private MethodHolder methodHolder;
    private Program program;
    private Collection<String> achievableClasses;
    private Collection<MethodReference> achievableMethods;
    private Collection<FieldReference> achievableFields;
    private InstructionVisitor instructionProcessor = new InstructionVisitor(){

        @Override
        public void visit(NullCheckInstruction insn) {
        }

        @Override
        public void visit(InitClassInstruction insn) {
            MissingItemsProcessor.this.checkClass(insn.getLocation(), insn.getClassName());
        }

        @Override
        public void visit(IsInstanceInstruction insn) {
            MissingItemsProcessor.this.checkClass(insn.getLocation(), insn.getType());
        }

        @Override
        public void visit(InvokeInstruction insn) {
            MissingItemsProcessor.this.checkMethod(insn.getLocation(), insn.getMethod());
        }

        @Override
        public void visit(InvokeDynamicInstruction insn) {
        }

        @Override
        public void visit(PutElementInstruction insn) {
        }

        @Override
        public void visit(GetElementInstruction insn) {
        }

        @Override
        public void visit(UnwrapArrayInstruction insn) {
        }

        @Override
        public void visit(CloneArrayInstruction insn) {
        }

        @Override
        public void visit(ArrayLengthInstruction insn) {
        }

        @Override
        public void visit(PutFieldInstruction insn) {
            MissingItemsProcessor.this.checkField(insn.getLocation(), insn.getField());
        }

        @Override
        public void visit(GetFieldInstruction insn) {
            MissingItemsProcessor.this.checkField(insn.getLocation(), insn.getField());
        }

        @Override
        public void visit(ConstructMultiArrayInstruction insn) {
            MissingItemsProcessor.this.checkClass(insn.getLocation(), insn.getItemType());
        }

        @Override
        public void visit(ConstructInstruction insn) {
            MissingItemsProcessor.this.checkClass(insn.getLocation(), insn.getType());
        }

        @Override
        public void visit(ConstructArrayInstruction insn) {
            MissingItemsProcessor.this.checkClass(insn.getLocation(), insn.getItemType());
        }

        @Override
        public void visit(RaiseInstruction insn) {
        }

        @Override
        public void visit(ExitInstruction insn) {
        }

        @Override
        public void visit(SwitchInstruction insn) {
        }

        @Override
        public void visit(JumpInstruction insn) {
        }

        @Override
        public void visit(BinaryBranchingInstruction insn) {
        }

        @Override
        public void visit(BranchingInstruction insn) {
        }

        @Override
        public void visit(CastIntegerInstruction insn) {
        }

        @Override
        public void visit(CastNumberInstruction insn) {
        }

        @Override
        public void visit(CastInstruction insn) {
            MissingItemsProcessor.this.checkClass(insn.getLocation(), insn.getTargetType());
        }

        @Override
        public void visit(AssignInstruction insn) {
        }

        @Override
        public void visit(NegateInstruction insn) {
        }

        @Override
        public void visit(BinaryInstruction insn) {
        }

        @Override
        public void visit(StringConstantInstruction insn) {
        }

        @Override
        public void visit(DoubleConstantInstruction insn) {
        }

        @Override
        public void visit(FloatConstantInstruction insn) {
        }

        @Override
        public void visit(LongConstantInstruction insn) {
        }

        @Override
        public void visit(IntegerConstantInstruction insn) {
        }

        @Override
        public void visit(NullConstantInstruction insn) {
        }

        @Override
        public void visit(ClassConstantInstruction insn) {
            MissingItemsProcessor.this.checkClass(insn.getLocation(), insn.getConstant());
        }

        @Override
        public void visit(EmptyInstruction insn) {
        }

        @Override
        public void visit(MonitorEnterInstruction insn) {
        }

        @Override
        public void visit(MonitorExitInstruction insn) {
        }
    };

    public MissingItemsProcessor(DependencyInfo dependencyInfo, Diagnostics diagnostics) {
        this.dependencyInfo = dependencyInfo;
        this.diagnostics = diagnostics;
        this.achievableClasses = dependencyInfo.getReachableClasses();
        this.achievableMethods = dependencyInfo.getReachableMethods();
        this.achievableFields = dependencyInfo.getReachableFields();
    }

    public void processClass(ClassHolder cls) {
        for (MethodHolder method : cls.getMethods()) {
            if (!this.achievableMethods.contains(method.getReference()) || method.getProgram() == null) continue;
            this.processMethod(method);
        }
    }

    public void processMethod(MethodHolder method) {
        this.methodHolder = method;
        this.program = method.getProgram();
        boolean wasModified = false;
        for (int i = 0; i < this.program.basicBlockCount(); ++i) {
            BasicBlock block = this.program.basicBlockAt(i);
            this.instructionsToAdd.clear();
            boolean missing = false;
            for (Instruction insn : block) {
                insn.acceptVisitor(this.instructionProcessor);
                if (this.instructionsToAdd.isEmpty()) continue;
                wasModified = true;
                this.truncateBlock(insn);
                missing = true;
                break;
            }
            if (missing) continue;
            for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                this.checkClass(null, tryCatch.getExceptionType());
            }
        }
        if (wasModified) {
            new UnreachableBasicBlockEliminator().optimize(this.program);
        }
    }

    private void truncateBlock(Instruction instruction) {
        InstructionTransitionExtractor transitionExtractor = new InstructionTransitionExtractor();
        BasicBlock block = instruction.getBasicBlock();
        if (block.getLastInstruction() != null) {
            block.getLastInstruction().acceptVisitor(transitionExtractor);
        }
        for (BasicBlock successor : transitionExtractor.getTargets()) {
            successor.removeIncomingsFrom(block);
        }
        while (instruction.getNext() != null) {
            instruction.getNext().delete();
        }
        instruction.insertNextAll(this.instructionsToAdd);
    }

    private void emitExceptionThrow(TextLocation location, String exceptionName, String text) {
        Variable exceptionVar = this.program.createVariable();
        ConstructInstruction newExceptionInsn = new ConstructInstruction();
        newExceptionInsn.setType(exceptionName);
        newExceptionInsn.setReceiver(exceptionVar);
        newExceptionInsn.setLocation(location);
        this.instructionsToAdd.add(newExceptionInsn);
        Variable constVar = this.program.createVariable();
        StringConstantInstruction constInsn = new StringConstantInstruction();
        constInsn.setConstant(text);
        constInsn.setReceiver(constVar);
        constInsn.setLocation(location);
        this.instructionsToAdd.add(constInsn);
        InvokeInstruction initExceptionInsn = new InvokeInstruction();
        initExceptionInsn.setInstance(exceptionVar);
        initExceptionInsn.setMethod(new MethodReference(exceptionName, "<init>", ValueType.object("java.lang.String"), ValueType.VOID));
        initExceptionInsn.setType(InvocationType.SPECIAL);
        initExceptionInsn.getArguments().add(constVar);
        initExceptionInsn.setLocation(location);
        this.instructionsToAdd.add(initExceptionInsn);
        RaiseInstruction raiseInsn = new RaiseInstruction();
        raiseInsn.setException(exceptionVar);
        raiseInsn.setLocation(location);
        this.instructionsToAdd.add(raiseInsn);
    }

    private boolean checkClass(TextLocation location, String className) {
        if (!this.achievableClasses.contains(className) || !this.dependencyInfo.getClass(className).isMissing()) {
            return true;
        }
        this.diagnostics.error(new CallLocation(this.methodHolder.getReference(), location), "Class {{c0}} was not found", className);
        this.emitExceptionThrow(location, NoClassDefFoundError.class.getName(), "Class not found: " + className);
        return false;
    }

    private boolean checkClass(TextLocation location, ValueType type) {
        while (type instanceof ValueType.Array) {
            type = ((ValueType.Array)type).getItemType();
        }
        if (type instanceof ValueType.Object) {
            return this.checkClass(location, ((ValueType.Object)type).getClassName());
        }
        return true;
    }

    private boolean checkMethod(TextLocation location, MethodReference method) {
        if (!this.checkClass(location, method.getClassName())) {
            return false;
        }
        if (!this.achievableMethods.contains(method) || !this.dependencyInfo.getMethod(method).isMissing()) {
            return true;
        }
        this.diagnostics.error(new CallLocation(this.methodHolder.getReference(), location), "Method {{m0}} was not found", method);
        this.emitExceptionThrow(location, NoSuchMethodError.class.getName(), "Method not found: " + method);
        return true;
    }

    private boolean checkField(TextLocation location, FieldReference field) {
        if (!this.checkClass(location, field.getClassName())) {
            return false;
        }
        if (!this.achievableFields.contains(field) || !this.dependencyInfo.getField(field).isMissing()) {
            return true;
        }
        this.diagnostics.error(new CallLocation(this.methodHolder.getReference(), location), "Field {{f0}} was not found", field);
        this.emitExceptionThrow(location, NoSuchFieldError.class.getName(), "Field not found: " + field);
        return true;
    }
}

