/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import org.teavm.common.DominatorTree;
import org.teavm.common.Graph;
import org.teavm.common.GraphUtils;
import org.teavm.model.BasicBlock;
import org.teavm.model.Program;
import org.teavm.model.util.DominatorWalkerCallback;
import org.teavm.model.util.ProgramUtils;

public class DominatorWalker {
    private Program program;
    private DominatorTree dom;
    private Graph domGraph;

    public DominatorWalker(Program program) {
        this.program = program;
        Graph cfg = ProgramUtils.buildControlFlowGraph(program);
        this.dom = GraphUtils.buildDominatorTree(cfg);
        this.domGraph = GraphUtils.buildDominatorGraph(this.dom, cfg.size());
    }

    public <T> void walk(DominatorWalkerCallback<T> callback) {
        int[] stack = new int[this.program.basicBlockCount() * 2];
        Object[] stateStack = new Object[stack.length];
        boolean[] backward = new boolean[stack.length];
        callback.setDomTree(this.dom);
        int head = 1;
        while (head > 0) {
            int node = stack[--head];
            BasicBlock block = this.program.basicBlockAt(node);
            if (backward[head]) {
                Object state = stateStack[head];
                callback.endVisit(block, state);
                continue;
            }
            if (!callback.filter(block)) continue;
            stack[head] = node;
            backward[head] = true;
            stateStack[head] = callback.visit(block);
            ++head;
            int[] successors = this.domGraph.outgoingEdges(node);
            for (int i = successors.length - 1; i >= 0; --i) {
                stack[head] = successors[i];
                backward[head] = false;
                ++head;
            }
        }
    }
}

