/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.optimization;

import org.teavm.model.InvokeDynamicInstruction;
import org.teavm.model.analysis.NullnessInformation;
import org.teavm.model.instructions.ArrayLengthInstruction;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.BinaryBranchingInstruction;
import org.teavm.model.instructions.BinaryInstruction;
import org.teavm.model.instructions.BinaryOperation;
import org.teavm.model.instructions.BranchingInstruction;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.CastIntegerInstruction;
import org.teavm.model.instructions.CastNumberInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.CloneArrayInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ConstructMultiArrayInstruction;
import org.teavm.model.instructions.DoubleConstantInstruction;
import org.teavm.model.instructions.EmptyInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.FloatConstantInstruction;
import org.teavm.model.instructions.GetElementInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.InstructionVisitor;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.IsInstanceInstruction;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.instructions.LongConstantInstruction;
import org.teavm.model.instructions.MonitorEnterInstruction;
import org.teavm.model.instructions.MonitorExitInstruction;
import org.teavm.model.instructions.NegateInstruction;
import org.teavm.model.instructions.NullCheckInstruction;
import org.teavm.model.instructions.NullConstantInstruction;
import org.teavm.model.instructions.NumericOperandType;
import org.teavm.model.instructions.PutElementInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.instructions.SwitchInstruction;
import org.teavm.model.instructions.UnwrapArrayInstruction;

public class LoopInvariantAnalyzer
implements InstructionVisitor {
    private NullnessInformation nullness;
    public boolean canMove;
    public boolean constant;
    public boolean sideEffect;

    public LoopInvariantAnalyzer(NullnessInformation nullness) {
        this.nullness = nullness;
    }

    public void reset() {
        this.canMove = false;
        this.constant = false;
        this.sideEffect = false;
    }

    @Override
    public void visit(EmptyInstruction insn) {
    }

    @Override
    public void visit(ClassConstantInstruction insn) {
        this.constant = true;
    }

    @Override
    public void visit(NullConstantInstruction insn) {
        this.constant = true;
    }

    @Override
    public void visit(IntegerConstantInstruction insn) {
        this.constant = true;
    }

    @Override
    public void visit(LongConstantInstruction insn) {
        this.constant = true;
    }

    @Override
    public void visit(FloatConstantInstruction insn) {
        this.constant = true;
    }

    @Override
    public void visit(DoubleConstantInstruction insn) {
        this.constant = true;
    }

    @Override
    public void visit(StringConstantInstruction insn) {
        this.constant = true;
    }

    @Override
    public void visit(BinaryInstruction insn) {
        this.canMove = true;
        if (insn.getOperation() == BinaryOperation.DIVIDE) {
            this.sideEffect = insn.getOperandType() == NumericOperandType.INT || insn.getOperandType() == NumericOperandType.LONG;
        }
    }

    @Override
    public void visit(NegateInstruction insn) {
        this.canMove = true;
    }

    @Override
    public void visit(AssignInstruction insn) {
        this.canMove = true;
    }

    @Override
    public void visit(CastInstruction insn) {
        this.canMove = true;
    }

    @Override
    public void visit(CastNumberInstruction insn) {
        this.canMove = true;
    }

    @Override
    public void visit(CastIntegerInstruction insn) {
        this.canMove = true;
    }

    @Override
    public void visit(BranchingInstruction insn) {
    }

    @Override
    public void visit(BinaryBranchingInstruction insn) {
    }

    @Override
    public void visit(JumpInstruction insn) {
    }

    @Override
    public void visit(SwitchInstruction insn) {
    }

    @Override
    public void visit(ExitInstruction insn) {
    }

    @Override
    public void visit(RaiseInstruction insn) {
    }

    @Override
    public void visit(ConstructArrayInstruction insn) {
    }

    @Override
    public void visit(ConstructInstruction insn) {
    }

    @Override
    public void visit(ConstructMultiArrayInstruction insn) {
    }

    @Override
    public void visit(GetFieldInstruction insn) {
    }

    @Override
    public void visit(PutFieldInstruction insn) {
    }

    @Override
    public void visit(ArrayLengthInstruction insn) {
        this.canMove = true;
        if (!this.nullness.isNotNull(insn.getArray())) {
            this.sideEffect = true;
        }
    }

    @Override
    public void visit(CloneArrayInstruction insn) {
    }

    @Override
    public void visit(UnwrapArrayInstruction insn) {
        this.canMove = true;
        if (!this.nullness.isNotNull(insn.getArray())) {
            this.sideEffect = true;
        }
    }

    @Override
    public void visit(GetElementInstruction insn) {
    }

    @Override
    public void visit(PutElementInstruction insn) {
    }

    @Override
    public void visit(InvokeInstruction insn) {
    }

    @Override
    public void visit(InvokeDynamicInstruction insn) {
    }

    @Override
    public void visit(IsInstanceInstruction insn) {
        this.canMove = true;
    }

    @Override
    public void visit(InitClassInstruction insn) {
    }

    @Override
    public void visit(NullCheckInstruction insn) {
        this.canMove = true;
        if (!this.nullness.isNotNull(insn.getValue())) {
            this.sideEffect = true;
        }
    }

    @Override
    public void visit(MonitorEnterInstruction insn) {
    }

    @Override
    public void visit(MonitorExitInstruction insn) {
    }
}

