/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.optimization;

import org.teavm.model.BasicBlock;
import org.teavm.model.Instruction;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.instructions.BinaryBranchingCondition;
import org.teavm.model.instructions.BinaryBranchingInstruction;
import org.teavm.model.instructions.BranchingCondition;
import org.teavm.model.instructions.BranchingInstruction;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.instructions.NullConstantInstruction;
import org.teavm.model.optimization.MethodOptimization;
import org.teavm.model.optimization.MethodOptimizationContext;
import org.teavm.model.optimization.UnreachableBasicBlockEliminator;
import org.teavm.model.util.InstructionTransitionExtractor;

public class ConstantConditionElimination
implements MethodOptimization {
    private int[] constants;
    private boolean[] constantDefined;
    private boolean[] nullConstants;

    @Override
    public boolean optimize(MethodOptimizationContext context, Program program) {
        this.constants = new int[program.variableCount()];
        this.constantDefined = new boolean[program.variableCount()];
        this.nullConstants = new boolean[program.variableCount()];
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            for (Instruction insn : block) {
                int receiver;
                Instruction constInsn;
                if (insn instanceof IntegerConstantInstruction) {
                    constInsn = (IntegerConstantInstruction)insn;
                    receiver = ((IntegerConstantInstruction)constInsn).getReceiver().getIndex();
                    this.constants[receiver] = ((IntegerConstantInstruction)constInsn).getConstant();
                    this.constantDefined[receiver] = true;
                    continue;
                }
                if (!(insn instanceof NullConstantInstruction)) continue;
                constInsn = (NullConstantInstruction)insn;
                receiver = ((NullConstantInstruction)constInsn).getReceiver().getIndex();
                this.nullConstants[receiver] = true;
            }
        }
        boolean changed = false;
        InstructionTransitionExtractor transitionExtractor = new InstructionTransitionExtractor();
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            Instruction insn = block.getLastInstruction();
            BasicBlock target = this.constantTarget(insn);
            if (target == null) continue;
            block.getLastInstruction().acceptVisitor(transitionExtractor);
            for (BasicBlock successor : transitionExtractor.getTargets()) {
                if (successor == target) continue;
                for (Phi phi : successor.getPhis()) {
                    for (int j = 0; j < phi.getIncomings().size(); ++j) {
                        if (phi.getIncomings().get(j).getSource() != block) continue;
                        phi.getIncomings().remove(j--);
                    }
                }
            }
            JumpInstruction jump = new JumpInstruction();
            jump.setTarget(target);
            jump.setLocation(insn.getLocation());
            block.getLastInstruction().replace(jump);
            changed = true;
        }
        if (changed) {
            new UnreachableBasicBlockEliminator().optimize(program);
        }
        return changed;
    }

    private BasicBlock constantTarget(Instruction instruction) {
        block13: {
            block12: {
                if (!(instruction instanceof BranchingInstruction)) break block12;
                BranchingInstruction branching = (BranchingInstruction)instruction;
                switch (branching.getCondition()) {
                    case NULL: {
                        if (this.nullConstants[branching.getOperand().getIndex()]) {
                            return branching.getConsequent();
                        }
                        break block13;
                    }
                    case NOT_NULL: {
                        if (this.nullConstants[branching.getOperand().getIndex()]) {
                            return branching.getAlternative();
                        }
                        break block13;
                    }
                    default: {
                        int operand = branching.getOperand().getIndex();
                        if (this.constantDefined[operand]) {
                            return this.checkCondition(branching.getCondition(), this.constants[operand]) ? branching.getConsequent() : branching.getAlternative();
                        }
                        break block13;
                    }
                }
            }
            if (instruction instanceof BinaryBranchingInstruction) {
                BinaryBranchingInstruction branching = (BinaryBranchingInstruction)instruction;
                int first = branching.getFirstOperand().getIndex();
                int second = branching.getSecondOperand().getIndex();
                switch (branching.getCondition()) {
                    case EQUAL: 
                    case NOT_EQUAL: {
                        boolean result;
                        if (!this.constantDefined[first] || !this.constantDefined[second]) break;
                        boolean bl = result = this.constants[first] == this.constants[second];
                        if (branching.getCondition() == BinaryBranchingCondition.NOT_EQUAL) {
                            result = !result;
                        }
                        return result ? branching.getConsequent() : branching.getAlternative();
                    }
                }
            }
        }
        return null;
    }

    private boolean checkCondition(BranchingCondition condition, int constant) {
        switch (condition) {
            case EQUAL: {
                return constant == 0;
            }
            case NOT_EQUAL: {
                return constant != 0;
            }
            case GREATER: {
                return constant > 0;
            }
            case GREATER_OR_EQUAL: {
                return constant >= 0;
            }
            case LESS: {
                return constant < 0;
            }
            case LESS_OR_EQUAL: {
                return constant <= 0;
            }
        }
        return false;
    }
}

