/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.lowlevel;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.ObjectIntMap;
import com.carrotsearch.hppc.ObjectIntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.common.DominatorTree;
import org.teavm.common.Graph;
import org.teavm.common.GraphBuilder;
import org.teavm.common.GraphUtils;
import org.teavm.model.BasicBlock;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.Variable;
import org.teavm.model.instructions.CloneArrayInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ConstructMultiArrayInstruction;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.lowlevel.ManagedMethodRepository;
import org.teavm.model.util.DefinitionExtractor;
import org.teavm.model.util.GraphColorer;
import org.teavm.model.util.LivenessAnalyzer;
import org.teavm.model.util.ProgramUtils;
import org.teavm.model.util.TypeInferer;
import org.teavm.model.util.UsageExtractor;
import org.teavm.model.util.VariableType;
import org.teavm.runtime.ShadowStack;

public class GCShadowStackContributor {
    private ManagedMethodRepository managedMethodRepository;

    public GCShadowStackContributor(ManagedMethodRepository managedMethodRepository) {
        this.managedMethodRepository = managedMethodRepository;
    }

    public int contribute(Program program, MethodReader method) {
        List<Map<Instruction, BitSet>> liveInInformation = this.findCallSiteLiveIns(program, method);
        Graph interferenceGraph = this.buildInterferenceGraph(liveInInformation, program);
        boolean[] spilled = this.getAffectedVariables(liveInInformation, program);
        int[] colors = new int[interferenceGraph.size()];
        Arrays.fill(colors, -1);
        new GraphColorer().colorize(interferenceGraph, colors);
        int usedColors = 0;
        for (int var = 0; var < colors.length; ++var) {
            if (!spilled[var]) continue;
            usedColors = Math.max(usedColors, colors[var]);
            int n = var;
            colors[n] = colors[n] - 1;
        }
        if (usedColors == 0) {
            return 0;
        }
        List<Set<Phi>> destinationPhis = this.getDestinationPhis(program);
        int[] inputCount = this.getInputCount(program);
        boolean[] autoSpilled = new boolean[spilled.length];
        for (int i = 0; i < spilled.length; ++i) {
            this.findAutoSpilledPhis(spilled, destinationPhis, inputCount, autoSpilled, i);
        }
        List<Map<Instruction, int[]>> liveInStores = this.reduceGCRootStores(program, usedColors, liveInInformation, colors, autoSpilled);
        this.putLiveInGCRoots(program, liveInStores);
        return usedColors;
    }

    private void findAutoSpilledPhis(boolean[] spilled, List<Set<Phi>> destinationPhis, int[] inputCount, boolean[] autoSpilled, int i) {
        Set<Phi> phis;
        if (spilled[i] && (phis = destinationPhis.get(i)) != null) {
            for (Phi phi : destinationPhis.get(i)) {
                int destination;
                int n = destination = phi.getReceiver().getIndex();
                int n2 = inputCount[n] - 1;
                inputCount[n] = n2;
                boolean bl = autoSpilled[destination] = n2 == 0;
                if (spilled[destination]) continue;
                spilled[destination] = true;
                if (i <= destination) continue;
                this.findAutoSpilledPhis(spilled, destinationPhis, inputCount, autoSpilled, destination);
            }
        }
    }

    private List<Map<Instruction, BitSet>> findCallSiteLiveIns(Program program, MethodReader method) {
        Graph cfg = ProgramUtils.buildControlFlowGraph(program);
        TypeInferer typeInferer = new TypeInferer();
        typeInferer.inferTypes(program, method.getReference());
        ArrayList<Map<Instruction, BitSet>> liveInInformation = new ArrayList<Map<Instruction, BitSet>>();
        LivenessAnalyzer livenessAnalyzer = new LivenessAnalyzer();
        livenessAnalyzer.analyze(program);
        DefinitionExtractor defExtractor = new DefinitionExtractor();
        UsageExtractor useExtractor = new UsageExtractor();
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            HashMap<Instruction, BitSet> blockLiveIn = new HashMap<Instruction, BitSet>();
            liveInInformation.add(blockLiveIn);
            BitSet currentLiveOut = new BitSet();
            for (int successor : cfg.outgoingEdges(i)) {
                currentLiveOut.or(livenessAnalyzer.liveIn(successor));
            }
            for (Instruction insn = block.getLastInstruction(); insn != null; insn = insn.getPrevious()) {
                insn.acceptVisitor(defExtractor);
                insn.acceptVisitor(useExtractor);
                for (Variable usedVar : useExtractor.getUsedVariables()) {
                    currentLiveOut.set(usedVar.getIndex());
                }
                for (Variable definedVar : defExtractor.getDefinedVariables()) {
                    currentLiveOut.clear(definedVar.getIndex());
                }
                if (!(insn instanceof InvokeInstruction) && !(insn instanceof InitClassInstruction) && !(insn instanceof ConstructInstruction) && !(insn instanceof ConstructArrayInstruction) && !(insn instanceof ConstructMultiArrayInstruction) && !(insn instanceof CloneArrayInstruction) && !(insn instanceof RaiseInstruction) || insn instanceof InvokeInstruction && !this.managedMethodRepository.isManaged(((InvokeInstruction)insn).getMethod())) continue;
                BitSet csLiveIn = (BitSet)currentLiveOut.clone();
                int v = csLiveIn.nextSetBit(0);
                while (v >= 0) {
                    if (!this.isReference(typeInferer, v)) {
                        csLiveIn.clear(v);
                    }
                    v = csLiveIn.nextSetBit(v + 1);
                }
                csLiveIn.clear(0, method.parameterCount() + 1);
                blockLiveIn.put(insn, csLiveIn);
            }
            if (block.getExceptionVariable() == null) continue;
            currentLiveOut.clear(block.getExceptionVariable().getIndex());
        }
        return liveInInformation;
    }

    private Graph buildInterferenceGraph(List<Map<Instruction, BitSet>> liveInInformation, Program program) {
        GraphBuilder builder = new GraphBuilder(program.variableCount());
        for (Map<Instruction, BitSet> blockLiveIn : liveInInformation) {
            for (BitSet liveVarsSet : blockLiveIn.values()) {
                IntArrayList liveVars = new IntArrayList();
                int i = liveVarsSet.nextSetBit(0);
                while (i >= 0) {
                    liveVars.add(i);
                    i = liveVarsSet.nextSetBit(i + 1);
                }
                int[] liveVarArray = liveVars.toArray();
                for (int i2 = 0; i2 < liveVarArray.length - 1; ++i2) {
                    for (int j = i2 + 1; j < liveVarArray.length; ++j) {
                        builder.addEdge(liveVarArray[i2], liveVarArray[j]);
                        builder.addEdge(liveVarArray[j], liveVarArray[i2]);
                    }
                }
            }
        }
        return builder.build();
    }

    private boolean[] getAffectedVariables(List<Map<Instruction, BitSet>> liveInInformation, Program program) {
        boolean[] affectedVariables = new boolean[program.variableCount()];
        for (Map<Instruction, BitSet> blockLiveIn : liveInInformation) {
            for (BitSet liveVarsSet : blockLiveIn.values()) {
                int i = liveVarsSet.nextSetBit(0);
                while (i >= 0) {
                    affectedVariables[i] = true;
                    i = liveVarsSet.nextSetBit(i + 1);
                }
            }
        }
        return affectedVariables;
    }

    private List<Set<Phi>> getDestinationPhis(Program program) {
        ArrayList<Set<Phi>> destinationPhis = new ArrayList<Set<Phi>>();
        destinationPhis.addAll(Collections.nCopies(program.variableCount(), null));
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            for (Phi phi : block.getPhis()) {
                for (Incoming incoming : phi.getIncomings()) {
                    HashSet<Phi> phis = (HashSet<Phi>)destinationPhis.get(incoming.getValue().getIndex());
                    if (phis == null) {
                        phis = new HashSet<Phi>();
                        destinationPhis.set(incoming.getValue().getIndex(), phis);
                    }
                    phis.add(phi);
                }
            }
        }
        return destinationPhis;
    }

    private int[] getInputCount(Program program) {
        int[] inputCount = new int[program.variableCount()];
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            for (Phi phi : block.getPhis()) {
                inputCount[phi.getReceiver().getIndex()] = phi.getIncomings().size();
            }
        }
        return inputCount;
    }

    private List<Map<Instruction, int[]>> reduceGCRootStores(Program program, final int usedColors, List<Map<Instruction, BitSet>> liveInInformation, int[] colors, boolean[] autoSpilled) {
        ArrayList<Map<Instruction, int[]>> slotsToUpdate = new ArrayList<Map<Instruction, int[]>>();
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            slotsToUpdate.add(new HashMap());
        }
        Graph cfg = ProgramUtils.buildControlFlowGraph(program);
        DominatorTree dom = GraphUtils.buildDominatorTree(cfg);
        Graph domGraph = GraphUtils.buildDominatorGraph(dom, cfg.size());
        Step[] stack = new Step[program.basicBlockCount() * 2];
        int head = 0;
        class Step {
            private final int node;
            private final int[] slotStates;

            Step(int node) {
                this.slotStates = new int[usedColors];
                this.node = node;
            }
        }
        Step start = new Step(0);
        Arrays.fill(start.slotStates, usedColors);
        stack[head++] = start;
        while (head > 0) {
            Step step = stack[--head];
            int[] previousStates = step.slotStates;
            int[] states = (int[])previousStates.clone();
            Map<Instruction, BitSet> callSites = liveInInformation.get(step.node);
            Map updatesByCallSite = (Map)slotsToUpdate.get(step.node);
            for (Instruction callSiteLocation : this.sortInstructions(callSites.keySet(), program.basicBlockAt(step.node))) {
                BitSet liveIns = callSites.get(callSiteLocation);
                int liveVar = liveIns.nextSetBit(0);
                while (liveVar >= 0) {
                    int slot = colors[liveVar];
                    states[slot] = liveVar;
                    liveVar = liveIns.nextSetBit(liveVar + 1);
                }
                for (int slot = 0; slot < states.length; ++slot) {
                    if (states[slot] < 0 || liveIns.get(states[slot])) continue;
                    states[slot] = -1;
                }
                updatesByCallSite.put(callSiteLocation, GCShadowStackContributor.compareStates(previousStates, states, autoSpilled));
                previousStates = states;
                states = (int[])states.clone();
            }
            for (Object succ : (Object)domGraph.outgoingEdges(step.node)) {
                Step next = new Step((int)succ);
                System.arraycopy(states, 0, next.slotStates, 0, usedColors);
                stack[head++] = next;
            }
        }
        return slotsToUpdate;
    }

    private List<Instruction> sortInstructions(Collection<Instruction> instructions, BasicBlock block) {
        ObjectIntOpenHashMap indexes = new ObjectIntOpenHashMap();
        int index = 0;
        for (Instruction instruction : block) {
            indexes.put((Object)instruction, index++);
        }
        ArrayList<Instruction> sortedInstructions = new ArrayList<Instruction>(instructions);
        sortedInstructions.sort(Comparator.comparing(arg_0 -> GCShadowStackContributor.lambda$sortInstructions$0((ObjectIntMap)indexes, arg_0)));
        return sortedInstructions;
    }

    private static int[] compareStates(int[] oldStates, int[] newStates, boolean[] autoSpilled) {
        int i;
        int[] comparison = new int[oldStates.length];
        Arrays.fill(comparison, -2);
        for (i = 0; i < oldStates.length; ++i) {
            if (oldStates[i] == newStates[i]) continue;
            comparison[i] = newStates[i];
        }
        for (i = 0; i < newStates.length; ++i) {
            if (newStates[i] < 0 || !autoSpilled[newStates[i]]) continue;
            comparison[i] = -2;
        }
        return comparison;
    }

    private void putLiveInGCRoots(Program program, List<Map<Instruction, int[]>> updateInformation) {
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            Map<Instruction, int[]> updatesByIndex = updateInformation.get(i);
            Instruction[] callSiteLocations = updatesByIndex.keySet().toArray(new Instruction[0]);
            ObjectIntMap<Instruction> instructionIndexes = this.getInstructionIndexes(block);
            Arrays.sort(callSiteLocations, Comparator.comparing(arg_0 -> instructionIndexes.get(arg_0)));
            for (Instruction callSiteLocation : updatesByIndex.keySet()) {
                int[] updates = updatesByIndex.get(callSiteLocation);
                this.storeLiveIns(block, callSiteLocation, updates);
            }
        }
    }

    private ObjectIntMap<Instruction> getInstructionIndexes(BasicBlock block) {
        ObjectIntOpenHashMap indexes = new ObjectIntOpenHashMap();
        for (Instruction instruction : block) {
            indexes.put((Object)instruction, indexes.size());
        }
        return indexes;
    }

    private void storeLiveIns(BasicBlock block, Instruction callInstruction, int[] updates) {
        Program program = block.getProgram();
        ArrayList<Instruction> instructionsToAdd = new ArrayList<Instruction>();
        for (int slot = 0; slot < updates.length; ++slot) {
            int var = updates[slot];
            if (var == -2) continue;
            Variable slotVar = program.createVariable();
            IntegerConstantInstruction slotConstant = new IntegerConstantInstruction();
            slotConstant.setReceiver(slotVar);
            slotConstant.setConstant(slot);
            slotConstant.setLocation(callInstruction.getLocation());
            instructionsToAdd.add(slotConstant);
            InvokeInstruction registerInvocation = new InvokeInstruction();
            registerInvocation.setLocation(callInstruction.getLocation());
            registerInvocation.setType(InvocationType.SPECIAL);
            registerInvocation.getArguments().add(slotVar);
            if (var >= 0) {
                registerInvocation.setMethod(new MethodReference(ShadowStack.class, "registerGCRoot", Integer.TYPE, Object.class, Void.TYPE));
                registerInvocation.getArguments().add(program.variableAt(var));
            } else {
                registerInvocation.setMethod(new MethodReference(ShadowStack.class, "removeGCRoot", Integer.TYPE, Void.TYPE));
            }
            instructionsToAdd.add(registerInvocation);
        }
        callInstruction.insertPreviousAll(instructionsToAdd);
    }

    private boolean isReference(TypeInferer typeInferer, int var) {
        VariableType liveType = typeInferer.typeOf(var);
        switch (liveType) {
            case BYTE_ARRAY: 
            case CHAR_ARRAY: 
            case SHORT_ARRAY: 
            case INT_ARRAY: 
            case FLOAT_ARRAY: 
            case LONG_ARRAY: 
            case DOUBLE_ARRAY: 
            case OBJECT_ARRAY: 
            case OBJECT: {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ Integer lambda$sortInstructions$0(ObjectIntMap indexes, Instruction insn) {
        return indexes.getOrDefault((Object)insn, -1);
    }
}

