/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.classes;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.classes.InterfaceToClassMapping;
import org.teavm.model.classes.VirtualTable;
import org.teavm.model.classes.VirtualTableEntry;

public class VirtualTableProvider {
    private ClassReaderSource classSource;
    private Map<String, Set<MethodDescriptor>> virtualMethodMap = new HashMap<String, Set<MethodDescriptor>>();
    private Map<String, VirtualTable> virtualTables = new LinkedHashMap<String, VirtualTable>();
    private InterfaceToClassMapping interfaceMapping;

    public VirtualTableProvider(ListableClassReaderSource classSource, Set<MethodReference> virtualMethods) {
        this.classSource = classSource;
        this.interfaceMapping = new InterfaceToClassMapping(classSource);
        HashSet<String> classNames = new HashSet<String>(classSource.getClassNames());
        for (MethodReference virtualMethod : virtualMethods) {
            String cls = this.interfaceMapping.mapClass(virtualMethod.getClassName());
            if (cls == null) {
                cls = virtualMethod.getClassName();
            }
            classNames.add(cls);
            this.virtualMethodMap.computeIfAbsent(cls, c -> new HashSet()).add(virtualMethod.getDescriptor());
        }
        for (String className : classNames) {
            this.fillClass(className);
        }
    }

    private void fillClass(String className) {
        Set<MethodDescriptor> newDescriptors;
        VirtualTableEntry entry;
        if (this.virtualTables.containsKey(className)) {
            return;
        }
        VirtualTable table = new VirtualTable(className);
        this.virtualTables.put(className, table);
        ClassReader cls = this.classSource.get(className);
        if (cls.getParent() != null) {
            this.fillClass(cls.getParent());
            VirtualTable parentTable = this.virtualTables.get(cls.getParent());
            for (VirtualTableEntry virtualTableEntry : parentTable.entries.values()) {
                entry = new VirtualTableEntry(table, virtualTableEntry.getMethod(), virtualTableEntry.getImplementor(), virtualTableEntry.getIndex());
                table.entries.put(entry.getMethod(), entry);
            }
        }
        if ((newDescriptors = this.virtualMethodMap.get(className)) != null) {
            for (MethodDescriptor methodDescriptor : newDescriptors) {
                table.entries.put(methodDescriptor, new VirtualTableEntry(table, methodDescriptor, null, table.entries.size()));
            }
        }
        for (MethodReader methodReader : cls.getMethods()) {
            if (methodReader.hasModifier(ElementModifier.ABSTRACT) || (entry = table.entries.get(methodReader.getDescriptor())) == null) continue;
            entry.implementor = methodReader.getReference();
        }
    }

    public VirtualTableEntry lookup(MethodReference method) {
        VirtualTable vtable = this.virtualTables.get(this.interfaceMapping.mapClass(method.getClassName()));
        if (vtable == null) {
            return null;
        }
        return vtable.getEntries().get(method.getDescriptor());
    }

    public VirtualTable lookup(String className) {
        return this.virtualTables.get(this.interfaceMapping.mapClass(className));
    }
}

