/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.classes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.ListableClassReaderSource;

public class TagRegistry {
    private Map<String, List<Range>> ranges = new HashMap<String, List<Range>>();

    public TagRegistry(ListableClassReaderSource classSource) {
        ArrayList<String> roots = new ArrayList<String>();
        HashMap<String, Set<String>> implementedBy = new HashMap<String, Set<String>>();
        HashMap<String, List<String>> hierarchy = new HashMap<String, List<String>>();
        for (String className : classSource.getClassNames()) {
            ClassReader cls = classSource.get(className);
            if (cls == null || cls.hasModifier(ElementModifier.INTERFACE)) continue;
            for (String iface : cls.getInterfaces()) {
                String topmostImplementor = this.findTopmostImplementor(classSource, className, iface);
                this.markImplementor(classSource, topmostImplementor, iface, implementedBy);
            }
            if (cls.getParent() == null || cls.getParent().equals(cls.getName())) {
                roots.add(className);
                continue;
            }
            hierarchy.computeIfAbsent(cls.getParent(), key -> new ArrayList()).add(className);
        }
        HashMap<String, Range> simpleRanges = new HashMap<String, Range>();
        int current = 0;
        for (String root : roots) {
            this.assignRange(current, hierarchy, root, simpleRanges);
            ++current;
        }
        for (String className : classSource.getClassNames()) {
            ClassReader cls = classSource.get(className);
            if (cls == null) continue;
            if (cls.hasModifier(ElementModifier.INTERFACE)) {
                List ifaceRanges;
                Set implementorRoots = (Set)implementedBy.get(cls.getName());
                if (implementorRoots == null || (ifaceRanges = implementorRoots.stream().map(implementor -> (Range)simpleRanges.get(implementor)).filter(Objects::nonNull).sorted(Comparator.comparing(range -> range.lower)).collect(Collectors.toList())).isEmpty()) continue;
                this.ranges.put(className, ifaceRanges);
                continue;
            }
            Range simpleRange = (Range)simpleRanges.get(className);
            if (simpleRange == null) continue;
            this.ranges.put(className, new ArrayList<Range>(Arrays.asList(simpleRange)));
        }
    }

    private String findTopmostImplementor(ClassReaderSource classSource, String className, String ifaceName) {
        String candidate;
        ClassReader cls = classSource.get(className);
        if (cls == null) {
            return null;
        }
        if (cls.getParent() != null && !cls.getParent().equals(cls.getName()) && (candidate = this.findTopmostImplementor(classSource, cls.getParent(), ifaceName)) != null) {
            return candidate;
        }
        return cls.getInterfaces().contains(ifaceName) ? className : null;
    }

    private void markImplementor(ClassReaderSource classSource, String className, String ifaceName, Map<String, Set<String>> implementedBy) {
        if (!implementedBy.computeIfAbsent(ifaceName, key -> new HashSet()).add(className)) {
            return;
        }
        ClassReader iface = classSource.get(ifaceName);
        if (iface == null) {
            return;
        }
        for (String superIface : iface.getInterfaces()) {
            this.markImplementor(classSource, className, superIface, implementedBy);
        }
    }

    private int assignRange(int start, Map<String, List<String>> hierarhy, String className, Map<String, Range> ranges) {
        int end = start + 1;
        for (String childClass : hierarhy.getOrDefault(className, Collections.emptyList())) {
            end = this.assignRange(end, hierarhy, childClass, ranges);
        }
        ranges.put(className, new Range(start, ++end));
        return end;
    }

    public List<Range> getRanges(String className) {
        return new ArrayList<Range>(this.ranges.getOrDefault(className, Collections.emptyList()));
    }

    public static class Range {
        public int lower;
        public int upper;

        private Range(int lower, int upper) {
            this.lower = lower;
            this.upper = upper;
        }
    }
}

