/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model;

import java.util.HashMap;
import java.util.Map;
import org.teavm.model.AnnotationContainerReader;
import org.teavm.model.AnnotationHolder;

public class AnnotationContainer
implements AnnotationContainerReader {
    private Map<String, AnnotationHolder> annotations = new HashMap<String, AnnotationHolder>();

    public void add(AnnotationHolder annotation) {
        if (this.annotations.containsKey(annotation.getType())) {
            throw new IllegalArgumentException("Annotation of type " + annotation.getType() + " is already there");
        }
        this.annotations.put(annotation.getType(), annotation);
    }

    @Override
    public AnnotationHolder get(String type) {
        return this.annotations.get(type);
    }

    public void remove(AnnotationHolder annotation) {
        AnnotationHolder existingAnnot = this.get(annotation.getType());
        if (existingAnnot != annotation) {
            throw new IllegalArgumentException("There is no such annotation");
        }
        this.annotations.remove(annotation.getType());
    }

    public void remove(String type) {
        this.annotations.remove(type);
    }

    public Iterable<AnnotationHolder> all() {
        return this.annotations.values();
    }
}

