/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.FieldDependencyInfo;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHolder;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.FieldReference;
import org.teavm.model.Instruction;
import org.teavm.model.MemberHolder;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.PutFieldInstruction;

public class Linker {
    public void link(DependencyInfo dependency, ClassHolder cls) {
        for (MethodHolder methodHolder : cls.getMethods().toArray(new MethodHolder[0])) {
            MethodReference methodRef = new MethodReference(cls.getName(), methodHolder.getDescriptor());
            MethodDependencyInfo methodDep = dependency.getMethod(methodRef);
            if (methodDep == null) {
                cls.removeMethod(methodHolder);
                continue;
            }
            if (!methodDep.isUsed()) {
                methodHolder.getModifiers().add(ElementModifier.ABSTRACT);
                methodHolder.setProgram(null);
                continue;
            }
            if (methodHolder.getProgram() == null) continue;
            this.link(dependency, methodHolder);
        }
        for (MemberHolder memberHolder : cls.getFields().toArray(new FieldHolder[0])) {
            FieldReference fieldRef = new FieldReference(cls.getName(), memberHolder.getName());
            if (dependency.getField(fieldRef) != null) continue;
            cls.removeField((FieldHolder)memberHolder);
        }
    }

    private void link(DependencyInfo dependency, MethodHolder method) {
        Program program = method.getProgram();
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            for (Instruction insn : block) {
                FieldDependencyInfo linkedField;
                Instruction getField;
                if (insn instanceof InvokeInstruction) {
                    InvokeInstruction invoke = (InvokeInstruction)insn;
                    MethodDependencyInfo linkedMethod = dependency.getMethodImplementation(invoke.getMethod());
                    if (linkedMethod == null) continue;
                    invoke.setMethod(linkedMethod.getReference());
                    continue;
                }
                if (insn instanceof GetFieldInstruction) {
                    FieldReference fieldRef;
                    getField = (GetFieldInstruction)insn;
                    linkedField = dependency.getField(((GetFieldInstruction)getField).getField());
                    if (linkedField != null) {
                        ((GetFieldInstruction)getField).setField(linkedField.getReference());
                    }
                    if ((fieldRef = ((GetFieldInstruction)getField).getField()).getClassName().equals(method.getOwnerName())) continue;
                    InitClassInstruction initInsn = new InitClassInstruction();
                    initInsn.setClassName(fieldRef.getClassName());
                    initInsn.setLocation(insn.getLocation());
                    insn.insertPrevious(initInsn);
                    continue;
                }
                if (!(insn instanceof PutFieldInstruction) || (linkedField = dependency.getField(((PutFieldInstruction)(getField = (PutFieldInstruction)insn)).getField())) == null) continue;
                ((PutFieldInstruction)getField).setField(linkedField.getReference());
            }
        }
    }
}

