/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.teavm.cache.NoCache;
import org.teavm.callgraph.DefaultCallGraphNode;
import org.teavm.dependency.BootstrapMethodSubstitutor;
import org.teavm.dependency.DataFlowGraphBuilder;
import org.teavm.dependency.DependencyChecker;
import org.teavm.dependency.DependencyConsumer;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.DependencyType;
import org.teavm.dependency.DynamicCallSite;
import org.teavm.dependency.FieldDependency;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.BasicBlock;
import org.teavm.model.BasicBlockReader;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReference;
import org.teavm.model.Incoming;
import org.teavm.model.IncomingReader;
import org.teavm.model.Instruction;
import org.teavm.model.InvokeDynamicInstruction;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHandle;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.Phi;
import org.teavm.model.PhiReader;
import org.teavm.model.Program;
import org.teavm.model.RuntimeConstant;
import org.teavm.model.TextLocation;
import org.teavm.model.TryCatchBlockReader;
import org.teavm.model.ValueType;
import org.teavm.model.VariableReader;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;
import org.teavm.model.instructions.AbstractInstructionReader;
import org.teavm.model.instructions.ArrayElementType;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.InstructionReader;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.NullConstantInstruction;
import org.teavm.model.text.ListingBuilder;

class DependencyGraphBuilder {
    private DependencyChecker dependencyChecker;
    private DependencyNode[] nodes;
    private DependencyNode resultNode;
    private Program program;
    private DefaultCallGraphNode caller;
    private TextLocation currentLocation;
    private ExceptionConsumer currentExceptionConsumer;
    private InstructionReader reader = new AbstractInstructionReader(){

        @Override
        public void location(TextLocation location) {
            DependencyGraphBuilder.this.currentLocation = location;
        }

        @Override
        public void classConstant(VariableReader receiver, ValueType cst) {
            DependencyNode node = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            if (node != null) {
                node.propagate(DependencyGraphBuilder.this.dependencyChecker.getType("java.lang.Class"));
                if (!(cst instanceof ValueType.Primitive)) {
                    StringBuilder sb = new StringBuilder();
                    while (cst instanceof ValueType.Array) {
                        cst = ((ValueType.Array)cst).getItemType();
                        sb.append('[');
                    }
                    if (cst instanceof ValueType.Object) {
                        sb.append(((ValueType.Object)cst).getClassName());
                    } else {
                        sb.append(cst.toString());
                    }
                    node.getClassValueNode().propagate(DependencyGraphBuilder.this.dependencyChecker.getType(sb.toString()));
                }
            }
            while (cst instanceof ValueType.Array) {
                cst = ((ValueType.Array)cst).getItemType();
            }
            if (cst instanceof ValueType.Object) {
                String className = ((ValueType.Object)cst).getClassName();
                DependencyGraphBuilder.this.dependencyChecker.linkClass(className, new CallLocation(DependencyGraphBuilder.this.caller.getMethod(), DependencyGraphBuilder.this.currentLocation));
            }
        }

        @Override
        public void stringConstant(VariableReader receiver, String cst) {
            DependencyNode node = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            if (node != null) {
                node.propagate(DependencyGraphBuilder.this.dependencyChecker.getType("java.lang.String"));
            }
            MethodDependency method = DependencyGraphBuilder.this.dependencyChecker.linkMethod(new MethodReference(String.class, "<init>", char[].class, Void.TYPE), new CallLocation(DependencyGraphBuilder.this.caller.getMethod(), DependencyGraphBuilder.this.currentLocation));
            method.use();
        }

        @Override
        public void assign(VariableReader receiver, VariableReader assignee) {
            DependencyNode valueNode = DependencyGraphBuilder.this.nodes[assignee.getIndex()];
            DependencyNode receiverNode = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            if (valueNode != null && receiverNode != null) {
                valueNode.connect(receiverNode);
            }
        }

        @Override
        public void cast(VariableReader receiver, VariableReader value, ValueType targetType) {
            String targetClsName;
            ClassReader targetClass;
            DependencyNode valueNode = DependencyGraphBuilder.this.nodes[value.getIndex()];
            DependencyNode receiverNode = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            ClassReaderSource classSource = DependencyGraphBuilder.this.dependencyChecker.getClassSource();
            if (targetType instanceof ValueType.Object && (targetClass = classSource.get(targetClsName = ((ValueType.Object)targetType).getClassName())) != null) {
                if (valueNode != null && receiverNode != null) {
                    valueNode.connect(receiverNode, type -> {
                        if (targetClass.getName().equals("java.lang.Object")) {
                            return true;
                        }
                        return classSource.isSuperType(targetClass.getName(), type.getName()).orElse(false);
                    });
                }
                return;
            }
            if (valueNode != null && receiverNode != null) {
                valueNode.connect(receiverNode);
            }
        }

        @Override
        public void exit(VariableReader valueToReturn) {
            DependencyNode node;
            if (valueToReturn != null && (node = DependencyGraphBuilder.this.nodes[valueToReturn.getIndex()]) != null) {
                node.connect(DependencyGraphBuilder.this.resultNode);
            }
        }

        @Override
        public void raise(VariableReader exception) {
            DependencyGraphBuilder.this.nodes[exception.getIndex()].addConsumer(DependencyGraphBuilder.this.currentExceptionConsumer);
        }

        @Override
        public void createArray(VariableReader receiver, ValueType itemType, VariableReader size) {
            String className;
            DependencyNode node = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            if (node != null) {
                node.propagate(DependencyGraphBuilder.this.dependencyChecker.getType("[" + itemType));
            }
            if ((className = this.extractClassName(itemType)) != null) {
                DependencyGraphBuilder.this.dependencyChecker.linkClass(className, new CallLocation(DependencyGraphBuilder.this.caller.getMethod(), DependencyGraphBuilder.this.currentLocation));
            }
        }

        private String extractClassName(ValueType itemType) {
            while (itemType instanceof ValueType.Array) {
                itemType = ((ValueType.Array)itemType).getItemType();
            }
            return itemType instanceof ValueType.Object ? ((ValueType.Object)itemType).getClassName() : null;
        }

        @Override
        public void createArray(VariableReader receiver, ValueType itemType, List<? extends VariableReader> dimensions) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < dimensions.size(); ++i) {
                sb.append('[');
                itemType = ((ValueType.Array)itemType).getItemType();
            }
            String itemTypeStr = itemType instanceof ValueType.Object ? ((ValueType.Object)itemType).getClassName() : itemType.toString();
            sb.append(itemTypeStr);
            DependencyNode node = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            for (int i = 0; i < dimensions.size() && node != null; node = node.getArrayItem(), ++i) {
                node.propagate(DependencyGraphBuilder.this.dependencyChecker.getType(sb.substring(i, sb.length())));
            }
            String className = this.extractClassName(itemType);
            if (className != null) {
                DependencyGraphBuilder.this.dependencyChecker.linkClass(className, new CallLocation(DependencyGraphBuilder.this.caller.getMethod(), DependencyGraphBuilder.this.currentLocation));
            }
        }

        @Override
        public void create(VariableReader receiver, String type) {
            DependencyGraphBuilder.this.dependencyChecker.linkClass(type, new CallLocation(DependencyGraphBuilder.this.caller.getMethod(), DependencyGraphBuilder.this.currentLocation));
            DependencyNode node = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            if (node != null) {
                node.propagate(DependencyGraphBuilder.this.dependencyChecker.getType(type));
            }
        }

        @Override
        public void getField(VariableReader receiver, VariableReader instance, FieldReference field, ValueType fieldType) {
            DependencyNode receiverNode;
            FieldDependency fieldDep = DependencyGraphBuilder.this.dependencyChecker.linkField(field, new CallLocation(DependencyGraphBuilder.this.caller.getMethod(), DependencyGraphBuilder.this.currentLocation));
            if (!(fieldType instanceof ValueType.Primitive) && (receiverNode = DependencyGraphBuilder.this.nodes[receiver.getIndex()]) != null) {
                fieldDep.getValue().connect(receiverNode);
            }
            this.initClass(field.getClassName());
        }

        @Override
        public void putField(VariableReader instance, FieldReference field, VariableReader value, ValueType fieldType) {
            DependencyNode valueNode;
            FieldDependency fieldDep = DependencyGraphBuilder.this.dependencyChecker.linkField(field, new CallLocation(DependencyGraphBuilder.this.caller.getMethod(), DependencyGraphBuilder.this.currentLocation));
            if (!(fieldType instanceof ValueType.Primitive) && (valueNode = DependencyGraphBuilder.this.nodes[value.getIndex()]) != null) {
                valueNode.connect(fieldDep.getValue());
            }
            this.initClass(field.getClassName());
        }

        @Override
        public void cloneArray(VariableReader receiver, VariableReader array) {
            DependencyNode arrayNode = DependencyGraphBuilder.this.nodes[array.getIndex()];
            DependencyNode receiverNode = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            if (arrayNode != null && receiverNode != null) {
                arrayNode.addConsumer(receiverNode::propagate);
                arrayNode.getArrayItem().connect(receiverNode.getArrayItem());
            }
            MethodDependency cloneDep = DependencyGraphBuilder.this.dependencyChecker.linkMethod(new MethodReference(Object.class, "clone", Object.class), new CallLocation(DependencyGraphBuilder.this.caller.getMethod(), DependencyGraphBuilder.this.currentLocation));
            arrayNode.connect(cloneDep.getVariable(0));
            cloneDep.use();
        }

        @Override
        public void unwrapArray(VariableReader receiver, VariableReader array, ArrayElementType elementType) {
            DependencyNode arrayNode = DependencyGraphBuilder.this.nodes[array.getIndex()];
            DependencyNode receiverNode = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            if (arrayNode != null && receiverNode != null) {
                arrayNode.connect(receiverNode);
            }
        }

        @Override
        public void getElement(VariableReader receiver, VariableReader array, VariableReader index, ArrayElementType type) {
            DependencyNode arrayNode = DependencyGraphBuilder.this.nodes[array.getIndex()];
            DependencyNode receiverNode = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            if (arrayNode != null && receiverNode != null && receiverNode != arrayNode.getArrayItem()) {
                arrayNode.getArrayItem().connect(receiverNode);
            }
        }

        @Override
        public void putElement(VariableReader array, VariableReader index, VariableReader value, ArrayElementType type) {
            DependencyNode valueNode = DependencyGraphBuilder.this.nodes[value.getIndex()];
            DependencyNode arrayNode = DependencyGraphBuilder.this.nodes[array.getIndex()];
            if (valueNode != null && arrayNode != null && valueNode != arrayNode.getArrayItem()) {
                valueNode.connect(arrayNode.getArrayItem());
            }
        }

        @Override
        public void invoke(VariableReader receiver, VariableReader instance, MethodReference method, List<? extends VariableReader> arguments, InvocationType type) {
            if (instance == null) {
                this.invokeSpecial(receiver, null, method, arguments);
            } else {
                switch (type) {
                    case SPECIAL: {
                        this.invokeSpecial(receiver, instance, method, arguments);
                        break;
                    }
                    case VIRTUAL: {
                        this.invokeVirtual(receiver, instance, method, arguments);
                    }
                }
                if (method.getName().equals("getClass") && method.parameterCount() == 0 && method.getReturnType().isObject(Class.class) && receiver != null) {
                    DependencyGraphBuilder.this.nodes[instance.getIndex()].connect(DependencyGraphBuilder.this.nodes[receiver.getIndex()].getClassValueNode());
                }
            }
        }

        private void invokeSpecial(VariableReader receiver, VariableReader instance, MethodReference method, List<? extends VariableReader> arguments) {
            CallLocation callLocation = new CallLocation(DependencyGraphBuilder.this.caller.getMethod(), DependencyGraphBuilder.this.currentLocation);
            DependencyGraphBuilder.this.dependencyChecker.linkClass(method.getClassName(), callLocation).initClass(callLocation);
            MethodDependency methodDep = DependencyGraphBuilder.this.dependencyChecker.linkMethod(method, callLocation);
            if (methodDep.isMissing()) {
                return;
            }
            methodDep.use();
            DependencyNode[] targetParams = methodDep.getVariables();
            for (int i = 0; i < arguments.size(); ++i) {
                DependencyNode value = DependencyGraphBuilder.this.nodes[arguments.get(i).getIndex()];
                DependencyNode param = targetParams[i + 1];
                if (value == null || param == null) continue;
                value.connect(param);
            }
            if (instance != null) {
                DependencyGraphBuilder.this.nodes[instance.getIndex()].connect(targetParams[0]);
            }
            if (methodDep.getResult() != null && receiver != null) {
                DependencyNode receiverNode = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
                if (methodDep.getResult() != null && receiverNode != null) {
                    methodDep.getResult().connect(receiverNode);
                }
            }
            methodDep.getThrown().addConsumer(DependencyGraphBuilder.this.currentExceptionConsumer);
            this.initClass(method.getClassName());
        }

        private void invokeVirtual(VariableReader receiver, VariableReader instance, MethodReference method, List<? extends VariableReader> arguments) {
            MethodDependency methodDep = DependencyGraphBuilder.this.dependencyChecker.linkMethod(method, new CallLocation(DependencyGraphBuilder.this.caller.getMethod(), DependencyGraphBuilder.this.currentLocation));
            if (methodDep.isMissing()) {
                return;
            }
            DependencyNode[] actualArgs = new DependencyNode[arguments.size() + 1];
            for (int i = 0; i < arguments.size(); ++i) {
                actualArgs[i + 1] = DependencyGraphBuilder.this.nodes[arguments.get(i).getIndex()];
            }
            actualArgs[0] = DependencyGraphBuilder.this.nodes[instance.getIndex()];
            VirtualCallConsumer listener = new VirtualCallConsumer(DependencyGraphBuilder.this.nodes[instance.getIndex()], DependencyGraphBuilder.this.dependencyChecker.getClassSource().get(methodDep.getMethod().getOwnerName()), method.getDescriptor(), DependencyGraphBuilder.this.dependencyChecker, actualArgs, receiver != null ? DependencyGraphBuilder.this.nodes[receiver.getIndex()] : null, DependencyGraphBuilder.this.caller, DependencyGraphBuilder.this.currentLocation, DependencyGraphBuilder.this.currentExceptionConsumer);
            DependencyGraphBuilder.this.nodes[instance.getIndex()].addConsumer(listener);
        }

        @Override
        public void isInstance(VariableReader receiver, VariableReader value, ValueType type) {
            String className = this.extractClassName(type);
            if (className != null) {
                DependencyGraphBuilder.this.dependencyChecker.linkClass(className, new CallLocation(DependencyGraphBuilder.this.caller.getMethod(), DependencyGraphBuilder.this.currentLocation));
            }
        }

        @Override
        public void invokeDynamic(VariableReader receiver, VariableReader instance, MethodDescriptor method, List<? extends VariableReader> arguments, MethodHandle bootstrapMethod, List<RuntimeConstant> bootstrapArguments) {
        }

        @Override
        public void initClass(String className) {
            CallLocation callLocation = new CallLocation(DependencyGraphBuilder.this.caller.getMethod(), DependencyGraphBuilder.this.currentLocation);
            DependencyGraphBuilder.this.dependencyChecker.linkClass(className, callLocation).initClass(callLocation);
        }

        @Override
        public void nullCheck(VariableReader receiver, VariableReader value) {
            DependencyNode valueNode = DependencyGraphBuilder.this.nodes[value.getIndex()];
            DependencyNode receiverNode = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            valueNode.connect(receiverNode);
            DependencyGraphBuilder.this.dependencyChecker.linkMethod(new MethodReference(NullPointerException.class, "<init>", Void.TYPE), new CallLocation(DependencyGraphBuilder.this.caller.getMethod(), DependencyGraphBuilder.this.currentLocation)).use();
            DependencyGraphBuilder.this.currentExceptionConsumer.consume(DependencyGraphBuilder.this.dependencyChecker.getType("java.lang.NullPointerException"));
        }

        @Override
        public void monitorEnter(VariableReader objectRef) {
            MethodDependency methodDep = DependencyGraphBuilder.this.dependencyChecker.linkMethod(new MethodReference(Object.class, "monitorEnter", Object.class, Void.TYPE), null);
            DependencyGraphBuilder.this.nodes[objectRef.getIndex()].connect(methodDep.getVariable(1));
            methodDep.use();
            methodDep = DependencyGraphBuilder.this.dependencyChecker.linkMethod(new MethodReference(Object.class, "monitorEnterSync", Object.class, Void.TYPE), null);
            DependencyGraphBuilder.this.nodes[objectRef.getIndex()].connect(methodDep.getVariable(1));
            methodDep.use();
        }

        @Override
        public void monitorExit(VariableReader objectRef) {
            MethodDependency methodDep = DependencyGraphBuilder.this.dependencyChecker.linkMethod(new MethodReference(Object.class, "monitorExit", Object.class, Void.TYPE), null);
            DependencyGraphBuilder.this.nodes[objectRef.getIndex()].connect(methodDep.getVariable(1));
            methodDep.use();
            methodDep = DependencyGraphBuilder.this.dependencyChecker.linkMethod(new MethodReference(Object.class, "monitorExitSync", Object.class, Void.TYPE), null);
            DependencyGraphBuilder.this.nodes[objectRef.getIndex()].connect(methodDep.getVariable(1));
            methodDep.use();
        }
    };

    public DependencyGraphBuilder(DependencyChecker dependencyChecker) {
        this.dependencyChecker = dependencyChecker;
    }

    public void buildGraph(MethodDependency dep) {
        block15: {
            int i;
            this.caller = this.dependencyChecker.callGraph.getNode(dep.getReference());
            MethodHolder method = dep.method;
            if (method.getProgram() == null || method.getProgram().basicBlockCount() == 0) {
                return;
            }
            this.program = method.getProgram();
            this.resultNode = dep.getResult();
            this.processInvokeDynamic(dep);
            DataFlowGraphBuilder dfgBuilder = new DataFlowGraphBuilder();
            boolean[] significantParams = new boolean[dep.getParameterCount()];
            significantParams[0] = true;
            for (int i2 = 1; i2 < dep.getParameterCount(); ++i2) {
                ValueType arg = method.parameterType(i2 - 1);
                if (arg instanceof ValueType.Primitive) continue;
                significantParams[i2] = true;
            }
            int[] nodeMapping = dfgBuilder.buildMapping(this.program, significantParams, !(method.getResultType() instanceof ValueType.Primitive) && method.getResultType() != ValueType.VOID);
            if (DependencyChecker.shouldLog) {
                System.out.println("Method reached: " + method.getReference());
                System.out.print(new ListingBuilder().buildListing(this.program, "    "));
                for (int i3 = 0; i3 < nodeMapping.length; ++i3) {
                    System.out.print(i3 + ":" + nodeMapping[i3] + " ");
                }
                System.out.println();
                System.out.println();
            }
            int nodeClassCount = 0;
            for (int i4 = 0; i4 < nodeMapping.length; ++i4) {
                nodeClassCount = Math.max(nodeClassCount, nodeMapping[i4] + 1);
            }
            DependencyNode[] nodeClasses = Arrays.copyOf(dep.getVariables(), nodeClassCount);
            MethodReference ref = method.getReference();
            for (i = dep.getVariableCount(); i < nodeClasses.length; ++i) {
                nodeClasses[i] = this.dependencyChecker.createNode();
                nodeClasses[i].method = ref;
                if (!DependencyChecker.shouldLog) continue;
                nodeClasses[i].setTag(dep.getMethod().getReference() + ":" + i);
            }
            this.nodes = new DependencyNode[dep.getMethod().getProgram().variableCount()];
            for (i = 0; i < this.nodes.length; ++i) {
                int mappedNode = nodeMapping[i];
                this.nodes[i] = mappedNode >= 0 ? nodeClasses[mappedNode] : null;
            }
            dep.setVariables(this.nodes);
            for (i = 0; i < this.program.basicBlockCount(); ++i) {
                BasicBlock block = this.program.basicBlockAt(i);
                this.currentExceptionConsumer = this.createExceptionConsumer(dep, block);
                block.readAllInstructions(this.reader);
                for (PhiReader phiReader : block.readPhis()) {
                    DependencyNode receiverNode = this.nodes[phiReader.getReceiver().getIndex()];
                    for (IncomingReader incomingReader : phiReader.readIncomings()) {
                        DependencyNode incomingNode = this.nodes[incomingReader.getValue().getIndex()];
                        if (incomingNode == null || receiverNode == null) continue;
                        incomingNode.connect(receiverNode);
                    }
                }
                for (TryCatchBlockReader tryCatchBlockReader : block.readTryCatchBlocks()) {
                    if (tryCatchBlockReader.getExceptionType() == null) continue;
                    this.dependencyChecker.linkClass(tryCatchBlockReader.getExceptionType(), new CallLocation(this.caller.getMethod()));
                }
            }
            if (!method.hasModifier(ElementModifier.SYNCHRONIZED)) break block15;
            ArrayList<DependencyNode> syncNodes = new ArrayList<DependencyNode>();
            MethodDependency methodDep = this.dependencyChecker.linkMethod(new MethodReference(Object.class, "monitorEnter", Object.class, Void.TYPE), null);
            syncNodes.add(methodDep.getVariable(1));
            methodDep.use();
            methodDep = this.dependencyChecker.linkMethod(new MethodReference(Object.class, "monitorEnterSync", Object.class, Void.TYPE), null);
            syncNodes.add(methodDep.getVariable(1));
            methodDep.use();
            methodDep = this.dependencyChecker.linkMethod(new MethodReference(Object.class, "monitorExit", Object.class, Void.TYPE), null);
            syncNodes.add(methodDep.getVariable(1));
            methodDep.use();
            methodDep = this.dependencyChecker.linkMethod(new MethodReference(Object.class, "monitorExitSync", Object.class, Void.TYPE), null);
            syncNodes.add(methodDep.getVariable(1));
            methodDep.use();
            if (method.hasModifier(ElementModifier.STATIC)) {
                for (DependencyNode dependencyNode : syncNodes) {
                    dependencyNode.propagate(this.dependencyChecker.getType("java.lang.Class"));
                }
            } else {
                for (DependencyNode dependencyNode : syncNodes) {
                    this.nodes[0].connect(dependencyNode);
                }
            }
        }
    }

    private void processInvokeDynamic(MethodDependency methodDep) {
        if (this.program == null) {
            return;
        }
        ProgramEmitter pe = ProgramEmitter.create(this.program, this.dependencyChecker.getClassSource());
        boolean hasIndy = false;
        for (int i = 0; i < this.program.basicBlockCount(); ++i) {
            BasicBlock block = this.program.basicBlockAt(i);
            for (Instruction insn : block) {
                if (!(insn instanceof InvokeDynamicInstruction)) continue;
                block = insn.getBasicBlock();
                InvokeDynamicInstruction indy = (InvokeDynamicInstruction)insn;
                MethodReference bootstrapMethod = new MethodReference(indy.getBootstrapMethod().getClassName(), indy.getBootstrapMethod().getName(), indy.getBootstrapMethod().signature());
                BootstrapMethodSubstitutor substitutor = this.dependencyChecker.bootstrapMethodSubstitutors.get(bootstrapMethod);
                if (substitutor == null) {
                    NullConstantInstruction nullInsn = new NullConstantInstruction();
                    nullInsn.setReceiver(indy.getReceiver());
                    nullInsn.setLocation(indy.getLocation());
                    insn.replace(nullInsn);
                    CallLocation location = new CallLocation(this.caller.getMethod(), this.currentLocation);
                    this.dependencyChecker.getDiagnostics().error(location, "Substitutor for bootstrap method {{m0}} was not found", bootstrapMethod);
                    continue;
                }
                hasIndy = true;
                BasicBlock splitBlock = this.program.createBasicBlock();
                while (insn.getNext() != null) {
                    Instruction nextInsn = insn.getNext();
                    nextInsn.delete();
                    splitBlock.add(nextInsn);
                }
                for (int k = 0; k < this.program.basicBlockCount() - 1; ++k) {
                    BasicBlock replaceBlock = this.program.basicBlockAt(k);
                    for (Phi phi : replaceBlock.getPhis()) {
                        for (Incoming incoming : phi.getIncomings()) {
                            if (incoming.getSource() != block) continue;
                            incoming.setSource(splitBlock);
                        }
                    }
                }
                pe.enter(block);
                pe.setCurrentLocation(indy.getLocation());
                insn.delete();
                ArrayList<ValueEmitter> arguments = new ArrayList<ValueEmitter>();
                for (int k = 0; k < indy.getArguments().size(); ++k) {
                    arguments.add(pe.var(indy.getArguments().get(k), indy.getMethod().parameterType(k)));
                }
                DynamicCallSite callSite = new DynamicCallSite(indy.getMethod(), indy.getInstance() != null ? pe.var(indy.getInstance(), ValueType.object(methodDep.getMethod().getOwnerName())) : null, arguments, indy.getBootstrapMethod(), indy.getBootstrapArguments(), this.dependencyChecker.getAgent());
                ValueEmitter result = substitutor.substitute(callSite, pe);
                if (result.getVariable() != null && result.getVariable() != indy.getReceiver()) {
                    AssignInstruction assign = new AssignInstruction();
                    assign.setAssignee(result.getVariable());
                    assign.setReceiver(indy.getReceiver());
                    pe.addInstruction(assign);
                }
                pe.jump(splitBlock);
            }
        }
        if (hasIndy && methodDep.method.getAnnotations().get(NoCache.class.getName()) == null) {
            methodDep.method.getAnnotations().add(new AnnotationHolder(NoCache.class.getName()));
        }
    }

    private ExceptionConsumer createExceptionConsumer(MethodDependency methodDep, BasicBlockReader block) {
        List<? extends TryCatchBlockReader> tryCatchBlocks = block.readTryCatchBlocks();
        ClassReader[] exceptions = new ClassReader[tryCatchBlocks.size()];
        DependencyNode[] vars = new DependencyNode[tryCatchBlocks.size()];
        for (int i = 0; i < tryCatchBlocks.size(); ++i) {
            TryCatchBlockReader tryCatch = tryCatchBlocks.get(i);
            if (tryCatch.getExceptionType() != null) {
                exceptions[i] = this.dependencyChecker.getClassSource().get(tryCatch.getExceptionType());
            }
            if (tryCatch.getHandler().getExceptionVariable() == null) continue;
            vars[i] = methodDep.getVariable(tryCatch.getHandler().getExceptionVariable().getIndex());
        }
        return new ExceptionConsumer(this.dependencyChecker, exceptions, vars, methodDep);
    }

    private static class VirtualCallConsumer
    implements DependencyConsumer {
        private final DependencyNode node;
        private final ClassReader filterClass;
        private final MethodDescriptor methodDesc;
        private final DependencyChecker checker;
        private final DependencyNode[] parameters;
        private final DependencyNode result;
        private final DefaultCallGraphNode caller;
        private final TextLocation location;
        private final Set<MethodReference> knownMethods = new HashSet<MethodReference>();
        private ExceptionConsumer exceptionConsumer;

        public VirtualCallConsumer(DependencyNode node, ClassReader filterClass, MethodDescriptor methodDesc, DependencyChecker checker, DependencyNode[] parameters, DependencyNode result, DefaultCallGraphNode caller, TextLocation location, ExceptionConsumer exceptionConsumer) {
            this.node = node;
            this.filterClass = filterClass;
            this.methodDesc = methodDesc;
            this.checker = checker;
            this.parameters = parameters;
            this.result = result;
            this.caller = caller;
            this.location = location;
            this.exceptionConsumer = exceptionConsumer;
        }

        @Override
        public void consume(DependencyType type) {
            ClassReaderSource classSource;
            String className = type.getName();
            if (DependencyChecker.shouldLog) {
                System.out.println("Virtual call of " + this.methodDesc + " detected on " + this.node.getTag() + ". " + "Target class is " + className);
            }
            if (className.startsWith("[")) {
                className = "java.lang.Object";
            }
            if (!(classSource = this.checker.getClassSource()).isSuperType(this.filterClass.getName(), className).orElse(false).booleanValue()) {
                return;
            }
            MethodReference methodRef = new MethodReference(className, this.methodDesc);
            MethodDependency methodDep = this.checker.linkMethod(methodRef, new CallLocation(this.caller.getMethod(), this.location));
            if (!methodDep.isMissing() && this.knownMethods.add(methodRef)) {
                methodDep.use();
                DependencyNode[] targetParams = methodDep.getVariables();
                if (this.parameters[0] != null && targetParams[0] != null) {
                    this.parameters[0].connect(targetParams[0], thisType -> classSource.isSuperType(methodDep.getMethod().getOwnerName(), thisType.getName()).orElse(false));
                }
                for (int i = 1; i < this.parameters.length; ++i) {
                    if (this.parameters[i] == null || targetParams[i] == null) continue;
                    this.parameters[i].connect(targetParams[i]);
                }
                if (this.result != null && methodDep.getResult() != null) {
                    methodDep.getResult().connect(this.result);
                }
                methodDep.getThrown().addConsumer(this.exceptionConsumer);
            }
        }
    }

    private static class ExceptionConsumer
    implements DependencyConsumer {
        private DependencyChecker checker;
        private ClassReader[] exceptions;
        private DependencyNode[] vars;
        private MethodDependency method;

        public ExceptionConsumer(DependencyChecker checker, ClassReader[] exceptions, DependencyNode[] vars, MethodDependency method) {
            this.checker = checker;
            this.exceptions = exceptions;
            this.vars = vars;
            this.method = method;
        }

        @Override
        public void consume(DependencyType type) {
            ClassReaderSource classSource = this.checker.getClassSource();
            for (int i = 0; i < this.exceptions.length; ++i) {
                if (this.exceptions[i] != null && !classSource.isSuperType(this.exceptions[i].getName(), type.getName()).orElse(false).booleanValue()) continue;
                if (this.vars[i] != null) {
                    this.vars[i].propagate(type);
                }
                return;
            }
            this.method.getThrown().propagate(type);
        }
    }
}

